/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.DragBlenderEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.MappingHighlightingEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.ComputedField;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Variable;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.services.IDropValidationService;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.ui.PlatformUI;

public class ComputedFieldDropEditPolicy
extends DiagramDragDropEditPolicy {
    private Command sourceFeedbackCommand = null;

    public void showTargetFeedback(Request request) {
        Command c = this.getCommand(request);
        if (c != null && c.canExecute() && this.revertColor == null) {
            this.revertColor = ((GraphicalEditPart)this.getHost()).getFigure().getBackgroundColor();
            this.opacity = ((GraphicalEditPart)this.getHost()).getFigure().isOpaque();
            ((GraphicalEditPart)this.getHost()).getFigure().setBackgroundColor(MapDiagramEditorPlugin.getInstance().mixColors(ColorConstants.blue, this.revertColor));
            ((GraphicalEditPart)this.getHost()).getFigure().setOpaque(true);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            ((GraphicalEditPart)this.getHost()).getFigure().setBackgroundColor(this.revertColor);
            ((GraphicalEditPart)this.getHost()).getFigure().setOpaque(this.opacity);
            this.revertColor = null;
        }
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        return this.createViewAndElement((IGraphicalEditPart)this.getHost(), dropRequest);
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    public Command createViewAndElement(IGraphicalEditPart selectedElement, DropObjectsRequest request) {
        Object dragObject;
        if (request.getObjects() != null && request.getObjects().size() > 0 && ((dragObject = request.getObjects().get(0)) instanceof ILogicalField || dragObject instanceof Variable)) {
            ComputedField trgObject = (ComputedField)selectedElement.resolveSemanticElement();
            String oldValue = "";
            if (trgObject.getFormula() != null) {
                oldValue = trgObject.getFormula();
            }
            String addValue = "";
            if (dragObject instanceof ILogicalField) {
                addValue = ((ILogicalField)dragObject).getFullPath();
                IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
                if (service.validate((EObject)dragObject, (EObject)trgObject, true) != IDropValidationService.DropResult.MAP_ALLOWED) {
                    return UnexecutableCommand.INSTANCE;
                }
            } else if (dragObject instanceof Variable) {
                Variable srcObject = (Variable)request.getObjects().get(0);
                addValue = "%{" + srcObject.getAlias().toString() + "}%";
            }
            String newValue = addValue;
            if (oldValue != null && !oldValue.trim().isEmpty()) {
                newValue = String.valueOf(oldValue) + " + " + addValue;
            }
            SetRequest srJoin = new SetRequest(selectedElement.getEditingDomain(), (EObject)trgObject, (EStructuralFeature)MapPackage.eINSTANCE.getComputedField_Formula(), (Object)newValue);
            SetValueCommand svc = new SetValueCommand(srJoin);
            CompoundCommand cmd = new CompoundCommand(Messages.ComputedFieldDropEditPolicy_5);
            cmd.add((Command)new ICommandProxy((ICommand)svc));
            return cmd;
        }
        return null;
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest && this.sourceFeedbackCommand != null && this.sourceFeedbackCommand.canUndo()) {
            this.sourceFeedbackCommand.undo();
            this.sourceFeedbackCommand = null;
        }
        super.eraseSourceFeedback(request);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest && this.sourceFeedbackCommand == null) {
            IContainer c = (IContainer)this.getHostObject().eContainer();
            Map map = (Map)c.eContainer();
            MappingHighlightingEditPolicy policy = (MappingHighlightingEditPolicy)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)map).getEditPolicy((Object)"hightlightMappingRole");
            IContainer highlightenContainer = policy == null ? null : policy.getSelectedTargetContainer();
            IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
            if (service != null) {
                ArrayList<IContainer> l = new ArrayList<IContainer>();
                HashMap<IContainer, IDropValidationService.DropResult> m = new HashMap<IContainer, IDropValidationService.DropResult>();
                for (IContainer t : map.getContainer()) {
                    if (t == c) continue;
                    IDropValidationService.DropResult res = service.validate((EObject)c, (EObject)t, true);
                    if (res == IDropValidationService.DropResult.NONE) {
                        l.add(t);
                        continue;
                    }
                    m.put(t, res);
                }
                if (!l.isEmpty() || !m.isEmpty()) {
                    EditPart mapPart = ((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)map);
                    CompoundCommand cc = new CompoundCommand();
                    cc.add(mapPart.getCommand((Request)new DragBlenderEditPolicy.BlendRequest(l, true)));
                    for (IContainer k : m.keySet()) {
                        if (highlightenContainer != null && !policy.isDataSetVisible(k.getDataset())) continue;
                        cc.add(mapPart.getCommand((Request)new DragBlenderEditPolicy.BorderRequest(k, (IDropValidationService.DropResult)m.get(k))));
                    }
                    if (cc != null && cc.canExecute()) {
                        this.sourceFeedbackCommand = cc;
                        cc.execute();
                    }
                }
            }
        }
        super.showSourceFeedback(request);
    }
}

