/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.actions.RemoveContainerFromDataSet;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.compute.validator.DataSetInheritanceValidator;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.helpers.command.builder.ConditionalJoinCommandBuilder;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.EMFCommandWrapper;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class DataSetInheritanceEditPolicy
extends ConnectionHandleEditPolicy {
    public static final String REQUEST_INHERIT_DATASET = "com.indy.gmf.map.diagram.custom.edit.policies.DataSetInheritanceEditPolicy.inheritDataSet";
    public static final String INHERITANCE_ROLE = "datSet.inheritance";
    public static final String REQUEST_REMOVE_FROM_DATASET = "datSet.removance";
    private EditPartListener editPartListener = new EditPartListener.Stub(){

        public void childAdded(EditPart child, int index) {
            DataSetInheritanceEditPolicy.this.registerMouseMotionListener((IGraphicalEditPart)child);
        }

        public void removingChild(EditPart child, int index) {
            DataSetInheritanceEditPolicy.this.unregisterMouseMotionListener((IGraphicalEditPart)child);
        }
    };

    private void unregisterMouseMotionListener(IGraphicalEditPart ep) {
        ep.removeEditPartListener(this.editPartListener);
        ep.getFigure().removeMouseMotionListener((MouseMotionListener)this);
        for (Object o : ep.getChildren()) {
            this.unregisterMouseMotionListener((IGraphicalEditPart)o);
        }
    }

    private void registerMouseMotionListener(IGraphicalEditPart ep) {
        ep.addEditPartListener(this.editPartListener);
        ep.getFigure().addMouseMotionListener((MouseMotionListener)this);
        for (Object o : ep.getChildren()) {
            this.registerMouseMotionListener((IGraphicalEditPart)o);
        }
    }

    public void activate() {
        this.getHost().addEditPartListener(this.editPartListener);
        super.activate();
        this.registerMouseMotionListener((IGraphicalEditPart)this.getHost());
    }

    public void deactivate() {
        this.getHost().removeEditPartListener(this.editPartListener);
        this.unregisterMouseMotionListener((IGraphicalEditPart)this.getHost());
        super.deactivate();
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        if (request instanceof InheritenceRequest) {
            return this.createInheritanceCommand((InheritenceRequest)request);
        }
        if (request instanceof RemoveContainerFromDataSet.RemoveFromDataSetRequest) {
            return this.createRemoveFromDataSetCommand((RemoveContainerFromDataSet.RemoveFromDataSetRequest)request);
        }
        return super.getCommand(request);
    }

    private org.eclipse.gef.commands.Command createRemoveFromDataSetCommand(RemoveContainerFromDataSet.RemoveFromDataSetRequest request) {
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)request.getJoin());
        if (editDomain != null) {
            CompoundCommand cc = new CompoundCommand();
            cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)EMFCommandWrapper.of((TransactionalEditingDomain)editDomain, (Command)ConditionalJoinCommandBuilder.INSTANCE.makeInheritanceJoinCommand(request.getJoin(), request.isFromLeftToRight()))));
            cc.add(new org.eclipse.gef.commands.Command(){

                public void execute() {
                    EObject modelElement = ((IGraphicalEditPart)DataSetInheritanceEditPolicy.this.getHost()).getPrimaryView().getDiagram().getElement();
                    List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)modelElement);
                    for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
                        nextEditPolicy.refresh();
                    }
                }
            });
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private org.eclipse.gef.commands.Command createInheritanceCommand(final InheritenceRequest request) {
        IContainer container = (IContainer)((IGraphicalEditPart)request.getSourceEditPart()).resolveSemanticElement();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
        CompoundCommand cc = new CompoundCommand();
        AbstractTransactionalCommand inheritCommand = new AbstractTransactionalCommand(domain, Messages.DataSetInheritanceEditPolicy_4, null){

            public boolean canExecute() {
                DataSet sourceDataSet;
                DataSet targetDataSet;
                EObject targetObj;
                if (request.getTargetEditPart() instanceof IGraphicalEditPart && (targetObj = ((IGraphicalEditPart)request.getTargetEditPart()).resolveSemanticElement()) instanceof IContainer && (targetDataSet = ((IContainer)targetObj).getDataset()) != (sourceDataSet = ((IContainer)((IGraphicalEditPart)request.getSourceEditPart()).resolveSemanticElement()).getDataset()) && !sourceDataSet.getChild().contains((Object)targetDataSet)) {
                    if (!request.isCheckJoinExistance()) {
                        if (!request.isFlipping()) {
                            try {
                                return !DataSetInheritanceValidator.INSTANCE.isLoop(sourceDataSet, targetDataSet);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        ILinkValidator.ValidationStatus st = DataSetInheritanceValidator.INSTANCE.canCreateLink((EObject)sourceDataSet, (EObject)targetDataSet, Util.currentKeyPressed == 65536);
                        if (st.isError()) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject targetObj = ((IGraphicalEditPart)request.getTargetEditPart()).resolveSemanticElement();
                DataSet targetDataSet = ((IContainer)targetObj).getDataset();
                DataSet sourceDataSet = ((IContainer)((IGraphicalEditPart)request.getSourceEditPart()).resolveSemanticElement()).getDataset();
                targetDataSet.getParent().add((Object)sourceDataSet);
                return CommandResult.newOKCommandResult();
            }
        };
        cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)inheritCommand));
        return cc;
    }

    protected List getHandleFigures() {
        return Collections.EMPTY_LIST;
    }

    public EditPart getTargetEditPart(Request request) {
        if (REQUEST_REMOVE_FROM_DATASET.equals(request.getType())) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    public static class InheritenceRequest
    extends CreateConnectionRequest {
        private boolean checkJoinExistance = true;
        private boolean flippingInheritence = false;

        public InheritenceRequest(boolean checkJoinExistance, boolean flippingInheritence, EditPart sourceEditPart) {
            this.setType(DataSetInheritanceEditPolicy.REQUEST_INHERIT_DATASET);
            this.checkJoinExistance = checkJoinExistance;
            this.flippingInheritence = flippingInheritence;
            this.setSourceEditPart(sourceEditPart);
        }

        public boolean isCheckJoinExistance() {
            return this.checkJoinExistance;
        }

        public boolean isFlipping() {
            return this.flippingInheritence;
        }
    }
}

