/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.MapDragDropEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.providers.MapElementTypes;
import com.stambia.md.MdNode;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;

class DropStageAreaOnMapPopupCommand
extends PopupMenuCommand {
    MapDragDropEditPolicy editPolicy;
    Point location;
    MdNode stageArea;
    Command wrappedCommand;

    DropStageAreaOnMapPopupCommand(MapDragDropEditPolicy editPolicy, Point location, MdNode stageArea) {
        super("", Display.getCurrent().getActiveShell());
        this.editPolicy = editPolicy;
        this.location = location;
        this.stageArea = stageArea;
        this.setPopupMenu(new PopupMenu(Arrays.asList(MenuEntry.values()), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MenuEntry)((Object)element)).getLabel();
            }
        }));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult popupMenuSelection = super.doExecuteWithResult(progressMonitor, info);
        if (!popupMenuSelection.getStatus().isOK()) {
            return popupMenuSelection;
        }
        Command cmd = null;
        MenuEntry menuResult = (MenuEntry)((Object)popupMenuSelection.getReturnValue());
        switch (menuResult) {
            case CREATE_OUTLINE: {
                cmd = this.createCommand(MapElementTypes.Outliner_2009);
                break;
            }
            case CREATE_STAGE: {
                cmd = this.createCommand(MapElementTypes.Query_2001);
            }
        }
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
            this.wrappedCommand = cmd;
        }
        return CommandResult.newOKCommandResult();
    }

    private Command createCommand(IElementType elementType) {
        CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, ((IHintedType)elementType).getSemanticHint(), this.editPolicy.getDiagramPreferencesHint());
        CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
        createRequest.setLocation(this.location);
        createRequest.getExtendedData().put("ref", this.stageArea);
        CompoundCommand cc = new CompoundCommand();
        cc.add(this.editPolicy.getHost().getCommand((Request)createRequest));
        return cc;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.wrappedCommand != null) {
            this.wrappedCommand.undo();
        }
        return super.doUndoWithResult(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.wrappedCommand != null) {
            this.wrappedCommand.redo();
        }
        return super.doRedoWithResult(progressMonitor, info);
    }

    static enum MenuEntry {
        CREATE_STAGE(Messages.MapDragDropEditPolicy_3),
        CREATE_OUTLINE(Messages.DropStageAreaOnMapPopupCommand_menuCreateSerializer);

        private String label;

        private MenuEntry(String label) {
            this.label = label;
        }

        String getLabel() {
            return this.label;
        }
    }
}

