/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.AbstractFieldDndEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.DataSetInheritanceEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.PromptFieldDropCommand;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.tools.LoopDetector;
import com.indy.map.compute.validator.DataSetOperatorValidator;
import com.indy.map.diagram.edit.parts.MapEditPart;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IMapReferencesSynchronizer;
import com.indy.map.util.synchro.impl.listeners.DataSetUpdater;
import com.indy.ui.custom.out.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class FieldDragDropEditPolicy
extends AbstractFieldDndEditPolicy {
    public static final String EXT_SRC_REF = "srcRef";
    public static final String EXT_TRG_REF = "trgRef";
    public static final String EXT_INHERIT = "inherit";

    private Point computeJoinLocation(ILogicalField srcObject, ILogicalField trgObject) {
        int newY;
        Rectangle rect;
        int newX;
        int x;
        GraphicalEditPart ep = (GraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)srcObject);
        GraphicalEditPart srcTableEditPart = (GraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), srcObject.eContainer());
        if (ep == null) {
            ep = srcTableEditPart;
        }
        GraphicalEditPart target_ep = (GraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)trgObject);
        GraphicalEditPart targetTableEditPart = (GraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), trgObject.eContainer());
        if (target_ep == null) {
            target_ep = targetTableEditPart;
        }
        Point srcLocation = ep != null ? ep.getFigure().getBounds().getLocation() : targetTableEditPart.getFigure().getBounds().getLocation();
        Point trgLocation = target_ep.getFigure().getBounds().getLocation();
        Rectangle srcBounds = srcTableEditPart.getFigure().getBounds();
        Rectangle targetBounds = targetTableEditPart.getFigure().getBounds();
        Dimension joinDimension = new Dimension(36, 24);
        int y = Math.abs(srcLocation.y - trgLocation.y) / 2;
        if (srcBounds.x + srcBounds.width / 2 < targetBounds.x) {
            x = Math.abs(srcBounds.x + srcBounds.width - targetBounds.x) / 2;
            newX = srcBounds.x + srcBounds.width + x;
        } else {
            x = Math.abs(targetBounds.x + targetBounds.width - srcBounds.x) / 2;
            newX = srcLocation.x - x;
        }
        if (srcLocation.y < trgLocation.y) {
            rect = ep.getFigure().getBounds();
            y = Math.abs(srcLocation.y + rect.height - trgLocation.y) / 2;
            newY = srcLocation.y + y;
        } else {
            rect = ep.getFigure().getBounds();
            y = Math.abs(srcLocation.y + rect.height - trgLocation.y - target_ep.getFigure().getBounds().height - joinDimension.height) / 2;
            newY = srcLocation.y - y;
        }
        Point newLocation = new Point(newX, newY);
        Rectangle joinsBounds = new Rectangle(newX, newY, joinDimension.width, joinDimension.height);
        Rectangle rSource = srcTableEditPart.getFigure().getBounds().getCopy().intersect(joinsBounds);
        Rectangle tSource = targetTableEditPart.getFigure().getBounds().getCopy().intersect(joinsBounds);
        if (!rSource.isEmpty() && rSource.x > 5 && rSource.y > 5 || !tSource.isEmpty() && tSource.x > 5 && tSource.y > 5) {
            Rectangle higher = null;
            Rectangle lower = null;
            Rectangle lefter = null;
            Rectangle righter = null;
            higher = srcBounds.y > targetBounds.y ? srcBounds : targetBounds;
            lower = srcBounds.y + srcBounds.height > targetBounds.y + targetBounds.height ? srcBounds : targetBounds;
            lefter = srcBounds.x < targetBounds.x ? srcBounds : targetBounds;
            righter = srcBounds.x + srcBounds.width > targetBounds.x + targetBounds.width ? srcBounds : targetBounds;
            int bottomPos = 0;
            bottomPos = lower == srcBounds ? targetBounds.y + targetBounds.height + joinDimension.height : srcBounds.y + srcBounds.height + joinDimension.height;
            int topPos = 0;
            topPos = higher == srcBounds ? targetBounds.y - joinDimension.height : srcBounds.y - joinDimension.height;
            int rightPos = 0;
            rightPos = righter == srcBounds ? targetBounds.x + targetBounds.width + joinDimension.width : srcBounds.x + srcBounds.width + joinDimension.width;
            int leftPos = 0;
            leftPos = lefter == srcBounds ? targetBounds.x - joinDimension.width : srcBounds.x - joinDimension.width;
            Point p = new Point(leftPos - 2, topPos - 2);
            Rectangle r = new Rectangle(p.x, p.y, joinDimension.width, joinDimension.height);
            ArrayList<Point> validate = new ArrayList<Point>();
            if (srcTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty() && targetTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty()) {
                validate.add(p);
            }
            p = new Point(leftPos - 2, bottomPos + 2);
            r = new Rectangle(p.x, p.y, joinDimension.width, joinDimension.height);
            if (srcTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty() && targetTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty()) {
                validate.add(p);
            }
            p = new Point(rightPos + 2, bottomPos + 2);
            r = new Rectangle(p.x, p.y, joinDimension.width, joinDimension.height);
            if (srcTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty() && targetTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty()) {
                validate.add(p);
            }
            p = new Point(rightPos + 2, topPos - 2);
            r = new Rectangle(p.x, p.y, joinDimension.width, joinDimension.height);
            if (srcTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty() && targetTableEditPart.getFigure().getBounds().getCopy().intersect(r).isEmpty()) {
                validate.add(p);
            }
            Point min = null;
            for (Point pp : validate) {
                if (min == null) {
                    min = pp;
                    continue;
                }
                if (!(pp.getDistance(newLocation) < min.getDistance(newLocation))) continue;
                min = pp;
            }
            if (min != null) {
                newLocation = min;
            }
        }
        ep.getFigure().translateToAbsolute((Translatable)newLocation);
        return newLocation;
    }

    @Override
    protected Command createInheritanceCommand(DropObjectsRequest request) {
        int old = Util.currentKeyPressed;
        Util.currentKeyPressed = 65536;
        if (request.getObjects() != null && request.getObjects().size() > 0 && request.getObjects().get(0) instanceof ILogicalField) {
            Command cmd = this.createJoinCommand((ILogicalField)request.getObjects().get(0));
            Util.currentKeyPressed = old;
            return cmd;
        }
        return null;
    }

    @Override
    protected Command createJoinOrOperatorCommand(DropObjectsRequest request) {
        DataSet filteredDataSet;
        ILogicalField trgObject = (ILogicalField)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        ILogicalField srcObject = (ILogicalField)request.getObjects().get(0);
        DataSet filterDataSet = ((IContainer)trgObject.eContainer()).getDataset();
        if (DataSetOperatorValidator.INSTANCE.canCreateLink(filterDataSet, filteredDataSet = ((IContainer)srcObject.eContainer()).getDataset()).isError()) {
            return this.createJoinCommand(srcObject);
        }
        return new ICommandProxy((ICommand)new PromptFieldDropCommand(false, this, request, Arrays.asList(AbstractFieldDndEditPolicy.CmdKind.JOIN, AbstractFieldDndEditPolicy.CmdKind.OPERATOR)));
    }

    @Override
    public Command createOperatorCommand(DropObjectsRequest request) {
        ILogicalField srcObject = (ILogicalField)request.getObjects().get(0);
        if (srcObject != null) {
            ILogicalField trgObject = (ILogicalField)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            MapEditPart mapEp = (MapEditPart)this.getHost().getRoot().getContents();
            CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(MapElementTypes.Operator_2008)), Node.class, ((IHintedType)MapElementTypes.Operator_2008).getSemanticHint(), mapEp.getDiagramPreferencesHint());
            CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
            createRequest.setLocation(this.computeJoinLocation(srcObject, trgObject));
            createRequest.getExtendedData().put(EXT_SRC_REF, srcObject);
            createRequest.getExtendedData().put(EXT_TRG_REF, trgObject);
            CompoundCommand cmd = new CompoundCommand(Messages.FieldDragDropEditPolicy_8);
            Command c = mapEp.getCommand((Request)createRequest);
            cmd.add(c);
            cmd.add(this.getSelectNewObjectCommand(createRequest));
            return cmd;
        }
        return null;
    }

    @Override
    protected Command createJoinCommand(final ILogicalField srcObject) {
        if (srcObject != null) {
            boolean ctrlIspressed;
            final ILogicalField trgObject = (ILogicalField)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            MapEditPart mapEp = (MapEditPart)this.getHost().getRoot().getContents();
            boolean bl = ctrlIspressed = Util.currentKeyPressed == 262144;
            if (!ctrlIspressed) {
                IContainer src1 = (IContainer)srcObject.eContainer();
                IContainer trg1 = (IContainer)trgObject.eContainer();
                Join join = null;
                for (final Join _join : ((Map)src1.eContainer()).getJoin()) {
                    if ((_join.getLeft() != src1 || _join.getRight() != trg1) && (_join.getLeft() != trg1 || _join.getRight() != src1)) continue;
                    join = _join;
                    break;
                }
                if (join != null && Util.currentKeyPressed != 65536) {
                    Join _join;
                    _join = join;
                    return new ICommandProxy((ICommand)new AbstractTransactionalCommand(TransactionUtil.getEditingDomain(join), Messages.FieldDragDropEditPolicy_9, null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            String expression = srcObject.getFullPath();
                            expression = String.valueOf(expression) + " = " + trgObject.getFullPath();
                            if (_join.getExpression() != null && !_join.getExpression().trim().isEmpty()) {
                                _join.setExpression(String.valueOf(_join.getExpression()) + "\nand " + expression);
                            } else {
                                _join.setExpression(expression);
                            }
                            return CommandResult.newOKCommandResult((Object)_join);
                        }
                    });
                }
            }
            CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(MapElementTypes.Join_2005)), Node.class, ((IHintedType)MapElementTypes.Join_2005).getSemanticHint(), mapEp.getDiagramPreferencesHint());
            CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
            createRequest.setLocation(this.computeJoinLocation(srcObject, trgObject));
            createRequest.getExtendedData().put(EXT_SRC_REF, srcObject);
            createRequest.getExtendedData().put(EXT_TRG_REF, trgObject);
            IAdaptable newObject = (IAdaptable)((List)createRequest.getNewObject()).get(0);
            CompoundCommand cmd = new CompoundCommand(Messages.FieldDragDropEditPolicy_12);
            if (Util.currentKeyPressed == 65536) {
                cmd.add((Command)new CommandDataSetMergingEnablement(false, ((IMapResource)srcObject.eResource()).getReferenceSynchronizer()));
                Map mapModel = (Map)trgObject.eContainer().eContainer();
                Graph graph = GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.DATASET, (Object)mapModel);
                Vertice vSource = graph.getVertice((Object)srcObject.eContainer());
                Vertice vTarget = graph.getVertice((Object)trgObject.eContainer());
                if (vSource != null) {
                    // empty if block
                }
                graph.createEdge(vSource, vTarget);
                LoopDetector detector = new LoopDetector(graph);
                if (detector.hasLoop_Tarjan()) {
                    cmd.add((Command)UnexecutableCommand.INSTANCE);
                } else {
                    createRequest.getExtendedData().put(EXT_INHERIT, Boolean.TRUE);
                }
            }
            Command c = mapEp.getCommand((Request)createRequest);
            cmd.add(c);
            if (Util.currentKeyPressed == 65536) {
                Command inheritCmd;
                IGraphicalEditPart srcEditPart = (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), srcObject.eContainer());
                DataSetInheritanceEditPolicy.InheritenceRequest req = new DataSetInheritanceEditPolicy.InheritenceRequest(false, false, (EditPart)srcEditPart);
                IGraphicalEditPart containerEditPart = (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), this.getHostObject().eContainer());
                req.setTargetEditPart((EditPart)containerEditPart);
                if (!((IContainer)srcObject.eContainer()).getDataset().getChild().contains((Object)((IContainer)this.getHostObject().eContainer()).getDataset()) && (inheritCmd = containerEditPart.getCommand((Request)req)) != null) {
                    cmd.add(inheritCmd);
                }
                cmd.add((Command)new CommandDataSetMergingEnablement(true, ((IMapResource)srcObject.eResource()).getReferenceSynchronizer()));
            }
            cmd.add(this.getSelectNewObjectCommand(createRequest));
            return cmd;
        }
        return null;
    }

    private Command getSelectNewObjectCommand(final CreateViewAndElementRequest createRequest) {
        return new Command(Messages.FieldDragDropEditPolicy_13){

            public boolean canExecute() {
                return true;
            }

            public void execute() {
                Clause obj = (Clause)createRequest.getViewAndElementDescriptor().getElementAdapter().getAdapter(Clause.class);
                EditPart ep = ((IGraphicalEditPart)FieldDragDropEditPolicy.this.getHost()).findEditPart((EditPart)FieldDragDropEditPolicy.this.getHost().getRoot(), (EObject)obj);
                if (ep != null) {
                    ep.getViewer().setSelection((ISelection)new StructuredSelection((Object)ep));
                }
            }
        };
    }

    private class CommandDataSetMergingEnablement
    extends Command {
        private boolean enable;

        public CommandDataSetMergingEnablement(boolean enabled, IMapReferencesSynchronizer synchronizer) {
            this.enable = enabled;
        }

        public void execute() {
            DataSetUpdater.INSTANCE.setEnabledDataSetMergeOnJoinCreation(this.enable);
        }

        public void undo() {
            DataSetUpdater.INSTANCE.setEnabledDataSetMergeOnJoinCreation(!this.enable);
        }

        public void redo() {
            this.execute();
        }
    }
}

