/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.tools.NorthToolEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.ToolHandle;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.MapPackage;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.ref.RField;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LayerEditPolicy
extends GraphicalEditPolicy {
    public static final String FILTER_LAYER_ROLE = "role.filterLayer";
    public static final String REQUEST_CREATE_LAYER = "com.indy.gmf.map.diagram.custom.edit.policies.layer.request.createLayer";
    private static final String ROOT = Messages.LayerEditPolicy_2;
    public static final String PROP_LAYER_ORIGIN = "layer.origin";
    private static Image ENABLED_IMAGE = MapIconAPI.getImage((String)"full/obj16x16/layer_16x16.png");
    private static Image DISABLED_IMAGE = new Image((Device)Display.getDefault(), ENABLED_IMAGE, 1);
    private Field selectedRootField;
    private Adapter semanticListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == MapPackage.eINSTANCE.getDatastore_Layer()) {
                LayerEditPolicy.this.updateFigure();
            }
        }
    };
    private IFigure figure;
    private IFigure referenceFigure;
    private Locator locator = null;
    private FigureListener referenceFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            LayerEditPolicy.this.locator.relocate(LayerEditPolicy.this.figure);
        }
    };
    private Shell shell;
    private Viewer layersViewer;

    private void createFigure() {
        this.figure = new AbstractHandle(){

            protected IFigure getOwnerFigure() {
                return LayerEditPolicy.this.referenceFigure;
            }

            public IFigure findFigureAt(int x, int y, TreeSearch search) {
                if (this.getBounds().contains(x, y)) {
                    return this;
                }
                return super.findFigureAt(x, y, search);
            }

            protected DragTracker createDragTracker() {
                return new DragEditPartsTrackerEx(LayerEditPolicy.this.getHost()){

                    protected boolean handleButtonDown(int button) {
                        LayerEditPolicy.this.showLayer(this.getStartLocation());
                        return true;
                    }
                };
            }

            public Locator getLocator() {
                return LayerEditPolicy.this.locator;
            }
        };
        this.figure.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ((IFigure)me.getSource()).setBorder(ToolHandle.HOVER_BORDER);
            }

            public void mouseExited(MouseEvent me) {
                ((IFigure)me.getSource()).setBorder(ToolHandle.NO_BORDER);
            }
        });
        this.figure.setLayoutManager((LayoutManager)new StackLayout());
        this.figure.add((IFigure)new ImageFigure(DISABLED_IMAGE));
        this.figure.setVisible(false);
        this.updateFigure();
        this.figure.setBorder(ToolHandle.NO_BORDER);
        this.referenceFigure = ((NorthToolEditPolicy)this.getHost().getEditPolicy((Object)"nothTool.role")).getFigure();
        this.locator = new RelativeLocator(this.referenceFigure, 16){

            public void relocate(IFigure target) {
                IFigure reference = this.getReferenceFigure();
                PrecisionRectangle refBounds = new PrecisionRectangle(this.getReferenceBox());
                reference.translateToAbsolute((Translatable)refBounds);
                target.getParent().translateToRelative((Translatable)refBounds);
                refBounds.resize(1, 1);
                Dimension targetSize = target.getPreferredSize();
                refBounds.x += refBounds.width;
                if (refBounds.height < targetSize.height) {
                    refBounds.y -= targetSize.height;
                }
                refBounds.setSize(targetSize);
                target.setBounds((Rectangle)refBounds);
            }
        };
        this.referenceFigure.addFigureListener(this.referenceFigureListener);
        this.getLayer("Handle Layer").add(this.figure);
    }

    private void updateFigure() {
        EObject o = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (o instanceof Datastore) {
            Datastore ds = (Datastore)o;
            this.figure.setVisible(!ds.getLayer().isEmpty());
            if (this.selectedRootField == null) {
                ((ImageFigure)this.figure.getChildren().get(0)).setImage(DISABLED_IMAGE);
            } else {
                ((ImageFigure)this.figure.getChildren().get(0)).setImage(ENABLED_IMAGE);
            }
        }
    }

    public Command getCommand(Request request) {
        if (REQUEST_CREATE_LAYER.equals(request.getType())) {
            final Field f = (Field)request.getExtendedData().get(PROP_LAYER_ORIGIN);
            return new Command(){
                WeakReference oldRef;

                public void dispose() {
                    this.oldRef = null;
                    super.dispose();
                }

                public void execute() {
                    this.oldRef = new WeakReference<Field>(LayerEditPolicy.this.selectedRootField);
                    LayerEditPolicy.this.enableLayer(f);
                }

                public void undo() {
                    if (this.oldRef != null) {
                        Field ff = (Field)this.oldRef.get();
                        LayerEditPolicy.this.enableLayer(ff);
                    }
                    this.oldRef = null;
                }

                public boolean canExecute() {
                    return true;
                }

                public boolean canUndo() {
                    return true;
                }
            };
        }
        return super.getCommand(request);
    }

    public void activate() {
        if (this.selectedRootField != null && this.selectedRootField.eResource() == null) {
            this.selectedRootField = null;
        }
        this.createFigure();
        EObject o = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (o != null) {
            o.eAdapters().add((Object)this.semanticListener);
        }
        super.activate();
    }

    public void deactivate() {
        this.figure.getParent().remove(this.figure);
        if (this.semanticListener != null && this.semanticListener.getTarget() != null) {
            this.semanticListener.getTarget().eAdapters().remove((Object)this.semanticListener);
        }
        this.referenceFigure.removeFigureListener(this.referenceFigureListener);
        super.deactivate();
    }

    private void createPopup() {
        this.shell = new Shell(this.getHost().getViewer().getControl().getShell(), 4);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        Label l = new Label((Composite)this.shell, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.LayerEditPolicy_5);
        l.setBackground(this.shell.getBackground());
        TableViewer viewer = new TableViewer((Composite)this.shell, 2560);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 == ROOT) {
                    return -1;
                }
                if (e2 == ROOT) {
                    return 1;
                }
                if (e1 == e2) {
                    return 0;
                }
                Field f1 = (Field)e1;
                Field f2 = (Field)e2;
                if (f1.getParent() == f2.getParent()) {
                    return f1.getName().compareTo(f2.getName());
                }
                if (f1.getAncestors().contains(f2)) {
                    return 1;
                }
                if (f2.getAncestors().contains(f1)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(MapDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()){

            public String getColumnText(Object object, int i) {
                if (object == ROOT) {
                    return ROOT;
                }
                return ((RField)((Field)object).getMapReference()).getFullName();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object f = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (f instanceof Field) {
                    LayerEditPolicy.this.enableLayer((Field)f);
                } else {
                    LayerEditPolicy.this.enableLayer(null);
                }
            }
        });
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Field) {
                    View v = (View)LayerEditPolicy.this.getHost().getModel();
                    if ("datastore.view".equals(v.getType())) {
                        Field f = (Field)((NodeView)v).getSubElement();
                        if (f.getAncestors().contains(element)) {
                            return false;
                        }
                        if (!((Field)element).getAncestors().contains(f)) {
                            return false;
                        }
                    } else {
                        for (Field f : ((Datastore)v.getElement()).getSubsetRootField()) {
                            if (!((Field)element).getAncestors().contains(f)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        });
        MenuManager mgr = new MenuManager();
        final DeleteAction action = new DeleteAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()){

            protected void init() {
                super.init();
                this.setEnabled(false);
            }

            public Command createDeleteCommand(final List objects) {
                final Datastore c = (Datastore)((IGraphicalEditPart)LayerEditPolicy.this.getHost()).resolveSemanticElement();
                return new ICommandProxy((ICommand)new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)c), Messages.LayerEditPolicy_6, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        c.getLayer().removeAll((Collection)objects);
                        ((Collection)LayerEditPolicy.this.layersViewer.getInput()).removeAll(objects);
                        LayerEditPolicy.this.layersViewer.refresh();
                        if (c.getLayer().isEmpty()) {
                            LayerEditPolicy.this.shell.close();
                            LayerEditPolicy.this.updateFigure();
                        } else {
                            LayerEditPolicy.this.layersViewer.setSelection((ISelection)new StructuredSelection((Object)ROOT));
                        }
                        LayerEditPolicy.this.enableLayer(null);
                        return CommandResult.newOKCommandResult();
                    }
                });
            }

            public boolean isEnabled() {
                IStructuredSelection s = (IStructuredSelection)LayerEditPolicy.this.layersViewer.getSelection();
                return !s.isEmpty() && s.getFirstElement() != ROOT;
            }
        };
        mgr.add((IAction)action);
        action.setSelectionProvider((ISelectionProvider)viewer);
        viewer.getTable().setMenu(mgr.createContextMenu(viewer.getControl()));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                action.update();
            }
        });
        this.layersViewer = viewer;
    }

    protected void showLayer(Point point) {
        if (this.shell == null || this.shell.isDisposed()) {
            this.createPopup();
        }
        org.eclipse.swt.graphics.Point p = this.getHost().getViewer().getControl().toDisplay(point.x, point.y);
        Datastore ds = (Datastore)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        ArrayList<String> l = new ArrayList<String>();
        l.add(ROOT);
        l.addAll((Collection<String>)ds.getLayer());
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                org.eclipse.swt.graphics.Rectangle bounds = LayerEditPolicy.this.shell.getBounds();
                if (!bounds.contains(((Control)event.widget).toDisplay(event.x, event.y))) {
                    LayerEditPolicy.this.shell.close();
                    LayerEditPolicy.this.shell.dispose();
                    LayerEditPolicy.this.shell = null;
                }
            }
        };
        this.shell.getDisplay().addFilter(3, clickListener);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.display.removeFilter(3, clickListener);
            }
        });
        this.shell.open();
        this.layersViewer.setInput(l);
        org.eclipse.swt.graphics.Point preferredSize = this.shell.computeSize(-1, -1, true);
        if (p.y > preferredSize.y) {
            this.shell.setSize(preferredSize);
            this.shell.setLocation(new org.eclipse.swt.graphics.Point(p.x, p.y - preferredSize.y));
        } else {
            preferredSize.y = p.y;
            this.shell.setSize(preferredSize);
            this.shell.setLocation(new org.eclipse.swt.graphics.Point(p.x, 0));
        }
    }

    protected void hideLayer() {
    }

    protected void enableLayer(Field layerField) {
        if (this.selectedRootField != layerField) {
            this.selectedRootField = layerField;
            IGraphicalEditPart editPart = ((IGraphicalEditPart)this.getHost()).getChildBySemanticHint(MapVisualIDRegistry.getType(7004));
            editPart.refresh();
            this.updateFigure();
        }
    }

    protected void createLayer(Field rootField) {
    }

    protected void deleteLayer(Field rootField) {
    }

    public List<View> getVisibleChildren() {
        ArrayList<View> res = new ArrayList<View>();
        IGraphicalEditPart editPart = ((IGraphicalEditPart)this.getHost()).getChildBySemanticHint(MapVisualIDRegistry.getType(7004));
        if (editPart != null) {
            View fieldCompartmentView = editPart.getNotationView();
            if (this.selectedRootField == null) {
                return fieldCompartmentView.getChildren();
            }
            Datastore container = (Datastore)this.selectedRootField.eContainer();
            ArrayList<Field> descendantsRootOfSelected = new ArrayList<Field>();
            for (Field f : container.getLayer()) {
                if (!f.getAncestors().contains(this.selectedRootField)) continue;
                descendantsRootOfSelected.add(f);
            }
            Iterator it = descendantsRootOfSelected.iterator();
            block1: while (it.hasNext()) {
                Field f = (Field)it.next();
                for (Field s : descendantsRootOfSelected) {
                    if (f == s || !f.getAncestors().contains(s)) continue;
                    it.remove();
                    continue block1;
                }
            }
            for (Object o : fieldCompartmentView.getChildren()) {
                EObject e;
                if (!(o instanceof View) || !((e = ((View)o).getElement()) instanceof Field)) continue;
                Field f = (Field)e;
                if (f == this.selectedRootField) {
                    res.add((View)o);
                    continue;
                }
                List ancestors = f.getAncestors();
                if (!ancestors.contains(this.selectedRootField)) continue;
                boolean containedByOtherLayers = false;
                for (Field c : descendantsRootOfSelected) {
                    if (!ancestors.contains(c)) continue;
                    containedByOtherLayers = true;
                    break;
                }
                if (containedByOtherLayers) continue;
                res.add((View)o);
            }
        }
        return res;
    }
}

