/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.ContainerSelectionEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.DataSetDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.SourceSetDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.NorthToolEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.compute.validator.JoinValidator;
import com.indy.map.compute.validator.MappingValidator;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RTemplate;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

public class MappingHighlightingEditPolicy
extends GraphicalEditPolicy {
    public static final String ROLE_HIGHLIGHT_MAPPING = "hightlightMappingRole";
    private WeakReference<IContainer> selectedContainer;
    private EContentAdapter semanticAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            IContainer c;
            super.notifyChanged(notification);
            if (!(notification.getFeature() != MapPackage.eINSTANCE.getDatastore_SetDescriptor() && notification.getFeature() != MapPackage.eINSTANCE.getQuery_SetDescriptor() || notification.getEventType() != 4 && notification.getEventType() != 6 || (c = (IContainer)notification.getNotifier()) != MappingHighlightingEditPolicy.this.getSelectedTargetContainer() || !c.getSetDescriptor().isEmpty())) {
                MappingHighlightingEditPolicy.this.setSelectedTargetContainer(null);
            }
        }
    };

    public IContainer getSelectedTargetContainer() {
        if (this.selectedContainer == null) {
            return null;
        }
        return (IContainer)this.selectedContainer.get();
    }

    public void activate() {
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (map != null) {
            map.eAdapters().add((Object)this.semanticAdapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.semanticAdapter.getTarget() != null) {
            this.semanticAdapter.getTarget().eAdapters().remove((Object)this.semanticAdapter);
        }
        super.deactivate();
    }

    public void setSelectedTargetContainer(IContainer container) {
        this.removeHighlighting();
        this.selectedContainer = new WeakReference<IContainer>(container);
        boolean enableSelectionTitleColoringEditPolicy = container != null;
        ContainerSelectionEditPolicy ep = (ContainerSelectionEditPolicy)this.getHost().getEditPolicy((Object)"containerHeaderColorRole");
        if (ep != null) {
            ep.setEnabled(enableSelectionTitleColoringEditPolicy);
        }
        this.highlightSelection();
        DataSetDecorationEditPolicy policy = (DataSetDecorationEditPolicy)this.getHost().getEditPolicy((Object)"dataSet.role");
        if (policy != null) {
            policy.refresh();
        }
    }

    private Map getMapModel() {
        EObject obj = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    void removeHighlighting() {
        SourceSetDecorationEditPolicy editPolicy = (SourceSetDecorationEditPolicy)this.getHost().getEditPolicy((Object)"sourceSet.role");
        if (editPolicy != null) {
            editPolicy.setCurrentSourceSet(null);
        }
        this.selectedContainer = null;
        for (Object o : this.getHost().getChildren()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)o;
            IFigure f = gep.getContentPane();
            if (f instanceof IBlendableFigure) {
                ((IBlendableFigure)gep.getContentPane()).setAlphaBlended(false);
            }
            gep.activate();
            for (Object c : gep.getSourceConnections()) {
                IFigure _f = ((ConnectionEditPart)c).getFigure();
                if (_f instanceof IBlendableFigure) {
                    ((IBlendableFigure)_f).setAlphaBlended(false);
                }
                if (!(c instanceof LinkEditPart)) continue;
                ((LinkEditPart)c).refresh();
            }
        }
        for (Object o : this.getHost().getChildren()) {
            NorthToolEditPolicy policy;
            if (!(o instanceof ContainerEditPart) || (policy = (NorthToolEditPolicy)((EditPart)o).getEditPolicy((Object)"nothTool.role")) == null) continue;
            policy.refresh();
        }
    }

    void highlightSelection() {
        SourceSetDecorationEditPolicy editPolicy = (SourceSetDecorationEditPolicy)this.getHost().getEditPolicy((Object)"sourceSet.role");
        if (this.selectedContainer == null) {
            editPolicy.setCurrentSourceSet(null);
            for (Object o : this.getHost().getChildren()) {
                NorthToolEditPolicy policy;
                if (!(o instanceof ContainerEditPart) || (policy = (NorthToolEditPolicy)((EditPart)o).getEditPolicy((Object)"nothTool.role")) == null) continue;
                policy.refresh();
            }
            return;
        }
        IContainer container = (IContainer)this.selectedContainer.get();
        if (editPolicy != null) {
            editPolicy.setCurrentSourceSet(container);
        }
        for (Object o : this.getHost().getChildren()) {
            NorthToolEditPolicy policy;
            if (!(o instanceof ContainerEditPart) || (policy = (NorthToolEditPolicy)((EditPart)o).getEditPolicy((Object)"nothTool.role")) == null) continue;
            policy.refresh();
        }
        if (container == null) {
            return;
        }
        RTargetSet ts = ((RMap)this.getMapModel().getMapReference()).getTargetSetRef(container);
        if (ts == null) {
            return;
        }
        ArrayList<Object> visibleItems = new ArrayList<Object>();
        for (DataSet ds : ts.getSourceSet().getDataSet()) {
            visibleItems.addAll((Collection<Object>)ds.getContainer());
            visibleItems.addAll(ds.getJoin());
            for (DataSet p : ds.getChild()) {
                Join join;
                if (ts.getSourceSet().getDataSet().contains((Object)p) || (join = ds.getJoin4Child(p)) == null) continue;
                visibleItems.remove(join);
            }
            visibleItems.addAll(ds.getFilter());
            visibleItems.addAll(ds.getOperator());
        }
        visibleItems.add(container);
        for (Template t : this.getMapModel().getTemplate()) {
            if (t.getName().startsWith("I") || t.getName().startsWith("R")) {
                if (!((RTemplate)t.getMapReference()).getTargetRef().contains((Object)container)) continue;
                visibleItems.add(t);
                continue;
            }
            if (Collections.disjoint(((RTemplate)t.getMapReference()).getRef(), visibleItems)) continue;
            visibleItems.add(t);
        }
        ArrayList<IContainer> usable = new ArrayList<IContainer>();
        block5: for (IContainer c : this.getMapModel().getContainer()) {
            if (c == container || visibleItems.contains(c)) continue;
            if (!MappingValidator.INSTANCE.canCreateLink((EObject)c, (EObject)container).isError()) {
                usable.add(c);
                usable.addAll(c.getDataset().getJoin());
                continue;
            }
            boolean canBeJoined = false;
            for (MapModelItem mapModelItem : visibleItems) {
                if (mapModelItem instanceof IContainer && !JoinValidator.INSTANCE.canCreateLink((EObject)mapModelItem, (EObject)c).isError()) {
                    canBeJoined = true;
                    continue block5;
                }
                if (!canBeJoined) continue;
                usable.add(c);
            }
        }
        for (Object obj : this.getHost().getChildren()) {
            IFigure iFigure;
            EObject it = ((IGraphicalEditPart)obj).resolveSemanticElement();
            if (!visibleItems.contains(it) && !usable.contains(it) && (iFigure = ((IGraphicalEditPart)obj).getContentPane()) instanceof IBlendableFigure) {
                ((IBlendableFigure)iFigure).setAlphaBlended(true);
                ((IGraphicalEditPart)obj).deactivate();
            }
            for (Object e : ((IGraphicalEditPart)obj).getSourceConnections()) {
                IFigure f;
                IFigure f2;
                EObject itTarget = ((IGraphicalEditPart)((ConnectionEditPart)e).getTarget()).resolveSemanticElement();
                EObject itSource = ((IGraphicalEditPart)((ConnectionEditPart)e).getSource()).resolveSemanticElement();
                if ((!visibleItems.contains(itTarget) && !usable.contains(itTarget) || !visibleItems.contains(itSource) && !usable.contains(itSource)) && (f2 = ((ConnectionEditPart)e).getFigure()) instanceof IBlendableFigure) {
                    ((IBlendableFigure)((ConnectionEditPart)e).getFigure()).setAlphaBlended(true);
                }
                if (!(e instanceof LinkEditPart)) continue;
                if ("targetSetLink".equals(((LinkEditPart)e).getNotationView().getType()) && itSource != this.getSelectedTargetContainer() && (f = ((ConnectionEditPart)e).getFigure()) instanceof IBlendableFigure) {
                    ((IBlendableFigure)((ConnectionEditPart)e).getFigure()).setAlphaBlended(true);
                }
                ((LinkEditPart)e).refresh();
            }
        }
        for (Object o : this.getHost().getChildren()) {
            NorthToolEditPolicy policy;
            if (!(o instanceof ContainerEditPart) || (policy = (NorthToolEditPolicy)((EditPart)o).getEditPolicy((Object)"nothTool.role")) == null) continue;
            policy.refresh();
        }
    }

    public boolean isDataSetVisible(DataSet ds) {
        IFigure f;
        IGraphicalEditPart ep;
        if (!ds.getContainer().isEmpty() && (ep = (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart(this.getHost(), (EObject)ds.getContainer().get(0))) != null && (f = ep.getContentPane()) instanceof IBlendableFigure) {
            return !((IBlendableFigure)f).isAlphaBlended();
        }
        return false;
    }

    public void refresh() {
        this.setSelectedTargetContainer(this.getSelectedTargetContainer());
    }
}

