/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.MapDiagramUtil;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.ColorContainerHeaderEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.PopupPropertyControler;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.gmf.proc.ActionProcess;
import com.indy.map.IContainer;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RefPackage;
import com.indy.ui.custom.out.Activator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class TemplateToolEditPolicy
extends GraphicalEditPolicyEx
implements ZoomListener,
ISelectionChangedListener {
    public static final String TEMPLATE_ROLE = "templatesTool.role";
    private static final int PICT_SIZE = 22;
    private static final MarginBorder NO_BORDER = new MarginBorder(new Insets(1, 1, 1, 1));
    private static final LineBorder SELECTED = new LineBorder(Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor.selected")));
    private static final LineBorder HOVER = new LineBorder(Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor.selected")));
    public static final String REQ_SELECT_TEMPLATE_TOOL = "com.indy.gmf.map.diagram.custom.edit.policies.TemplateToolEditPolicy.request.selectTool";
    public static final String EXT_TEMPLATE = "com.indy.gmf.map.diagram.custom.edit.policies.TemplateToolEditPolicy.template";
    private static WeakHashMap<EditPart, WeakReference<Template>> selectedTemplates = new WeakHashMap();
    private WeakReference<TemplatePropertyHandle> lastProp;
    private static WeakReference<TemplatePropertyHandle> lastShown;
    EContentAdapter refAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getFeature() == RefPackage.eINSTANCE.getRMap_TemplateRef()) {
                if (notification.getEventType() == 4 || notification.getEventType() == 6) {
                    TemplateToolEditPolicy.this.refresh();
                }
            } else if (notification.getFeature() == RefPackage.eINSTANCE.getRTemplate_Description()) {
                Template t = (Template)((RTemplate)notification.getNotifier()).getDataModel();
                for (TemplateHandle h : TemplateToolEditPolicy.this.toolHandles) {
                    if (h.template != t) continue;
                    h.refreshToolTip();
                }
            } else if (notification.getFeature() == RefPackage.eINSTANCE.getRTemplate_TargetRef()) {
                if (notification.getEventType() == 3 || notification.getEventType() == 5 || notification.getEventType() == 4 || notification.getEventType() == 6) {
                    TemplateToolEditPolicy.this.refresh();
                }
            } else if (notification.getFeature() == RefPackage.eINSTANCE.getRItem_Problem()) {
                TemplateToolEditPolicy.this.refresh();
            }
        }
    };
    private List<TemplateHandle> toolHandles = new ArrayList<TemplateHandle>();

    protected void setSelectedTemplate(Template t) {
        for (Object o : this.getHost().getParent().getChildren()) {
            TemplateToolEditPolicy p;
            if (!(o instanceof ContainerEditPart) || (p = (TemplateToolEditPolicy)((ContainerEditPart)o).getEditPolicy(TEMPLATE_ROLE)) == null) continue;
            p.updateTemplate(t);
        }
    }

    private void updateTemplate(Template t) {
        WeakReference<Template> ref;
        CompoundCommand headerColorCommand = new CompoundCommand();
        for (TemplateHandle h : this.toolHandles) {
            h.setSelected(h.getTemplate() == t);
        }
        if (t == null) {
            ref = selectedTemplates.get(this.getHost().getParent());
            if (ref != null && ref.get() != null) {
                EObject o = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
                for (IContainer c : ((Map)o.eContainer()).getContainer()) {
                    Command cmd;
                    IGraphicalEditPart gep = (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart(this.getHost().getParent(), (EObject)c);
                    if (gep == null || (cmd = gep.getCommand((Request)new ColorContainerHeaderEditPolicy.ColorHeaderRequest(ColorConstants.white.getRGB(), ColorConstants.black.getRGB(), false, false))) == null) continue;
                    headerColorCommand.add(cmd);
                }
                headerColorCommand.execute();
                selectedTemplates.remove(this.getHost().getParent());
            }
        } else {
            ref = selectedTemplates.get(this.getHost().getParent());
            if (ref == null || ref.get() != t) {
                RGB targetRGB = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
                RGB sourceRGB = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
                RTemplate tplRef = (RTemplate)t.getMapReference();
                for (IContainer c : ((Map)t.eContainer()).getContainer()) {
                    IGraphicalEditPart gep = (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart(this.getHost().getParent(), (EObject)c);
                    if (gep == null) continue;
                    Command cmd = null;
                    cmd = tplRef.getTargetRef().contains((Object)c) ? gep.getCommand((Request)new ColorContainerHeaderEditPolicy.ColorHeaderRequest(targetRGB, ColorConstants.white.getRGB(), true, true)) : (tplRef.getRef().contains(c) ? gep.getCommand((Request)new ColorContainerHeaderEditPolicy.ColorHeaderRequest(sourceRGB, ColorConstants.white.getRGB(), true, true)) : gep.getCommand((Request)new ColorContainerHeaderEditPolicy.ColorHeaderRequest(ColorConstants.white.getRGB(), ColorConstants.black.getRGB(), false, false)));
                    if (cmd == null) continue;
                    headerColorCommand.add(cmd);
                }
                headerColorCommand.execute();
                selectedTemplates.put(this.getHost().getParent(), new WeakReference<Template>(t));
            }
        }
    }

    public static void clearLastShown() {
        lastShown = null;
    }

    public Command getCommand(Request request) {
        if (REQ_SELECT_TEMPLATE_TOOL.equals(request.getType())) {
            Template tpl = (Template)request.getExtendedData().get(EXT_TEMPLATE);
            CompoundCommand cc = new CompoundCommand();
            for (TemplateHandle h : this.toolHandles) {
                if (tpl == null) {
                    cc.add((Command)new SelectTemplateCommand(h, false));
                    continue;
                }
                cc.add((Command)new SelectTemplateCommand(h, h.template == tpl));
            }
            if (!cc.isEmpty()) {
                return cc;
            }
        }
        return super.getCommand(request);
    }

    void createToolHandles() {
        IContainer container = this.getSemanticModel();
        if (container == null || container.eResource() == null) {
            return;
        }
        int count = 0;
        if (((RMap)((Map)container.eContainer()).getMapReference()).getTargetSetRef(container) == null) {
            return;
        }
        ArrayList<Template> tpl = new ArrayList<Template>();
        for (Template t : ((Map)container.eContainer()).getTemplate()) {
            if (!((RTemplate)t.getMapReference()).getTargetRef().contains((Object)container)) continue;
            tpl.add(t);
        }
        Collections.sort(tpl, new Comparator<Template>(){

            protected int getWeight(String s) {
                if (s.startsWith("L")) {
                    return 10;
                }
                if (s.startsWith("O")) {
                    return 100;
                }
                if (s.startsWith("I")) {
                    return 1000;
                }
                return 10000;
            }

            @Override
            public int compare(Template o1, Template o2) {
                int i2;
                String s = o1.getName();
                String s2 = o2.getName();
                int i1 = this.getWeight(s);
                if (i1 != (i2 = this.getWeight(s2))) {
                    return Integer.valueOf(i1).compareTo(i2);
                }
                return s.compareTo(s2);
            }
        });
        for (Template t : tpl) {
            TemplateHandle th = new TemplateHandle((GraphicalEditPart)this.getHost(), count++, t);
            th.propHandle = new TemplatePropertyHandle((GraphicalEditPart)this.getHost(), count - 1, t);
            this.toolHandles.add(th);
        }
    }

    public void refresh() {
        Template currentlySelectedTemplate = null;
        try {
            Object o;
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getSelectionProvider().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof Template) {
                currentlySelectedTemplate = (Template)o;
            }
        }
        catch (Exception selection) {
            // empty catch block
        }
        if (this.getHost().isActive()) {
            this.removeHandles();
            for (TemplateHandle h : this.toolHandles) {
                h.dispose();
            }
            this.toolHandles.clear();
            this.createToolHandles();
            for (TemplateHandle f : this.toolHandles) {
                this.getLayer("toolFigure.layer").add((IFigure)f);
                if (f.propHandle != null) {
                    this.getLayer("toolFigure.layer").add((IFigure)f.propHandle);
                }
                if (f.template != currentlySelectedTemplate) continue;
                f.setSelected(true);
            }
        }
    }

    private void removeHandles() {
        for (IFigure iFigure : this.toolHandles) {
            if (iFigure.getParent() == null) continue;
            this.getLayer("toolFigure.layer").remove(iFigure);
            if (!(iFigure instanceof TemplateHandle) || ((TemplateHandle)iFigure).propHandle == null) continue;
            this.getLayer("toolFigure.layer").remove((IFigure)((TemplateHandle)iFigure).propHandle);
        }
    }

    private IContainer getSemanticModel() {
        EObject obj = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (obj instanceof IContainer) {
            return (IContainer)obj;
        }
        return null;
    }

    public void zoomChanged(double zoom) {
        for (IFigure iFigure : this.toolHandles) {
            if (!(iFigure instanceof AbstractHandle)) continue;
            ((AbstractHandle)iFigure).validate();
        }
    }

    public void activate() {
        super.activate();
        IContainer c = this.getSemanticModel();
        if (c == null || c.eResource() == null) {
            return;
        }
        ((RMap)((Map)c.eContainer()).getMapReference()).eAdapters().add((Object)this.refAdapter);
        this.refresh();
        this.getHost().getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deactivate() {
        this.getHost().getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.removeHandles();
        this.toolHandles.clear();
        if (this.refAdapter.getTarget() != null) {
            this.refAdapter.getTarget().eAdapters().remove((Object)this.refAdapter);
        }
        super.deactivate();
    }

    private void releaseOpenedShell() {
        TemplatePropertyHandle curLastShownProp = null;
        if (lastShown != null) {
            curLastShownProp = (TemplatePropertyHandle)((Object)lastShown.get());
        }
        TemplatePropertyHandle curLastVisibleHandle = null;
        if (this.lastProp != null) {
            curLastVisibleHandle = (TemplatePropertyHandle)((Object)this.lastProp.get());
        }
        for (TemplateHandle h : this.toolHandles) {
            if (curLastShownProp != null && curLastShownProp == h.propHandle) {
                curLastShownProp.controler.hideControl();
                curLastShownProp = null;
                lastShown = null;
            }
            if (curLastVisibleHandle != null && curLastVisibleHandle == h.propHandle) {
                curLastVisibleHandle = null;
            }
            h.dispose();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ss;
        if (event.getSelection() instanceof IStructuredSelection && !(ss = (IStructuredSelection)event.getSelection()).isEmpty() && !(ss.getFirstElement() instanceof Template)) {
            this.updateTemplate(null);
        }
    }

    public class PropLocation
    extends TplLocator {
        public PropLocation(int index) {
            super(index);
        }

        @Override
        public void relocate(IFigure target) {
            super.relocate(target);
            Point p = target.getBounds().getLocation().getCopy();
            p.y -= target.getPreferredSize((int)-1, (int)-1).height;
            target.setLocation(p);
        }
    }

    private class SelectTemplateCommand
    extends Command {
        WeakReference<TemplateHandle> ref;
        boolean state;

        public SelectTemplateCommand(TemplateHandle h, boolean state) {
            this.ref = new WeakReference<TemplateHandle>(h);
            this.state = state;
        }

        public boolean canUndo() {
            return false;
        }

        public void execute() {
            ((TemplateHandle)((Object)this.ref.get())).setSelected(this.state);
        }

        public boolean canExecute() {
            return this.ref.get() != null;
        }
    }

    public class TemplateHandle
    extends AbstractHandle
    implements MouseMotionListener,
    Adapter {
        boolean alphaBlended;
        Template template;
        Border oldBorder;
        TemplatePropertyHandle propHandle;
        boolean selected;

        public TemplateHandle(GraphicalEditPart owner, int templateIndex, Template template) {
            super(owner, (Locator)new TplLocator(templateIndex), Cursors.HAND);
            this.alphaBlended = false;
            this.selected = false;
            this.template = template;
            this.template.eAdapters().add((Object)this);
            ImageFigure im = new ImageFigure(this.getTemplateImage(template), 2);
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.add((IFigure)im);
            this.refreshToolTip();
            this.setBorder((Border)NO_BORDER);
            this.addMouseMotionListener(this);
            WeakReference r = (WeakReference)selectedTemplates.get(TemplateToolEditPolicy.this.getHost().getParent());
            if (r != null && r.get() == template) {
                this.setSelected(true);
            }
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean selected) {
            this.selected = selected;
            if (selected) {
                this.setBorder((Border)SELECTED);
            } else {
                this.setBorder((Border)NO_BORDER);
            }
        }

        protected void paintFigure(Graphics graphics) {
            graphics.pushState();
            graphics.setAlpha(!this.alphaBlended ? 150 : 50);
            if (this.isOpaque()) {
                graphics.fillRectangle(this.getBounds());
            }
            graphics.popState();
            if (this.getBorder() instanceof AbstractBackground) {
                ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
            }
        }

        public Template getTemplate() {
            return this.template;
        }

        public void setBorder(Border border) {
            super.setBorder(border);
            if (border == NO_BORDER) {
                this.alphaBlended = false;
                this.setBackgroundColor(null);
                this.setOpaque(false);
            } else if (border == HOVER) {
                this.setOpaque(true);
                this.alphaBlended = true;
                this.setBackgroundColor(Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor.selected")));
            } else if (border == SELECTED) {
                this.setOpaque(true);
                this.alphaBlended = false;
                this.setBackgroundColor(Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor.selected")));
            }
        }

        protected DragTracker createDragTracker() {
            return new DragEditPartsTracker(TemplateToolEditPolicy.this.getHost()){

                protected void performOpen() {
                    SelectionRequest request = new SelectionRequest();
                    request.setLocation(this.getLocation());
                    request.setType((Object)"open");
                    EObject o = TemplateHandle.this.template.getProcess();
                    if (o instanceof ActionProcess) {
                        ActionProcess proc = (ActionProcess)o;
                        HashMap<String, ActionProcess> map = request.getExtendedData();
                        if (map == null) {
                            map = new HashMap<String, ActionProcess>();
                        }
                        map.put("actionProcess", proc);
                        this.getSourceEditPart().performRequest((Request)request);
                    }
                }

                protected boolean handleButtonUp(int button) {
                    if (button == 1) {
                        this.setState(0x40000000);
                        return true;
                    }
                    return super.handleButtonUp(button);
                }

                protected boolean handleButtonDown(int button) {
                    if (button == 1) {
                        this.performSelection();
                        return true;
                    }
                    return super.handleButtonDown(button);
                }

                protected void performSelection() {
                    if (this.hasSelectionOccurred()) {
                        return;
                    }
                    this.setFlag(64, true);
                    if (!this.hasSelectionOccurred()) {
                        this.setFlag(64, true);
                    }
                    TemplateHandle.this.setSelected(!TemplateHandle.this.isSelected());
                    if (TemplateHandle.this.isSelected()) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)TemplateHandle.this.template));
                    }
                    TemplateToolEditPolicy.this.setSelectedTemplate(TemplateHandle.this.isSelected() ? TemplateHandle.this.template : null);
                }
            };
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (this.getBounds().contains(x, y)) {
                return this;
            }
            return super.findFigureAt(x, y, search);
        }

        Image getTemplateImage(Template t) {
            Image img = null;
            if (!t.getName().startsWith("I") && !t.getName().startsWith("C")) {
                t.getName().startsWith("R");
            }
            img = MapEditUtil.getTemplateImage((Template)this.template);
            return img;
        }

        public void dispose() {
            this.template.eAdapters().remove((Object)this);
            if (this.propHandle != null) {
                this.propHandle.template = null;
            }
            this.template = null;
        }

        public void refreshToolTip() {
            IFigure tooltip = MapDiagramUtil.updateExpressionToolTip((MapModelItem)this.template);
            this.setToolTip(tooltip);
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
            if (this.getBorder() != SELECTED) {
                this.oldBorder = this.getBorder();
                this.setBorder((Border)HOVER);
            }
            if (this.propHandle != null) {
                if (TemplateToolEditPolicy.this.lastProp != null && TemplateToolEditPolicy.this.lastProp.get() != null && TemplateToolEditPolicy.this.lastProp.get() != this.propHandle) {
                    ((TemplatePropertyHandle)((Object)TemplateToolEditPolicy.this.lastProp.get())).setVisible(false);
                }
                this.propHandle.setVisible(true);
                TemplateToolEditPolicy.this.lastProp = new WeakReference<TemplatePropertyHandle>(this.propHandle);
            }
        }

        public void mouseExited(MouseEvent me) {
            if (this.getBorder() != SELECTED) {
                this.setBorder(this.oldBorder);
            }
            if (this.propHandle != null && !this.propHandle.getBounds().contains(me.x, me.y)) {
                this.propHandle.setVisible(false);
            }
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() == this.template && notification.getEventType() == 9 && notification.getFeature() == MapPackage.eINSTANCE.getTemplate_Process()) {
                ((ImageFigure)this.getChildren().get(0)).setImage(this.getTemplateImage(this.template));
            }
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }

    public class TemplatePropertyHandle
    extends TemplateHandle {
        int index;
        PopupPropertyControler controler;

        public TemplatePropertyHandle(GraphicalEditPart owner, int templateIndex, Template template) {
            super(owner, templateIndex, template);
            this.setLocator(new PropLocation(templateIndex));
            this.setVisible(false);
            this.index = templateIndex;
            this.controler = new PopupPropertyControler((IGraphicalEditPart)owner, (IFigure)this, template);
            this.setToolTip((IFigure)new Label(Messages.TemplateToolEditPolicy_8));
        }

        @Override
        public void dispose() {
            super.dispose();
        }

        @Override
        Image getTemplateImage(Template t) {
            return PopupPropertyControler.PROPERTIES_IMAGE;
        }

        @Override
        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (this.getBounds().getCopy().expand(this.getInsets()).contains(x, y)) {
                return this;
            }
            return null;
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            this.setVisible(true);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            this.setVisible(false);
        }

        @Override
        protected DragTracker createDragTracker() {
            return new DragEditPartsTracker(TemplateToolEditPolicy.this.getHost()){

                protected boolean handleButtonDown(int button) {
                    if (button == 1) {
                        TemplatePropertyHandle.this.controler.hideControl();
                        if (lastShown != null) {
                            if (lastShown.get() != TemplatePropertyHandle.this) {
                                TemplatePropertyHandle.this.controler.showControl();
                                lastShown = new WeakReference<TemplatePropertyHandle>(TemplatePropertyHandle.this);
                            } else {
                                lastShown = null;
                            }
                        } else {
                            TemplatePropertyHandle.this.controler.showControl();
                            lastShown = new WeakReference<TemplatePropertyHandle>(TemplatePropertyHandle.this);
                        }
                    }
                    return false;
                }
            };
        }
    }

    public class TplLocator
    implements Locator {
        protected int templateIndex;

        public TplLocator(int index) {
            this.templateIndex = index;
        }

        public void relocate(IFigure target) {
            EObject semantic = ((IGraphicalEditPart)TemplateToolEditPolicy.this.getHost()).resolveSemanticElement();
            IFigure hostFigure = TemplateToolEditPolicy.this.getHostFigure();
            Rectangle hostBounds = hostFigure.getBounds().getCopy();
            Point location = new Point();
            location.x = hostBounds.x + hostBounds.width + (this.templateIndex - TemplateToolEditPolicy.this.toolHandles.size()) * (22 + target.getInsets().left + target.getInsets().right);
            location.y = hostBounds.y - 22 - (target.getInsets().bottom + target.getInsets().top);
            TemplateToolEditPolicy.this.getHostFigure().translateToAbsolute((Translatable)hostBounds);
            target.setBounds(new Rectangle(location, new Dimension(22 + target.getInsets().left + target.getInsets().right, 22 + target.getInsets().bottom + target.getInsets().top)));
        }
    }
}

