/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies.tools;

import com.indy.gmf.map.diagram.custom.edit.policies.tools.FieldToolEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.IToolDescriptor;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.tools.ApplicationHelper;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.ISourceProviderService;

public interface IFeatureToolDescriptor
extends IToolDescriptor {
    public EStructuralFeature getFeature();

    public Object getFeatureValue(EObject var1);

    public static class BooleanFeatureDragTracker
    extends DragEditPartsTrackerEx {
        private IFeatureToolDescriptor descriptor;

        public BooleanFeatureDragTracker(EditPart sourceEditPart, IFeatureToolDescriptor descriptor) {
            super(sourceEditPart);
            this.descriptor = descriptor;
        }

        protected IFeatureToolDescriptor getDescriptor() {
            return this.descriptor;
        }

        protected boolean isMove() {
            return false;
        }

        protected void performOpen() {
        }

        protected org.eclipse.gef.commands.Command getCurrentCommand() {
            EObject semanticObj = ((IGraphicalEditPart)this.getSourceEditPart()).resolveSemanticElement();
            SetRequest req = new SetRequest(semanticObj, this.getDescriptor().getFeature(), (Object)((Boolean)semanticObj.eGet(this.getDescriptor().getFeature()) == false ? 1 : 0));
            SetValueCommand cmd = new SetValueCommand(req);
            return new ICommandProxy((ICommand)cmd);
        }

        protected boolean handleButtonUp(int button) {
            if (this.isInState(2)) {
                this.performDrag();
                this.setState(0x40000000);
                return true;
            }
            return super.handleButtonUp(button);
        }

        protected boolean handleButtonDown(int button) {
            if (button == 1) {
                this.stateTransition(1, 2);
                return true;
            }
            return super.handleButtonDown(button);
        }
    }

    public static class CommandToolDescriptor
    implements IToolDescriptor {
        private Image image;
        private String commandId;
        private String description;
        private Boolean enabled;
        private EditPart host;

        public CommandToolDescriptor(String commandId, EditPart host) {
            ICommandService service = null;
            this.host = host;
            try {
                service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.commandId = commandId;
            this.image = MapDiagramEditorPlugin.getInstance().getImageRegistry().get(commandId);
            if (this.image == null) {
                ICommandImageService imS = null;
                try {
                    imS = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (imS != null) {
                    MapDiagramEditorPlugin.getInstance().getImageRegistry().put(commandId, imS.getImageDescriptor(commandId));
                }
                this.image = MapDiagramEditorPlugin.getInstance().getImageRegistry().get(commandId);
            }
        }

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Color getBackgroundColor() {
            return null;
        }

        @Override
        public DragTracker createTracker(IGraphicalEditPart gep, IFigure triggerFigure) {
            return new DragEditPartsTrackerEx((EditPart)gep){

                protected void performOpen() {
                }

                protected org.eclipse.gef.commands.Command getCurrentCommand() {
                    return new org.eclipse.gef.commands.Command(){

                        public void execute() {
                            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getService(IHandlerService.class);
                            try {
                                handlerService.executeCommand(commandId, new Event());
                            }
                            catch (Exception ex) {
                                MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", String.valueOf(Messages.IFeatureToolDescriptor_1) + commandId, (Throwable)ex));
                            }
                        }

                        public boolean canExecute() {
                            ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getService(ICommandService.class);
                            Command cmd = cmdService.getCommand(commandId);
                            return cmd != null && cmd.isHandled() && cmd.isEnabled();
                        }

                        public void undo() {
                            EObject ob = ((IGraphicalEditPart)this.getSourceEditPart()).resolveSemanticElement();
                            TransactionUtil.getEditingDomain((EObject)ob).getCommandStack().undo();
                        }

                        public void redo() {
                            EObject ob = ((IGraphicalEditPart)this.getSourceEditPart()).resolveSemanticElement();
                            TransactionUtil.getEditingDomain((EObject)ob).getCommandStack().redo();
                        }

                        public boolean canUndo() {
                            EObject ob = ((IGraphicalEditPart)this.getSourceEditPart()).resolveSemanticElement();
                            TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)ob);
                            if (ed != null) {
                                return ed.getCommandStack().canUndo();
                            }
                            return false;
                        }
                    };
                }

                protected boolean handleButtonUp(int button) {
                    if (this.isInState(2)) {
                        this.performDrag();
                        this.setState(0x40000000);
                        return true;
                    }
                    return super.handleButtonUp(button);
                }

                protected boolean handleButtonDown(int button) {
                    if (button == 1) {
                        this.stateTransition(1, 2);
                        return true;
                    }
                    return super.handleButtonDown(button);
                }
            };
        }

        @Override
        public boolean isEnabled() {
            this.refreshEnablement();
            return this.enabled != null && this.enabled != false;
        }

        private void refreshEnablement() {
            if (!ApplicationHelper.isRunningWorkbench()) {
                return;
            }
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = service.getCommand(this.commandId);
            ISourceProvider sp = ((ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class)).getSourceProvider(this.commandId.equals("com.indy.gmf.map.diagram.custom.commands.rejects") ? "com.indy.gmf.map.diagram.custom.commands.semantic.datastore.supportReject" : "activePartId");
            if (sp instanceof ISelectionListener) {
                ((ISelectionListener)sp).selectionChanged(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), (ISelection)this.getCurrentSelection());
            }
            service.refreshElements(this.commandId, null);
            this.enabled = cmd != null && cmd.isHandled() && cmd.isEnabled();
        }

        protected IStructuredSelection getCurrentSelection() {
            return new StructuredSelection((Object)this.host);
        }
    }

    public static class FeatureToolDescriptor
    implements IFeatureToolDescriptor {
        private EStructuralFeature feature;
        private Image image;
        private String description;
        private Color backgroundColor;
        protected DragTracker tracker;

        public FeatureToolDescriptor(EStructuralFeature feature, Image image, String description) {
            this.feature = feature;
            this.image = image;
            this.description = description;
        }

        public FeatureToolDescriptor(EStructuralFeature feature, Image image, String description, Color backgroundColor) {
            this(feature, image, description);
            this.backgroundColor = backgroundColor;
        }

        @Override
        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.feature;
        }

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public DragTracker createTracker(IGraphicalEditPart gep, IFigure triggerFigure) {
            this.tracker = new BooleanFeatureDragTracker((EditPart)gep, this);
            return this.tracker;
        }

        @Override
        public Object getFeatureValue(EObject semanticObject) {
            return semanticObject.eGet(this.getFeature());
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public static class ValuatedFeatureDragTracker
    extends DragEditPartsTrackerEx {
        private ValuatedFeatureToolDescriptor descriptor;

        public ValuatedFeatureDragTracker(EditPart sourceEditPart, ValuatedFeatureToolDescriptor descriptor) {
            super(sourceEditPart);
            this.descriptor = descriptor;
        }

        protected IFeatureToolDescriptor getDescriptor() {
            return this.descriptor;
        }

        protected boolean isMove() {
            return false;
        }

        protected void performOpen() {
        }

        protected org.eclipse.gef.commands.Command getCurrentCommand() {
            EObject semanticObj = ((IGraphicalEditPart)this.getSourceEditPart()).resolveSemanticElement();
            SetRequest req = new SetRequest(semanticObj, this.getDescriptor().getFeature(), this.descriptor.getValue());
            SetValueCommand cmd = new SetValueCommand(req);
            return new ICommandProxy((ICommand)cmd);
        }

        protected boolean handleButtonUp(int button) {
            if (this.isInState(2)) {
                this.performDrag();
                this.setState(0x40000000);
                return true;
            }
            return super.handleButtonUp(button);
        }

        protected boolean handleButtonDown(int button) {
            if (button == 1) {
                this.stateTransition(1, 2);
                return true;
            }
            return super.handleButtonDown(button);
        }
    }

    public static class ValuatedFeatureToolDescriptor
    extends FeatureToolDescriptor {
        private Object value;

        public ValuatedFeatureToolDescriptor(EStructuralFeature feature, Image image, String description, Object value) {
            super(feature, image, description, FieldToolEditPolicy.locationColor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

