/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.preferences.stage;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.services.registry.StagingAreaDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class StageAreaPopup {
    private TreeViewer viewer;
    private static final String INTERNAL_RESOURCE_FOLDER = Messages.StageAreaPopup_0;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private StagingAreaDescriptor result;
    private boolean isPreferred = false;

    public void open(final Shell parent, final Point position, final boolean savePreferred) {
        Dialog dialog = new Dialog(parent){

            protected void initializeBounds() {
                this.getShell().setSize(800, 600);
                this.getShell().setLocation(position == null ? parent.getDisplay().getCursorLocation() : position);
            }

            protected void configureShell(Shell newShell) {
                newShell.setText(Messages.StageAreaPopup_1);
                super.configureShell(newShell);
            }

            protected Control createDialogArea(Composite parent2) {
                Composite c = new Composite(parent2, 0);
                c.setBackground(Display.getCurrent().getSystemColor(1));
                c.setLayout((Layout)new GridLayout());
                c.setLayoutData((Object)new GridData(1808));
                StageAreaPopup.this.viewer = new TreeViewer(c, 68352);
                StageAreaPopup.this.viewer.getControl().setLayoutData((Object)new GridData(1808));
                StageAreaPopup.this.viewer.setComparator((ViewerComparator)new ResourceComparator(1));
                if (savePreferred) {
                    final Button preferred = new Button(c, 32);
                    preferred.setBackground(Display.getCurrent().getSystemColor(1));
                    preferred.setText(Messages.StageAreaPopup_2);
                    preferred.setLayoutData((Object)new GridData());
                    preferred.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            StageAreaPopup.this.isPreferred = preferred.getSelection();
                        }
                    });
                }
                StageAreaPopup.this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Button ok = this.getButton(0);
                        if (event.getSelection().isEmpty()) {
                            ok.setEnabled(false);
                        } else {
                            Object o = event.getStructuredSelection().getFirstElement();
                            ok.setEnabled(o instanceof StagingAreaDescriptor);
                            if (ok.isEnabled()) {
                                StageAreaPopup.this.result = (StagingAreaDescriptor)o;
                            } else {
                                StageAreaPopup.this.result = null;
                            }
                        }
                    }
                });
                StageAreaPopup.this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        if (StageAreaPopup.this.result != null) {
                            StageAreaPopup.this.viewer.getControl().getShell().close();
                        }
                    }
                });
                IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(StagingAreaDescriptor.class);
                final HashMap<Object, ArrayList<StagingAreaDescriptor>> providingFiles = new HashMap<Object, ArrayList<StagingAreaDescriptor>>();
                final HashSet<Object> resources = new HashSet<Object>();
                for (StagingAreaDescriptor d : reg.getAll()) {
                    String modelId = d.getRegistrationKey().getProviderFileID();
                    URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(modelId);
                    if (uri == null) continue;
                    if (uri.isPlatformResource()) {
                        IFile f = Util.convertEMFURIToFile((URI)uri);
                        ArrayList<StagingAreaDescriptor> l = (ArrayList<StagingAreaDescriptor>)providingFiles.get(f);
                        if (l == null) {
                            l = new ArrayList<StagingAreaDescriptor>();
                            providingFiles.put(f, l);
                        }
                        l.add(d);
                        if (!resources.add(f)) continue;
                        IContainer r = f.getParent();
                        while (r instanceof IFolder || r instanceof IProject) {
                            resources.add(r);
                            r = r.getParent();
                        }
                        continue;
                    }
                    ArrayList<StagingAreaDescriptor> l = (ArrayList<StagingAreaDescriptor>)providingFiles.get(INTERNAL_RESOURCE_FOLDER);
                    if (l == null) {
                        l = new ArrayList<StagingAreaDescriptor>();
                        providingFiles.put(INTERNAL_RESOURCE_FOLDER, l);
                    }
                    l.add(d);
                }
                StageAreaPopup.this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                    public boolean hasChildren(Object element) {
                        return element instanceof IResource;
                    }

                    public Object getParent(Object element) {
                        return null;
                    }

                    public Object[] getElements(Object inputElement) {
                        Set files = ((HashMap)inputElement).keySet();
                        Set s = files.stream().map(f -> f instanceof IResource ? ((IResource)f).getProject() : f).collect(Collectors.toSet());
                        List<Object> res = s.stream().collect(Collectors.toList());
                        res.sort((f1, f2) -> {
                            if (f1 instanceof IFile) {
                                if (f2 instanceof IFile) {
                                    return ((IFile)f1).getFullPath().toString().compareTo(((IFile)f2).getFullPath().toString());
                                }
                                return -1;
                            }
                            return 1;
                        });
                        return res.toArray(new Object[res.size()]);
                    }

                    public Object[] getChildren(Object parentElement) {
                        if (parentElement instanceof IFile) {
                            Collection c = (Collection)providingFiles.get(parentElement);
                            return c.toArray(new Object[c.size()]);
                        }
                        ArrayList<IResource> res = new ArrayList<IResource>();
                        try {
                            IResource[] iResourceArray = ((IContainer)parentElement).members();
                            int n = iResourceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource r = iResourceArray[n2];
                                if (resources.contains(r)) {
                                    res.add(r);
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException ex) {
                            ex.printStackTrace();
                        }
                        return res.toArray();
                    }
                });
                StageAreaPopup.this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
                    HashMap<String, ImageDescriptor> descriptorsMap = new HashMap();

                    public String getText(Object element) {
                        if (element instanceof IResource) {
                            return ((IResource)element).getName();
                        }
                        if (element instanceof StagingAreaDescriptor) {
                            return ((StagingAreaDescriptor)element).getLabel();
                        }
                        return super.getText(element);
                    }

                    public Image getImage(Object element) {
                        if (element instanceof IAdaptable) {
                            ImageDescriptor descriptor = ((IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)).getImageDescriptor(element);
                            if (descriptor == null) {
                                return null;
                            }
                            return (Image)StageAreaPopup.this.resourceManager.get((DeviceResourceDescriptor)descriptor);
                        }
                        if (element instanceof StagingAreaDescriptor) {
                            ImageDescriptor desc = this.descriptorsMap.get(((StagingAreaDescriptor)element).getLvlDefType());
                            if (desc == null) {
                                LevelCodeInfo lvlInfo = null;
                                IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(LevelCodeInfo.class);
                                List l = reg.find((IRegistryService.IRegistryMatcher)new LevelCodeInfo.LevelCodeMatcher(((StagingAreaDescriptor)element).getLvlDefType()));
                                if (l != null && !l.isEmpty()) {
                                    for (LevelCodeInfo i : l) {
                                        if (i.getImageURI() != null && !(lvlInfo = i).getImageURI().toString().endsWith("default_icon.gif")) break;
                                    }
                                }
                                if (lvlInfo != null) {
                                    try {
                                        desc = ImageDescriptor.createFromURL((URL)new URL(lvlInfo.getImageURI().toString()));
                                        this.descriptorsMap.put(((StagingAreaDescriptor)element).getLvlDefType(), desc);
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (desc != null) {
                                return (Image)StageAreaPopup.this.resourceManager.get((DeviceResourceDescriptor)desc);
                            }
                        }
                        return super.getImage(element);
                    }
                });
                StageAreaPopup.this.viewer.setInput(providingFiles);
                return c;
            }

            protected void createButtonsForButtonBar(Composite parent2) {
                super.createButtonsForButtonBar(parent2);
                this.getButton(0).setText(Messages.StageAreaPopup_3);
            }

            protected void cancelPressed() {
                StageAreaPopup.this.result = null;
                super.cancelPressed();
            }
        };
        dialog.open();
    }

    public boolean isPreferred() {
        return this.isPreferred;
    }

    public StagingAreaDescriptor getStagingAreaDescriptor() {
        return this.result;
    }
}

