/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.upgrade;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.type.GeoshapeType;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;

public class DiagramConvertor {
    private static final String V2_FILTER = "2002";
    private static final String V2_JOIN = "2005";
    private static final String V2_DATASTORE = "2004";
    private static final String V2_VARIABLE = "2003";
    private static final String V2_VARIABLE_ALIAS = "5002";
    private static final String V2_DATASTORE_ALIAS = "5005";
    private static final String V2_DATASTORE_SETDESC_CPT = "7003";
    private static final String V2_DATASTORE_FIELD_CPT = "7004";
    private static final String V2_DATASTORE_CONSTRAINT_CPT = "7005";
    private static final String CHILDREN = "children";
    private static final String NOTATION_DECORATION_NODE = "notation:DecorationNode";
    private static final String V1_SOURCE = "2002";
    private static final String V1_TARGET = "2001";
    private static final String V1_JOIN = "2003";
    private static final String V1_FILTER = "2007";
    private static final String V1_VARIABLE = "2008";
    private static final String V1_VARIABLE_ALIAS = "5007";
    private static final String T_NOTE = "Note";
    private static final String T_NOTE_1 = "DiagramName";
    private static final String T_NOTE_2 = "Description";
    private static final String T_NOTE_EDGE = "NoteAttachment";
    private static final QName XMI_TYPE = new QName("http://www.omg.org/XMI", "type", "xmi");
    private static final QName XMI_ID = new QName("http://www.omg.org/XMI", "id", "xmi");
    private static final QName TYPE = new QName("type");
    private XMLEventReader reader;
    private XMLStreamWriter writer;
    private int skipCount = 0;

    public DiagramConvertor(InputStream v1InputStream, OutputStream v2OutputStream, String encoding) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = factory.createXMLEventReader(v1InputStream, encoding);
        XMLOutputFactory outfactory = XMLOutputFactory.newInstance();
        this.writer = outfactory.createXMLStreamWriter(v2OutputStream, encoding);
    }

    public void convert() throws XMLStreamException {
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    this.writer.writeStartDocument();
                    break;
                }
                case 8: {
                    this.writer.writeEndDocument();
                    break;
                }
                case 1: {
                    if (this.skipCount != 0) {
                        ++this.skipCount;
                        break;
                    }
                    StartElement se = event.asStartElement();
                    if (CHILDREN.equals(se.getName().getLocalPart())) {
                        if (this.handleChild(se)) break;
                        ++this.skipCount;
                        break;
                    }
                    if ("element".equals(se.getName().getLocalPart())) {
                        this.handleElement(se);
                        break;
                    }
                    if ("edges".equals(se.getName().getLocalPart())) {
                        Attribute a = se.getAttributeByName(TYPE);
                        if (!T_NOTE_EDGE.equals(a.getValue())) {
                            while ((event = this.reader.nextEvent()).getEventType() != 2 || !event.asEndElement().getName().getLocalPart().equals("edges")) {
                            }
                            break;
                        }
                        this.handleElement(se);
                        break;
                    }
                    this.handleStartEvent(se);
                    break;
                }
                case 2: {
                    if (this.skipCount > 0) {
                        --this.skipCount;
                        break;
                    }
                    this.writer.writeEndElement();
                }
            }
        }
        this.writer.flush();
        this.writer.close();
        this.reader.close();
    }

    private void handleStartEvent(StartElement se) throws XMLStreamException {
        this.writer.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
        Iterator<Attribute> it = se.getNamespaces();
        while (it.hasNext()) {
            Namespace n = it.next();
            if (n.getPrefix().equals("map")) {
                this.writer.writeNamespace(n.getPrefix(), "http://www.indy.com/v2/map");
                continue;
            }
            this.writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
        }
        it = se.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            this.writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private void handleElement(StartElement se) throws XMLStreamException {
        this.writer.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
        Attribute xmiType = se.getAttributeByName(XMI_TYPE);
        if (xmiType != null && (xmiType.getValue().equals("map:Source") || xmiType.getValue().equals("map:Target"))) {
            Iterator<Attribute> it = se.getAttributes();
            while (it.hasNext()) {
                Attribute a = it.next();
                if (a == xmiType) {
                    this.writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), "map:Datastore");
                    continue;
                }
                this.writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
            }
        } else {
            Iterator<Attribute> it = se.getAttributes();
            while (it.hasNext()) {
                Attribute a = it.next();
                this.writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
            }
        }
    }

    private boolean handleChild(StartElement se) throws XMLStreamException {
        Attribute a = se.getAttributeByName(TYPE);
        if (V1_FILTER.equals(a.getValue()) || "2003".equals(a.getValue()) || V1_VARIABLE.equals(a.getValue()) || V1_VARIABLE_ALIAS.equals(a.getValue()) || "2002".equals(a.getValue()) || V1_TARGET.equals(a.getValue())) {
            this.writer.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
            Iterator<Attribute> it = se.getAttributes();
            while (it.hasNext()) {
                Attribute at = it.next();
                if (at == a) {
                    this.writer.writeAttribute(at.getName().getPrefix(), at.getName().getNamespaceURI(), at.getName().getLocalPart(), this.getV2Type(a.getValue()));
                    continue;
                }
                this.writer.writeAttribute(at.getName().getPrefix(), at.getName().getNamespaceURI(), at.getName().getLocalPart(), at.getValue());
            }
            if ("2002".equals(a.getValue()) || V1_TARGET.equals(a.getValue())) {
                this.writer.writeStartElement(se.getName().getPrefix(), CHILDREN, se.getName().getNamespaceURI());
                this.writer.writeAttribute(XMI_TYPE.getPrefix(), XMI_TYPE.getNamespaceURI(), XMI_TYPE.getLocalPart(), NOTATION_DECORATION_NODE);
                this.writer.writeAttribute(XMI_ID.getPrefix(), XMI_ID.getNamespaceURI(), XMI_ID.getLocalPart(), String.valueOf(se.getAttributeByName(XMI_ID).getValue()) + "_alias");
                this.writer.writeAttribute(TYPE.getPrefix(), TYPE.getNamespaceURI(), TYPE.getLocalPart(), V2_DATASTORE_ALIAS);
                this.writer.writeEndElement();
                this.writer.writeStartElement(se.getName().getPrefix(), CHILDREN, se.getName().getNamespaceURI());
                this.writer.writeAttribute(XMI_TYPE.getPrefix(), XMI_TYPE.getNamespaceURI(), XMI_TYPE.getLocalPart(), NOTATION_DECORATION_NODE);
                this.writer.writeAttribute(XMI_ID.getPrefix(), XMI_ID.getNamespaceURI(), XMI_ID.getLocalPart(), String.valueOf(se.getAttributeByName(XMI_ID).getValue()) + "_setDescCompartment");
                this.writer.writeAttribute(TYPE.getPrefix(), TYPE.getNamespaceURI(), TYPE.getLocalPart(), V2_DATASTORE_SETDESC_CPT);
                this.writer.writeEndElement();
                this.writer.writeStartElement(se.getName().getPrefix(), CHILDREN, se.getName().getNamespaceURI());
                this.writer.writeAttribute(XMI_TYPE.getPrefix(), XMI_TYPE.getNamespaceURI(), XMI_TYPE.getLocalPart(), NOTATION_DECORATION_NODE);
                this.writer.writeAttribute(XMI_ID.getPrefix(), XMI_ID.getNamespaceURI(), XMI_ID.getLocalPart(), String.valueOf(se.getAttributeByName(XMI_ID).getValue()) + "_fieldCompartment");
                this.writer.writeAttribute(TYPE.getPrefix(), TYPE.getNamespaceURI(), TYPE.getLocalPart(), V2_DATASTORE_FIELD_CPT);
                this.writer.writeEndElement();
                this.writer.writeStartElement(se.getName().getPrefix(), CHILDREN, se.getName().getNamespaceURI());
                this.writer.writeAttribute(XMI_TYPE.getPrefix(), XMI_TYPE.getNamespaceURI(), XMI_TYPE.getLocalPart(), NOTATION_DECORATION_NODE);
                this.writer.writeAttribute(XMI_ID.getPrefix(), XMI_ID.getNamespaceURI(), XMI_ID.getLocalPart(), String.valueOf(se.getAttributeByName(XMI_ID).getValue()) + "_constraintCompartment");
                this.writer.writeAttribute(TYPE.getPrefix(), TYPE.getNamespaceURI(), TYPE.getLocalPart(), V2_DATASTORE_CONSTRAINT_CPT);
                this.writer.writeEndElement();
            }
            return true;
        }
        if (a != null) {
            boolean geoShape = false;
            for (Object o : GeoshapeType.getShapeTypes()) {
                if (!((INotationType)o).getSemanticHint().equals(a.getValue())) continue;
                geoShape = true;
                break;
            }
            if (geoShape || T_NOTE.equals(a.getValue()) || T_NOTE_1.equals(a.getValue()) || T_NOTE_2.equals(a.getValue())) {
                this.writer.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
                Iterator<Attribute> it = se.getAttributes();
                while (it.hasNext()) {
                    Attribute at = it.next();
                    this.writer.writeAttribute(at.getName().getPrefix(), at.getName().getNamespaceURI(), at.getName().getLocalPart(), at.getValue());
                }
                return true;
            }
        }
        return false;
    }

    private String getV2Type(String value) {
        if (value.equals(V1_FILTER)) {
            return "2002";
        }
        if (value.equals("2003")) {
            return V2_JOIN;
        }
        if (value.equals("2002")) {
            return V2_DATASTORE;
        }
        if (value.equals(V1_TARGET)) {
            return V2_DATASTORE;
        }
        if (value.equals(V1_VARIABLE)) {
            return "2003";
        }
        if (value.equals(V1_VARIABLE_ALIAS)) {
            return V2_VARIABLE_ALIAS;
        }
        return null;
    }
}

