/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.gmf.map.diagram.custom.edit.parts.LogicalFieldEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.util.ActiveSetDescriptorHelper;
import com.indy.gmf.map.diagram.properties.GlobalPropertySection;
import com.indy.gmf.map.diagram.properties.ItemPropertiesUI;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.ItemProperty;
import com.indy.map.MapLocation;
import com.indy.map.MapPackage;
import com.indy.map.SetDescriptor;
import com.indy.map.impl.custom.Outliner;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FieldPropertySection
extends GlobalPropertySection {
    private Button enableButton;
    private Group mappingGroup;
    private Button updateKeyButton;
    private Group locationGroup;
    private Button insertButton;
    private Button updateButton;
    private Button aggregateButton;
    private Button sourceB;
    private Button workB;
    private Button targetB;
    private Text name;
    private Composite props;
    private ItemPropertiesUI itemPropertiesUI;

    @Override
    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        gridData = new GridData(1808);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(3, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        Composite nameComposite = this.getWidgetFactory().createComposite(topComposite);
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        nameComposite.setLayoutData((Object)gridData);
        this.getWidgetFactory().createLabel(nameComposite, aliasLabel).setLayoutData((Object)new GridData());
        this.name = this.getWidgetFactory().createText(nameComposite, "");
        this.connectText(this.name, true, (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Alias());
        gridData = new GridData(768);
        this.name.setLayoutData((Object)gridData);
        this.name.setEnabled(false);
        this.enableButton = this.getWidgetFactory().createButton(topComposite, enableLabel, 32);
        this.connectCheckBox(this.enableButton, (EStructuralFeature)MapPackage.eINSTANCE.getField_Enable());
        this.createLocationGroup(topComposite);
        this.createTagGroup(topComposite, tagLabel, (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Tag(), true, 3, 1);
        this.createMappingGroup(topComposite);
        this.createDescriptionGroup(topComposite, 2);
        this.props = this.getWidgetFactory().createComposite(parent, 0);
        this.props.setLayout((Layout)new GridLayout(3, false));
        this.props.setLayoutData((Object)new GridData(4, 3, true, false));
        this.itemPropertiesUI = new ItemPropertiesUI(this.getWidgetFactory());
    }

    private void createLocationGroup(Composite composite) {
        GridData gridData = new GridData(770);
        this.locationGroup = this.getWidgetFactory().createGroup(composite, executionLocationLabel);
        this.locationGroup.setLayoutData((Object)gridData);
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        this.locationGroup.setLayout((Layout)rl);
        this.sourceB = this.getWidgetFactory().createButton((Composite)this.locationGroup, sourceLabel, 16);
        this.workB = this.getWidgetFactory().createButton((Composite)this.locationGroup, stagingAreaLabel, 16);
        this.targetB = this.getWidgetFactory().createButton((Composite)this.locationGroup, targetLabel, 16);
        this.connectRadioButton(this.sourceB, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Location(), MapLocation.SRC);
        this.connectRadioButton(this.workB, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Location(), MapLocation.WRK);
        this.connectRadioButton(this.targetB, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Location(), MapLocation.TRG);
    }

    @Override
    protected void connectRadioButton(Button button, final EStructuralFeature feature, final Object value) {
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (feature == MapPackage.eINSTANCE.getExpression_Location()) {
                    this.setExpressionValue(value, feature);
                } else {
                    FieldPropertySection.this.setValue(value, feature);
                }
            }

            private void setExpressionValue(Object value2, EStructuralFeature feature2) {
                CompoundCommand cc = new CompoundCommand();
                for (IGraphicalEditPart ep : FieldPropertySection.this.getInput()) {
                    Expression eob = FieldPropertySection.this.getExpression(ep);
                    if (eob == null) continue;
                    cc.append((Command)new SetCommand((EditingDomain)FieldPropertySection.this.getEditingDomain(), (EObject)eob, feature2, value2));
                }
                if (!cc.isEmpty()) {
                    FieldPropertySection.this.getEditingDomain().getCommandStack().execute((Command)cc);
                }
            }
        });
    }

    private Expression getExpression(IGraphicalEditPart fieldEp) {
        Expression res = null;
        EObject eObject = fieldEp.resolveSemanticElement();
        SetDescriptor setDesc = ActiveSetDescriptorHelper.getActiveSetDescriptor((LogicalFieldEditPart)fieldEp);
        if (setDesc != null) {
            res = ((ILogicalField)eObject).getExpression(setDesc);
        } else if (eObject.eContainer() != null && ((IContainer)eObject.eContainer()).getSetDescriptor().size() == 1) {
            res = ((ILogicalField)eObject).getExpression((SetDescriptor)((IContainer)eObject.eContainer()).getSetDescriptor().get(0));
        }
        return res;
    }

    @Override
    protected void connectCheckBox(Button button, final EStructuralFeature feature) {
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (feature == MapPackage.eINSTANCE.getExpression_Aggregate()) {
                    FieldPropertySection.this.inverseExpressionBooleanValue(feature);
                } else {
                    FieldPropertySection.this.inverseBooleanValue(feature);
                }
            }
        });
    }

    void inverseExpressionBooleanValue(EStructuralFeature feature) {
        CompoundCommand cc = new CompoundCommand();
        Iterator it = this.getInput().iterator();
        Boolean b = null;
        while (it.hasNext()) {
            IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            Expression eob = this.getExpression(ep);
            if (b == null) {
                b = (Boolean)eob.eGet(feature);
                b = new Boolean(b == false);
            }
            if (eob == null) continue;
            cc.append((Command)new SetCommand((EditingDomain)this.getEditingDomain(), (EObject)eob, feature, (Object)b));
        }
        if (!cc.isEmpty()) {
            this.getEditingDomain().getCommandStack().execute((Command)cc);
        }
    }

    private void createMappingGroup(Composite composite) {
        GridData gridData = new GridData(770);
        this.mappingGroup = this.getWidgetFactory().createGroup(composite, mappingLabel);
        this.mappingGroup.setLayoutData((Object)gridData);
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        this.mappingGroup.setLayout((Layout)rl);
        gridData.horizontalSpan = 2;
        this.updateKeyButton = this.getWidgetFactory().createButton((Composite)this.mappingGroup, keyLabel, 32);
        this.connectCheckBox(this.updateKeyButton, (EStructuralFeature)MapPackage.eINSTANCE.getField_UpdateKey());
        this.insertButton = this.getWidgetFactory().createButton((Composite)this.mappingGroup, insertLabel, 32);
        this.connectCheckBox(this.insertButton, (EStructuralFeature)MapPackage.eINSTANCE.getField_Insert());
        this.updateButton = this.getWidgetFactory().createButton((Composite)this.mappingGroup, updateLabel, 32);
        this.connectCheckBox(this.updateButton, (EStructuralFeature)MapPackage.eINSTANCE.getField_Update());
        this.aggregateButton = this.getWidgetFactory().createButton((Composite)this.mappingGroup, aggregateLabel, 32);
        this.connectCheckBox(this.aggregateButton, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Aggregate());
    }

    protected boolean isCurrentSelection(Notification notification, EObject element) {
        if (element instanceof Expression && this.getEObjectList().contains(element.eContainer())) {
            return true;
        }
        return super.isCurrentSelection(notification, element);
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    EObject eObject = FieldPropertySection.this.getEObject();
                    boolean isReadOnly = FieldPropertySection.this.isReadOnly();
                    if (eObject instanceof Field) {
                        FieldPropertySection.this.itemPropertiesUI.disposePropertiesUI(FieldPropertySection.this.props);
                        FieldPropertySection.this.itemPropertiesUI.createPropertiesUI(FieldPropertySection.this.props, (List<ItemProperty>)((Field)eObject).getProperty(), isReadOnly);
                        Field trgField = (Field)eObject;
                        String text = trgField.getName();
                        if (text != null) {
                            FieldPropertySection.this.name.setText(text);
                        } else {
                            FieldPropertySection.this.name.setText("");
                        }
                        FieldPropertySection.this.enableButton.setSelection(trgField.isEnable());
                        FieldPropertySection.this.enableButton.setEnabled(!isReadOnly && !(trgField.eContainer() instanceof Outliner));
                        FieldPropertySection.this.updateKeyButton.setSelection(trgField.isUpdateKey());
                        FieldPropertySection.this.updateKeyButton.setEnabled(!isReadOnly && !(trgField.eContainer() instanceof Outliner));
                        FieldPropertySection.this.updateButton.setSelection(trgField.isUpdate());
                        FieldPropertySection.this.updateButton.setEnabled(!isReadOnly && !(trgField.eContainer() instanceof Outliner));
                        FieldPropertySection.this.insertButton.setSelection(trgField.isInsert());
                        FieldPropertySection.this.insertButton.setEnabled(!isReadOnly && !(trgField.eContainer() instanceof Outliner));
                        FieldPropertySection.this.aggregateButton.setEnabled(!isReadOnly && !(trgField.eContainer() instanceof Outliner));
                        boolean expressionEnabled = false;
                        IGraphicalEditPart ep = (IGraphicalEditPart)FieldPropertySection.this.getInput().get(0);
                        if (ep != null) {
                            Expression exp = FieldPropertySection.this.getExpression(ep);
                            if (exp == null) {
                                expressionEnabled = false;
                            } else {
                                expressionEnabled = true;
                                FieldPropertySection.this.aggregateButton.setSelection(exp.isAggregate());
                                if (exp.getLocation().equals((Object)MapLocation.SRC)) {
                                    FieldPropertySection.this.sourceB.setSelection(true);
                                    FieldPropertySection.this.workB.setSelection(false);
                                    FieldPropertySection.this.targetB.setSelection(false);
                                } else if (exp.getLocation() == MapLocation.WRK) {
                                    FieldPropertySection.this.sourceB.setSelection(false);
                                    FieldPropertySection.this.workB.setSelection(true);
                                    FieldPropertySection.this.targetB.setSelection(false);
                                } else if (exp.getLocation() == MapLocation.TRG) {
                                    FieldPropertySection.this.sourceB.setSelection(false);
                                    FieldPropertySection.this.workB.setSelection(false);
                                    FieldPropertySection.this.targetB.setSelection(true);
                                }
                            }
                        }
                        FieldPropertySection.this.sourceB.setEnabled(expressionEnabled);
                        FieldPropertySection.this.workB.setEnabled(expressionEnabled);
                        FieldPropertySection.this.targetB.setEnabled(expressionEnabled);
                        FieldPropertySection.this.aggregateButton.setEnabled(expressionEnabled);
                        FieldPropertySection.this.descriptionText.setText(trgField.getDescription() != null ? trgField.getDescription() : "");
                        FieldPropertySection.this.tagsList.removeAll();
                        for (QName qname : trgField.getTag()) {
                            FieldPropertySection.this.tagsList.add(qname.getLocalPart());
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void changeDescription(String text) {
        this.setValue(text, (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Description());
    }
}

