/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.diagram.properties.ClausePropertySection;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.JoinMode;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.custom.commands.MergeDataSetCommand;
import com.indy.map.helpers.command.builder.ConditionalJoinCommandBuilder;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class JoinPropertySectionAdvanced
extends ClausePropertySection {
    private Button inDisbable;
    private Button fromLeft;
    private Button fromRight;
    private Button explicitMode;
    private Button implicitMode;
    private Button defaultMode;
    private Text orderText;
    ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    IStructuredContentProvider scp = new ArrayContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).getContainer().toArray();
            }
            return super.getElements(inputElement);
        }
    };

    @Override
    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        gridData = new GridData(1808);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        this.createOrderGroup(topComposite);
        this.createTypeGroup(topComposite, 2);
        this.createInheritanceGroup(topComposite);
    }

    private void createInheritanceGroup(Composite parent) {
        Group inheritance = this.getWidgetFactory().createGroup(parent, Messages.JoinPropertySectionAdvanced_1);
        inheritance.setLayout((Layout)new GridLayout());
        this.inDisbable = this.getWidgetFactory().createButton((Composite)inheritance, Messages.JoinPropertySectionAdvanced_2, 16);
        this.inDisbable.setLayoutData((Object)new GridData());
        this.inDisbable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSet right = null;
                DataSet left = null;
                Join join = (Join)JoinPropertySectionAdvanced.this.getEObject();
                if (join != null && join.getLeft() != null) {
                    left = join.getLeft().getDataset();
                }
                if (join != null && join.getRight() != null) {
                    right = join.getRight().getDataset();
                }
                if (right != left) {
                    if (left != null && left.getParent().contains((Object)right)) {
                        JoinPropertySectionAdvanced.this.getEditingDomain().getCommandStack().execute((Command)new MergeDataSetCommand(left, right));
                    } else if (right != null && right.getParent().contains((Object)left)) {
                        JoinPropertySectionAdvanced.this.getEditingDomain().getCommandStack().execute((Command)new MergeDataSetCommand(right, left));
                    }
                }
            }
        });
        this.fromLeft = this.getWidgetFactory().createButton((Composite)inheritance, Messages.JoinPropertySectionAdvanced_3, 16);
        this.fromLeft.setLayoutData((Object)new GridData());
        this.fromLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSet right = null;
                DataSet left = null;
                Join join = (Join)JoinPropertySectionAdvanced.this.getEObject();
                if (join != null && join.getLeft() != null) {
                    left = join.getLeft().getDataset();
                }
                if (join != null && join.getRight() != null) {
                    right = join.getRight().getDataset();
                }
                if (right == left) {
                    JoinPropertySectionAdvanced.this.getEditingDomain().getCommandStack().execute(ConditionalJoinCommandBuilder.INSTANCE.makeInheritanceJoinCommand(join, false));
                } else {
                    JoinPropertySectionAdvanced.this.handlFlipConditionJoin(join);
                }
            }
        });
        this.fromRight = this.getWidgetFactory().createButton((Composite)inheritance, Messages.JoinPropertySectionAdvanced_4, 16);
        this.fromRight.setLayoutData((Object)new GridData());
        this.fromRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSet right = null;
                DataSet left = null;
                Join join = (Join)JoinPropertySectionAdvanced.this.getEObject();
                if (join != null && join.getLeft() != null) {
                    left = join.getLeft().getDataset();
                }
                if (join != null && join.getRight() != null) {
                    right = join.getRight().getDataset();
                }
                if (right == left) {
                    JoinPropertySectionAdvanced.this.getEditingDomain().getCommandStack().execute(ConditionalJoinCommandBuilder.INSTANCE.makeInheritanceJoinCommand(join, true));
                } else if (right != null && !right.getChild().contains((Object)left)) {
                    JoinPropertySectionAdvanced.this.handlFlipConditionJoin(join);
                }
            }
        });
    }

    private void handlFlipConditionJoin(Join join) {
        Command command = ConditionalJoinCommandBuilder.INSTANCE.makeFlipInheritancy(join);
        this.getEditingDomain().getCommandStack().execute(command);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof IDiagramWorkbenchPart) {
            DiagramEditPart rootEditorPart = ((IDiagramWorkbenchPart)editor).getDiagramEditPart();
            CanonicalEditPolicy.getRegisteredEditPolicies((EObject)rootEditorPart.getDiagramView().getElement()).forEach(CanonicalEditPolicy::refresh);
        }
    }

    private void createOrderGroup(Composite composite) {
        GridData gridData = new GridData(1, 1, false, false);
        Composite orderGroup = this.getWidgetFactory().createComposite(composite);
        GridLayout gl = new GridLayout(2, false);
        orderGroup.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        orderGroup.setLayoutData((Object)gridData);
        this.getWidgetFactory().createLabel(orderGroup, Messages.JoinPropertySectionAdvanced_5);
        this.orderText = this.getWidgetFactory().createText(orderGroup, "");
        this.connectBigInteger(this.orderText, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Order());
        this.orderText.addVerifyListener(e -> {
            boolean bl = e.doit = e.text.matches("[0-9]*");
        });
        gridData = new GridData();
        gridData.widthHint = 100;
        this.orderText.setLayoutData((Object)gridData);
    }

    protected void refreshRadioButton(JoinMode type) {
        this.defaultMode.setSelection(false);
        this.implicitMode.setSelection(false);
        this.explicitMode.setSelection(false);
        switch (type.getValue()) {
            case 0: {
                this.defaultMode.setSelection(true);
                break;
            }
            case 1: {
                this.explicitMode.setSelection(true);
                break;
            }
            case 2: {
                this.implicitMode.setSelection(true);
            }
        }
    }

    private void createTypeGroup(Composite composite, int horizontalSpan) {
        GridData gridData = new GridData(546);
        gridData.horizontalSpan = horizontalSpan;
        Group joinMode = this.getWidgetFactory().createGroup(composite, joinModeLabel);
        GridLayout gridLayout = new GridLayout(3, false);
        joinMode.setLayoutData((Object)gridData);
        joinMode.setLayout((Layout)gridLayout);
        this.explicitMode = this.getWidgetFactory().createButton((Composite)joinMode, Messages.JoinPropertySectionAdvanced_8, 16);
        this.connectRadioButton(this.explicitMode, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinMode(), JoinMode.EXPLICIT);
        this.implicitMode = this.getWidgetFactory().createButton((Composite)joinMode, Messages.JoinPropertySectionAdvanced_9, 16);
        this.connectRadioButton(this.implicitMode, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinMode(), JoinMode.IMPLICIT);
        this.defaultMode = this.getWidgetFactory().createButton((Composite)joinMode, Messages.JoinPropertySectionAdvanced_10, 16);
        this.connectRadioButton(this.defaultMode, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinMode(), JoinMode.DEFAULT);
    }

    protected boolean isCurrentSelection(Notification notification, EObject element) {
        if (this.getEObject() instanceof Join) {
            Join j = (Join)this.getEObject();
            IContainer left = j.getLeft();
            IContainer right = j.getRight();
            if (left == element || right == element && (notification.getFeature() == MapPackage.eINSTANCE.getDatastore_Dataset() || notification.getFeature() == MapPackage.eINSTANCE.getQuery_Dataset())) {
                return true;
            }
            if (left != null && left.getDataset() == element || right != null && right.getDataset() == element) {
                return true;
            }
        }
        return super.isCurrentSelection(notification, element);
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    EObject eObject = JoinPropertySectionAdvanced.this.getEObject();
                    if (eObject instanceof Join) {
                        Join join = (Join)JoinPropertySectionAdvanced.this.getEObject();
                        JoinPropertySectionAdvanced.this.orderText.setText(join.getOrder() != null ? join.getOrder().toString() : "");
                        JoinPropertySectionAdvanced.this.refreshRadioButton(join.getJoinMode());
                        JoinPropertySectionAdvanced.this.refreshInheritance(join);
                    }
                }
            });
        }
    }

    private void refreshInheritance(Join join) {
        DataSet right = null;
        DataSet left = null;
        String leftLabel = "";
        String rightLabel = "";
        if (join != null && join.getLeft() != null) {
            left = join.getLeft().getDataset();
            if (join.getRight() != null) {
                leftLabel = String.valueOf(Messages.JoinPropertySectionAdvanced_14) + join.getRight().getAlias().toString() + Messages.JoinPropertySectionAdvanced_15;
            }
        }
        if (join != null && join.getRight() != null) {
            right = join.getRight().getDataset();
            if (join.getLeft() != null) {
                rightLabel = String.valueOf(Messages.JoinPropertySectionAdvanced_16) + join.getLeft().getAlias().toString() + Messages.JoinPropertySectionAdvanced_17;
            }
        }
        if (left == null || right == null) {
            this.fromLeft.setEnabled(false);
            this.fromRight.setEnabled(false);
            this.inDisbable.setEnabled(false);
            return;
        }
        if (join.getLeft() == join.getRight()) {
            this.fromLeft.setEnabled(false);
            this.fromRight.setEnabled(false);
        } else {
            this.fromLeft.setEnabled(true);
            this.fromRight.setEnabled(true);
        }
        this.fromLeft.setText(leftLabel);
        this.fromRight.setText(rightLabel);
        this.fromRight.setSelection(false);
        this.fromLeft.setSelection(false);
        this.inDisbable.setSelection(false);
        if (left == right) {
            this.inDisbable.setSelection(true);
        } else if (right.getParent().contains((Object)left)) {
            this.fromLeft.setSelection(true);
        } else if (left.getParent().contains((Object)right)) {
            this.fromRight.setSelection(true);
        }
        if (this.isReadOnly()) {
            this.inDisbable.setEnabled(false);
            this.fromLeft.setEnabled(false);
            this.fromRight.setEnabled(false);
        } else {
            this.inDisbable.setEnabled(!this.inDisbable.getSelection());
            this.fromLeft.setEnabled(!this.fromLeft.getSelection());
            this.fromRight.setEnabled(!this.fromRight.getSelection());
        }
    }

    public NotificationFilter getFilter() {
        NotificationFilter addOrRemove = NotificationFilter.createEventTypeFilter((int)3).or(NotificationFilter.createEventTypeFilter((int)4));
        NotificationFilter addOrRemoveDataSetParent = addOrRemove.and(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent()));
        return super.getFilter().or(addOrRemoveDataSetParent);
    }
}

