/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.map.ItemProperty;
import com.indy.map.MapPackage;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.extension.properties.IPropertyDescriptor;
import com.indy.ui.custom.out.common.properties.AbstractKeyValueControl;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.indy.ui.custom.out.common.properties.CustomFeatureEditorDialog;
import com.indy.ui.custom.out.common.properties.ListUnboundedControl;
import com.indy.ui.custom.out.common.properties.StringUnboundedControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;

public class PropertyUIAdapterFactory
implements IAdapterFactory {
    private WeakHashMap<ItemProperty, UIControlDescriptor> map = new WeakHashMap();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IPropertyDescriptor desc;
        if (adapterType.equals(UIControlDescriptor.class) && adaptableObject instanceof ItemProperty && (desc = ((ItemProperty)adaptableObject).getDescriptor()) != null) {
            ItemPropertyUIControlDescriptor res = null;
            this.map.get(adaptableObject);
            if (res == null) {
                res = new ItemPropertyUIControlDescriptor((ItemProperty)adaptableObject, 1, 2);
                this.map.put((ItemProperty)adaptableObject, res);
            }
            return res;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{UIControlDescriptor.class};
    }

    private class ItemPropertyUIControlDescriptor
    implements UIControlDescriptor,
    UIControlDescriptor.Setter,
    UIControlDescriptor.ValueProvider,
    UIControlDescriptor.IUnboundedEditorProvider {
        private ItemProperty prop;
        private IPropertyDescriptor desc;
        private int labelHSpan;
        private int controlHSpan;
        private UIControlDescriptor.Type type;
        private EStructuralFeature feature;

        public ItemPropertyUIControlDescriptor(ItemProperty prop, int labelHSpan, int controlHSpan) {
            this.desc = prop.getDescriptor();
            this.prop = prop;
            this.type = UIControlDescriptor.Type.values()[this.desc.getType().ordinal()];
            this.labelHSpan = labelHSpan;
            this.controlHSpan = controlHSpan;
            this.feature = MapPackage.eINSTANCE.getItemProperty_Value();
        }

        public UIControlDescriptor.Type getType() {
            return this.type;
        }

        public boolean isUnbounded() {
            return this.desc.isUnbounded();
        }

        public String getControlLabel() {
            return this.desc.getDisplayLabel();
        }

        public String getControlTooltype() {
            return this.desc.getUITooltip();
        }

        public boolean isControlMultiline() {
            return this.desc.isUIMultiline();
        }

        public boolean isHyperlink() {
            return false;
        }

        public boolean isEditable() {
            return this.getType() != UIControlDescriptor.Type.REFERENCE;
        }

        public boolean refreshUIOnValueChange() {
            return false;
        }

        public boolean isEnabled() {
            return true;
        }

        public UIControlDescriptor.ValueProvider getValueProvider() {
            return this;
        }

        public String getPropertyCode() {
            return this.desc.getCode();
        }

        public UIControlDescriptor.Setter getPropertySetter() {
            return this;
        }

        public int getLabelHorizontalSpan() {
            return this.labelHSpan;
        }

        public int getControlHorizontalSpan() {
            return this.controlHSpan;
        }

        public List<UIControlDescriptor.LinkedControlDescriptor> getLinkedDescriptors() {
            return Collections.EMPTY_LIST;
        }

        public UIControlDescriptor.IUnboundedEditorProvider getUnboundedEditorProvider() {
            return this;
        }

        public void changeValue(Object newValue) {
            TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)this.prop);
            SetCommand rc = null;
            Object val = newValue;
            switch (this.getType()) {
                case BOOLEAN: {
                    val = newValue.toString();
                    break;
                }
                case LIST: {
                    if (this.isUnbounded()) {
                        if (!(newValue instanceof List)) break;
                        StringBuffer b = new StringBuffer();
                        for (Object o : (List)newValue) {
                            if (b.length() > 0) {
                                b.append(";");
                            }
                            b.append((String)o);
                        }
                        val = b.toString();
                        break;
                    }
                    val = newValue.toString();
                    break;
                }
                case PASSWORD: {
                    val = newValue.toString();
                    break;
                }
                case STRING: 
                case REFERENCE: {
                    if (this.isUnbounded()) {
                        if (!(newValue instanceof List)) break;
                        StringBuffer b = new StringBuffer();
                        for (Object o : (List)newValue) {
                            if (b.length() > 0) {
                                b.append(";");
                            }
                            b.append((String)o);
                        }
                        val = b.toString();
                        break;
                    }
                    val = newValue.toString();
                }
            }
            if (this.getType() == UIControlDescriptor.Type.BOOLEAN) {
                val = newValue.toString();
            }
            try {
                rc = new SetCommand((EditingDomain)ed, (EObject)this.prop, this.feature, val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rc != null) {
                ed.getCommandStack().execute(rc);
            }
        }

        public Object getValueFromObject() {
            Object o = this.prop.eGet(this.feature);
            if (this.getType() == UIControlDescriptor.Type.BOOLEAN && o instanceof String) {
                return Boolean.valueOf((String)o);
            }
            return o;
        }

        public Object getValueFromControl() {
            return null;
        }

        public String getLabel(Object value) {
            if (value == null) {
                return "";
            }
            if (this.desc.getValueProvider() != null) {
                return this.desc.getValueProvider().getLabel(value);
            }
            return value.toString();
        }

        public List<Object> getPotentialValues(Object data) {
            if (this.desc.getValueProvider() != null) {
                return this.desc.getValueProvider().getPotentialValues(data);
            }
            return Collections.EMPTY_LIST;
        }

        public void dispose() {
        }

        public boolean canReadFromControl() {
            return false;
        }

        public Object openEditor() {
            CustomFeatureEditorDialog dialog = null;
            AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider(MapDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
            if (this.desc.isUnbounded() && this.desc.isKeyValue()) {
                dialog = new CustomFeatureEditorDialog(Display.getCurrent().getActiveShell(), (Object)this.prop, (AbstractUnboundedControl)new KeyValueControl((ILabelProvider)aflp, null), this.desc.getDisplayLabel(), (Object)this.prop);
            } else {
                List curVals = this.prop.getValuesObject();
                Object uiControl = null;
                uiControl = this.desc.getType() == IPropertyDescriptor.Type.List ? new ListUnboundedControl((ILabelProvider)aflp, (Collection)this.desc.getValueProvider().getPotentialValues((Object)this.prop)) : new StringUnboundedControl((ILabelProvider)aflp);
                dialog = new CustomFeatureEditorDialog(Display.getCurrent().getActiveShell(), (Object)this.prop, (AbstractUnboundedControl)uiControl, this.desc.getDisplayLabel(), (Object)curVals);
            }
            if (dialog.open() == 0) {
                return dialog.getResult();
            }
            return null;
        }

        public String getHint(String hintName) {
            return null;
        }

        public boolean hasHexadecimalControl() {
            return false;
        }

        public UIControlDescriptor.IAddtionalControlBuilder getAdditionalControlBuilder() {
            return null;
        }
    }

    class KeyValueControl
    extends AbstractKeyValueControl {
        TreeMap<String, String> entries;

        public KeyValueControl(ILabelProvider labelProvider, AbstractKeyValueControl.IKeyValueProvider provider) {
            super(labelProvider, provider);
            this.entries = new TreeMap();
        }

        protected String getKeyLabel(Object data) {
            return (String)data;
        }

        protected String getValueLabel(Object data) {
            return (String)data;
        }

        protected void handleDownItem(Object o) {
        }

        protected void handleUpItem(Object o) {
        }

        protected void handleRemoveItem(List l) {
            for (Object o : l) {
                this.entries.remove(o);
            }
        }

        protected void handleAddItem(Object o) {
            if (o != null) {
                String[] obj = (String[])o;
                String k = obj[0];
                String v = obj[1];
                if (k != null && !k.trim().isEmpty() && v != null && !v.trim().isEmpty()) {
                    this.entries.put(k, v);
                }
            }
        }

        public Object initializeInput(Object data) {
            List l = ((ItemProperty)data).getValuesObject();
            for (Object o : l) {
                if (!(o instanceof String)) continue;
                String[] e = ((String)o).split("=");
                String k = e[0];
                String v = "";
                if (e.length > 1) {
                    v = e[1];
                }
                this.entries.put(k, v);
            }
            return this.entries.keySet();
        }

        public EList getResult() {
            StringBuffer buf = new StringBuffer();
            for (String e : this.entries.keySet()) {
                if (buf.length() > 0) {
                    buf.append(";");
                }
                buf.append(String.valueOf(e) + "=" + this.entries.get(e));
            }
            BasicEList l = new BasicEList();
            l.add((Object)buf.toString());
            return l;
        }
    }
}

