/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.helpers;

import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.diagram.edit.helpers.MapBaseEditHelper;
import com.indy.map.diagram.edit.helpers.Messages;
import com.indy.map.geometry.path.DataSetDivider;
import com.indy.map.util.synchro.impl.listeners.DataSetUpdater;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;

public class OutlinerEditHelper
extends MapBaseEditHelper {
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        CompositeCommand cc = new CompositeCommand("Configure Serializer");
        cc.add((IUndoableOperation)new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ILogicalField srcField;
                MdNode node;
                Outliner outliner = (Outliner)((ConfigureRequest)this.getRequest()).getElementToConfigure();
                if (outliner.getAlias() == null) {
                    String alias = ((Map)outliner.eContainer()).createNewContainerAlias(Messages.OutlinerEditHelper_serializerDefaultName, 1);
                    outliner.setAlias(new QName(alias));
                }
                if ((node = (MdNode)((ConfigureRequest)this.getRequest()).getParameter("ref")) != null) {
                    outliner.setStagingArea((EObject)node);
                }
                if ((srcField = (ILogicalField)((ConfigureRequest)this.getRequest()).getParameter("srcField")) != null) {
                    outliner.getInputField().getExpression().forEach(e -> e.setExpression(srcField.getFullPath()));
                }
                return CommandResult.newOKCommandResult();
            }
        });
        return cc;
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        ICommand c;
        final Outliner d = (Outliner)req.getElementToDestroy();
        ArrayList<DataSetDivider.Division> divisions = new ArrayList<DataSetDivider.Division>();
        final CompoundCommand cc = new CompoundCommand("Destroy Outliner " + d.getAlias().toString());
        for (Join j : ((Map)d.eContainer()).getJoin()) {
            if (j.getLeft() != j.getRight() && (j.getLeft() == d || j.getRight() == d) && j.getLeft().getDataset() == j.getRight().getDataset()) {
                DataSetDivider.Division[] divisionArray = DataSetDivider.INSTANCE.divide(j.getLeft().getDataset(), j);
                int n = divisionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataSetDivider.Division div = divisionArray[n2];
                    if (!div.getContainers().contains(d)) {
                        divisions.add(div);
                    }
                    ++n2;
                }
            }
            if (j.getLeft() == d) {
                cc.append((Command)new SetCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)d), (EObject)j, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Left(), null){

                    public void doExecute() {
                        if (((Join)this.getOwner()).getLeft() != d) {
                            return;
                        }
                        super.doExecute();
                    }

                    public void doUndo() {
                        if (((Join)this.getOwner()).getLeft() != null) {
                            return;
                        }
                        super.doUndo();
                    }
                });
            }
            if (j.getRight() != d) continue;
            cc.append((Command)new SetCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)d), (EObject)j, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Right(), null){

                public void doExecute() {
                    if (((Join)this.getOwner()).getRight() != d) {
                        return;
                    }
                    super.doExecute();
                }

                public void doUndo() {
                    if (((Join)this.getOwner()).getRight() != null) {
                        return;
                    }
                    super.doUndo();
                }
            });
        }
        if (divisions.size() > 1) {
            cc.append(DataSetUpdater.INSTANCE.createSplitDataSetCommand(d.getDataset(), divisions.toArray(new DataSetDivider.Division[divisions.size()])));
        }
        CompositeCommand curCmd = new CompositeCommand("Delete Outliner " + d.getAlias().toString());
        if (!cc.isEmpty()) {
            AbstractTransactionalCommand emfCmd = new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)d), "Split DataSet", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.getEditingDomain().getCommandStack().execute((Command)cc);
                    return CommandResult.newOKCommandResult();
                }
            };
            curCmd.add((IUndoableOperation)emfCmd);
        }
        if ((c = super.getDestroyElementCommand(req)) != null) {
            curCmd.add((IUndoableOperation)c);
        }
        if (curCmd.isEmpty()) {
            return null;
        }
        return curCmd;
    }
}

