/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.parts;

import com.indy.gmf.map.diagram.custom.actions.FilterAction;
import com.indy.gmf.map.diagram.custom.edit.parts.DatastoreViewEditPart;
import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.diagram.edit.parts.MapEditPart;
import com.indy.map.diagram.edit.parts.MapEditPartFactory;
import com.indy.map.diagram.edit.policies.MapTextSelectionEditPolicy;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.diagram.providers.MapParserProvider;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RefPackage;
import com.stambia.md.provider.MdEditPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.directedit.TextDirectEditManager2;
import org.eclipse.gmf.tooling.runtime.draw2d.labels.SimpleLabelDelegate;
import org.eclipse.gmf.tooling.runtime.edit.policies.labels.IRefreshableFeedbackEditPolicy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class DatastoreAliasEditPart
extends CompartmentEditPart
implements ITextAwareEditPart {
    public static final int VISUAL_ID = 5005;
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    private ILabelDelegate labelDelegate;
    private Adapter refAdapter = new EContentAdapter(){

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getFeature() == RefPackage.eINSTANCE.getRDatastore_CountShownFields() || msg.getFeature() == RefPackage.eINSTANCE.getRSourceItem_Usage()) {
                DatastoreAliasEditPart.this.refreshLabel();
            }
        }
    };

    public void activate() {
        RContainer r;
        EObject obj = this.resolveSemanticElement();
        if (obj instanceof IContainer && (r = (RContainer)((IReferencable)obj).getMapReference()) != null) {
            r.eAdapters().add((Object)this.refAdapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.refAdapter.getTarget() != null) {
            this.refAdapter.getTarget().eAdapters().remove((Object)this.refAdapter);
        }
        super.deactivate();
    }

    public DatastoreAliasEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MapTextSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new MapEditPart.NodeLabelDragPolicy());
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof Label) {
            return ((Label)figure).getText();
        }
        return this.getLabelDelegate().getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof Label) {
            ((Label)figure).setText(text);
        } else {
            this.getLabelDelegate().setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof Label) {
            return ((Label)figure).getIcon();
        }
        return this.getLabelDelegate().getIcon(0);
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        int imgCount = 0;
        if (figure instanceof WrappingLabel) {
            if (this.getParent() instanceof DatastoreViewEditPart) {
                ((WrappingLabel)figure).setIcon(ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/16x16/shortcut16x16_fullsize.png")), imgCount++);
            }
            ((WrappingLabel)figure).setIcon(icon, imgCount++);
            List l = Collections.EMPTY_LIST;
            try {
                EObject o = this.resolveSemanticElement();
                if (o instanceof MapModelItem) {
                    if (((MapModelItem)o).getProperty().isEmpty()) {
                        ((WrappingLabel)figure).setIcon(null, imgCount++);
                    } else {
                        ((WrappingLabel)figure).setIcon(MapIconAPI.getPropertyIcon(), imgCount++);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (figure instanceof Label) {
            ((Label)figure).setIcon(icon);
            return;
        }
        if (this.getParent() instanceof DatastoreViewEditPart) {
            ((WrappingLabel)figure).setIcon(ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/16x16/shortcut16x16_fullsize.png")), imgCount++);
        }
        this.getLabelDelegate().setIcon(icon, imgCount++);
    }

    public void setLabel(WrappingLabel figure) {
        this.unregisterVisuals();
        this.setFigure((IFigure)figure);
        this.defaultText = this.getLabelTextHelper((IFigure)figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        String filterMode;
        EObject parserElement = this.getParserElement();
        if (!(parserElement instanceof Datastore)) {
            return null;
        }
        EAnnotation annote = FilterAction.getSortAnnotation((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getParent());
        String string = filterMode = annote == null ? null : (String)annote.getDetails().get((Object)"filterMode");
        if (annote == null || filterMode == null || "com.indy.gmf.map.diagram.filter.disable".equals(filterMode)) {
            return MapEditUtil.getDatastoreImage((Datastore)((Datastore)parserElement));
        }
        ArrayList<Image> l = new ArrayList<Image>();
        l.add(MapEditUtil.getDatastoreImage((Datastore)((Datastore)parserElement)));
        if (filterMode != null && !"com.indy.gmf.map.diagram.filter.disable".equals(filterMode)) {
            l.add(MapIconAPI.getImage((String)"full/obj16x16/Filtre16x16SimpleBleu.gif"));
        }
        ComposedImage img = new ComposedImage(l);
        return ExtendedImageRegistry.getInstance().getImage((Object)img);
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = this.defaultText;
        }
        return text;
    }

    public void setLabelText(String text) {
        this.setLabelTextHelper(this.getFigure(), text);
        this.refreshSelectionFeedback();
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        return this.getParser() != null;
    }

    public boolean isSelectable() {
        return false;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = DatastoreAliasEditPart.this.getParserElement();
                    final IParser parser = DatastoreAliasEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)DatastoreAliasEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl<IParserEditStatus>(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = MapParserProvider.getParser(MapElementTypes.Datastore_2004, this.getParserElement(), MapVisualIDRegistry.getType(5005));
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new TextDirectEditManager2((GraphicalEditPart)this, null, MapEditPartFactory.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager().getClass() == TextDirectEditManager2.class) {
            ((TextDirectEditManager2)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else if (this.getManager() instanceof TextDirectEditManager2) {
            ((TextDirectEditManager2)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (DatastoreAliasEditPart.this.isActive() && DatastoreAliasEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            DatastoreAliasEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && DatastoreAliasEditPart.this.getEditText().equals(DatastoreAliasEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            DatastoreAliasEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            DatastoreAliasEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        this.setLabelTextHelper(this.getFigure(), this.getLabelText());
        this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        this.refreshSelectionFeedback();
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    private void refreshSelectionFeedback() {
        this.requestEditPolicyFeedbackRefresh("PrimaryDrag Policy");
        this.requestEditPolicyFeedbackRefresh("Selection Feedback");
    }

    private void requestEditPolicyFeedbackRefresh(String editPolicyKey) {
        EditPolicy editPolicy = this.getEditPolicy(editPolicyKey);
        if (editPolicy instanceof IRefreshableFeedbackEditPolicy) {
            ((IRefreshableFeedbackEditPolicy)editPolicy).refreshFeedback();
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = DatastoreAliasEditPart.this.getLabelTextHelper(DatastoreAliasEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    private ILabelDelegate getLabelDelegate() {
        if (this.labelDelegate == null) {
            IFigure label = this.getFigure();
            this.labelDelegate = label instanceof WrappingLabel ? new WrappingLabelDelegate((WrappingLabel)label) : new SimpleLabelDelegate((Label)label);
        }
        return this.labelDelegate;
    }

    public Object getAdapter(Class key) {
        if (ILabelDelegate.class.equals((Object)key)) {
            return this.getLabelDelegate();
        }
        return super.getAdapter(key);
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
        if (event.getFeature() == MapPackage.eINSTANCE.getDatastore_UseCDC() || event.getFeature() == MapPackage.eINSTANCE.getDatastore_Control() || event.getFeature() == MapPackage.eINSTANCE.getDatastore_SetDescriptor()) {
            this.refreshLabel();
        }
    }

    protected IFigure createFigure() {
        return null;
    }
}

