/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.navigator;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.navigator.MapAbstractNavigatorItem;
import com.indy.map.diagram.navigator.MapDomainNavigatorItem;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.CustomResourceItemProviderAdapterFactory;
import com.indy.ui.custom.out.common.Unloadable;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class MapDomainNavigatorContentProvider
implements ICommonContentProvider,
Unloadable {
    private AdapterFactoryContentProvider myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(MapDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    protected Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public MapDomainNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.myEditingDomain.getResourceSet().getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", true);
        this.myEditingDomain.getResourceSet().getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, true);
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (MapDomainNavigatorContentProvider.this.myViewer != null) {
                    MapDomainNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                MapDomainNavigatorContentProvider.this.unloadAllResources();
                MapDomainNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                MapDomainNavigatorContentProvider.this.unloadAllResources();
                MapDomainNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                MapDomainNavigatorContentProvider.this.unloadAllResources();
                MapDomainNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    protected AdapterFactoryContentProvider getFactoryContentProvider() {
        return this.myAdapterFctoryContentProvier;
    }

    public void dispose() {
        this.myViewer = null;
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    protected void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile && "map".equals(((IFile)parentElement).getFileExtension())) {
            Resource resource;
            block4: {
                IFile file = (IFile)parentElement;
                URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                resource = null;
                try {
                    resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
                }
                catch (Throwable ex) {
                    resource = this.myEditingDomain.getResourceSet().getResource(fileURI, false);
                    if (resource != null) break block4;
                    MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", String.valueOf(Messages.MapDomainNavigatorContentProvider_1) + ex.getMessage(), ex));
                }
            }
            return this.wrapEObjects(this.myAdapterFctoryContentProvier.getChildren((Object)resource), parentElement);
        }
        if (parentElement instanceof MapDomainNavigatorItem) {
            return this.wrapEObjects(this.myAdapterFctoryContentProvier.getChildren((Object)((MapDomainNavigatorItem)((Object)parentElement)).getEObject()), parentElement);
        }
        return EMPTY_ARRAY;
    }

    public Object[] wrapEObjects(Object[] objects, Object parentElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof EObject) {
                result.add((Object)new MapDomainNavigatorItem((EObject)objects[i], parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier));
            } else if (objects[i] != null) {
                result.add(objects[i]);
            }
            ++i;
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof MapAbstractNavigatorItem) {
            MapAbstractNavigatorItem abstractNavigatorItem = (MapAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }

    public void unload(Object[] eObjects) {
        Object[] objectArray = eObjects;
        int n = eObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof MapDomainNavigatorItem) {
                AdapterFactory specAf;
                Resource resource = ((MapDomainNavigatorItem)((Object)o)).getEObject().eResource();
                this.myEditingDomain.getResourceToReadOnlyMap().remove(resource);
                resource.unload();
                EcoreUtil.remove((EObject)((MapDomainNavigatorItem)((Object)o)).getEObject());
                EcoreUtil.delete((EObject)((MapDomainNavigatorItem)((Object)o)).getEObject(), (boolean)true);
                resource.getResourceSet().getResources().remove((Object)resource);
                AdapterFactory af = this.myAdapterFctoryContentProvier.getAdapterFactory();
                if (af instanceof ComposedAdapterFactory && (specAf = ((ComposedAdapterFactory)af).getFactoryForType((Object)resource)) instanceof CustomResourceItemProviderAdapterFactory) {
                    ((CustomResourceItemProviderAdapterFactory)specAf).dispose();
                }
            }
            ++n2;
        }
    }

    protected AdapterFactoryEditingDomain getEditingDomain() {
        return this.myEditingDomain;
    }
}

