/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.navigator;

import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcDomainNavigatorItem;
import com.indy.map.IContainer;
import com.indy.map.IMetaData;
import com.indy.map.Template;
import com.indy.map.diagram.navigator.MapAbstractNavigatorItem;
import com.indy.map.diagram.navigator.MapNavigatorGroup;
import com.indy.map.diagram.navigator.MapNavigatorItem;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class MapNavigatorLinkHelper
implements ILinkHelper {
    private static IEditorInput getEditorInput(Diagram diagram) {
        Resource diagramResource = diagram.eResource();
        for (EObject nextEObject : diagramResource.getContents()) {
            if (nextEObject == diagram) {
                return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)diagramResource));
            }
            if (nextEObject instanceof Diagram) break;
        }
        URI uri = EcoreUtil.getURI((EObject)diagram);
        String editorName = String.valueOf(uri.lastSegment()) + '#' + diagram.eResource().getContents().indexOf((Object)diagram);
        URIEditorInput editorInput = new URIEditorInput(uri, editorName);
        return editorInput;
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        block11: {
            try {
                IStructuredSelection sel;
                ISelection o2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getSelectionProvider().getSelection();
                if (!(o2 instanceof IStructuredSelection) || !((sel = (IStructuredSelection)o2).getFirstElement() instanceof GraphicalEditPart)) break block11;
                EObject o3 = ((GraphicalEditPart)sel.getFirstElement()).resolveSemanticElement();
                if (o3 instanceof IContainer) {
                    try {
                        String type = ((View)((GraphicalEditPart)sel.getFirstElement()).getModel()).getType();
                        if (type.equals("5007")) {
                            return (IStructuredSelection)Platform.getAdapterManager().getAdapter((Object)((IContainer)o3).getStagingArea(), StructuredSelection.class);
                        }
                    }
                    catch (Exception type) {
                        // empty catch block
                    }
                }
                if (o3 instanceof IMetaData) {
                    IMetaData md = (IMetaData)o3;
                    return (IStructuredSelection)Platform.getAdapterManager().getAdapter((Object)md.getRef(), StructuredSelection.class);
                }
                if (o3 instanceof Template) {
                    Template in = (Template)o3;
                    if (in.getProcess() != null) {
                        IFile file = WorkspaceSynchronizer.getFile((Resource)in.getProcess().eResource());
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(file);
                        list.add(new ProcDomainNavigatorItem(in.getProcess(), (Object)file, null));
                        return new StructuredSelection(list.toArray());
                    }
                    break block11;
                }
                IFile file = WorkspaceSynchronizer.getFile((Resource)o3.eResource());
                return new StructuredSelection((Object)file);
            }
            catch (Exception o2) {
                // empty catch block
            }
        }
        IDiagramDocument document = MapDiagramEditorPlugin.getInstance().getDocumentProvider().getDiagramDocument(anInput);
        if (document == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = document.getDiagram();
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (file != null) {
            MapNavigatorItem item = new MapNavigatorItem((View)diagram, file, false);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        MapNavigatorGroup navigatorGroup;
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (!(aSelection.getFirstElement() instanceof MapAbstractNavigatorItem)) {
            return;
        }
        MapAbstractNavigatorItem abstractNavigatorItem = (MapAbstractNavigatorItem)((Object)aSelection.getFirstElement());
        View navigatorView = null;
        if (abstractNavigatorItem instanceof MapNavigatorItem) {
            navigatorView = ((MapNavigatorItem)abstractNavigatorItem).getView();
        } else if (abstractNavigatorItem instanceof MapNavigatorGroup && (navigatorGroup = (MapNavigatorGroup)abstractNavigatorItem).getParent() instanceof MapNavigatorItem) {
            navigatorView = ((MapNavigatorItem)((Object)navigatorGroup.getParent())).getView();
        }
        if (navigatorView == null) {
            return;
        }
        IEditorInput editorInput = MapNavigatorLinkHelper.getEditorInput(navigatorView.getDiagram());
        IEditorPart editor = aPage.findEditor(editorInput);
        if (editor == null) {
            return;
        }
        aPage.bringToTop((IWorkbenchPart)editor);
        if (editor instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)editor;
            ResourceSet diagramEditorResourceSet = diagramEditor.getEditingDomain().getResourceSet();
            EObject selectedView = diagramEditorResourceSet.getEObject(EcoreUtil.getURI((EObject)navigatorView), true);
            if (selectedView == null) {
                return;
            }
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
            EditPart selectedEditPart = (EditPart)graphicalViewer.getEditPartRegistry().get(selectedView);
            if (selectedEditPart != null) {
                graphicalViewer.select(selectedEditPart);
            }
        }
    }
}

