/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.part;

import com.indy.gmf.map.diagram.build.BuilderVersionManager;
import com.indy.gmf.map.diagram.build.ProjectConfigurationResourceListener;
import com.indy.gmf.map.diagram.custom.services.MapDropValidationService;
import com.indy.map.diagram.expressions.MapOCLFactory;
import com.indy.map.diagram.part.MapDocumentProvider;
import com.indy.map.diagram.providers.ElementInitializers;
import com.indy.map.edit.provider.MapItemProviderAdapterFactory;
import com.indy.map.ref.provider.RefItemProviderAdapterFactory;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.CustomResourceItemProviderAdapterFactory;
import com.indy.ui.custom.out.gmf.IDiagramResourceInitializer;
import com.indy.ui.custom.out.services.IDropValidationService;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MapDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.indy.gmf.map.diagram";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("com.indy.gmf.map.diagram");
    private static MapDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private MapDocumentProvider documentProvider;
    private ElementInitializers initializers;
    private MapOCLFactory oclFactory;
    private ServiceRegistration<IDropValidationService> dropValidationServiceRegistration;
    private ServiceRegistration<ICacheListener> cacheListenerServiceRegistration;
    private BuilderVersionManager builderVersionListener;
    ServiceReference<IDiagramResourceInitializer> ref = null;
    private static final String FILTER = "(fileExtension=map)";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
        if (this.dropValidationServiceRegistration == null) {
            this.dropValidationServiceRegistration = context.registerService(IDropValidationService.class, (Object)new MapDropValidationService(), null);
        }
        this.builderVersionListener = new BuilderVersionManager();
        this.cacheListenerServiceRegistration = context.registerService(ICacheListener.class, (Object)this.builderVersionListener, null);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectConfigurationResourceListener(), 3);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.ref != null) {
            this.getBundle().getBundleContext().ungetService(this.ref);
            this.ref = null;
        }
        if (this.dropValidationServiceRegistration != null) {
            this.dropValidationServiceRegistration.unregister();
        }
        if (this.cacheListenerServiceRegistration != null) {
            this.cacheListenerServiceRegistration.unregister();
            this.cacheListenerServiceRegistration = null;
        }
        try {
            this.builderVersionListener.saveData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        this.initializers = null;
        this.oclFactory = null;
        instance = null;
        super.stop(context);
    }

    public static MapDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new MapItemProviderAdapterFactory());
        factories.add((AdapterFactory)new RefItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        factories.add((AdapterFactory)new CustomResourceItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return MapDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, MapDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)MapDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    public MapDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            try {
                this.ref = this.getBundle().getBundleContext().getServiceReferences(IDiagramResourceInitializer.class.getName(), FILTER)[0];
                this.documentProvider = (MapDocumentProvider)((Object)this.getBundle().getBundleContext().getService(this.ref));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.documentProvider;
    }

    public ElementInitializers getElementInitializers() {
        return this.initializers;
    }

    public void setElementInitializers(ElementInitializers i) {
        this.initializers = i;
    }

    public MapOCLFactory getMapOCLFactory() {
        return this.oclFactory;
    }

    public void setMapOCLFactory(MapOCLFactory f) {
        this.oclFactory = f;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public Color mixColors(Color c1, Color c2) {
        RGB rgb = new RGB((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
        return Activator.getDefault().getColor(rgb);
    }
}

