/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.providers;

import com.indy.map.Field;
import com.indy.map.diagram.notation.mappingNotation.MappingNotationFactory;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.diagram.providers.MapElementTypes;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class MapViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        return true;
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "Map".equals(op.getSemanticHint()) && MapVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = MapVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = MapVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (!MapElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != MapVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"Map".equals(MapVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 2001: 
                    case 2002: 
                    case 2003: 
                    case 2004: 
                    case 2005: 
                    case 2007: 
                    case 2008: 
                    case 2009: 
                    case 3001: 
                    case 3002: 
                    case 3005: 
                    case 3007: 
                    case 3008: 
                    case 3009: 
                    case 3012: 
                    case 3014: {
                        if (domainElement != null && visualID == MapVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    case 5007: {
                        return MapVisualIDRegistry.getVisualID(op.getContainerView()) == 2004;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2009 == visualID || 2001 == visualID || 2002 == visualID || 2003 == visualID || 2004 == visualID || 2005 == visualID || 2007 == visualID || 2008 == visualID || 3001 == visualID || 3014 == visualID || 3002 == visualID || 3007 == visualID || 3008 == visualID || 3005 == visualID || 3012 == visualID || 3009 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!MapElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = MapVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == MapVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("Map");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? MapVisualIDRegistry.getNodeVisualID(containerView, domainElement) : MapVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2001: {
                return this.createQuery_2001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2009: {
                return this.createOutliner_2009(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2002: {
                return this.createFilter_2002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2003: {
                return this.createVariable_2003(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2004: {
                return this.createDatastore_2004(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2005: {
                return this.createJoin_2005(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2007: {
                return this.createInputParameter_2007(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2008: {
                return this.createOperator_2008(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3001: {
                return this.createSetDescriptor_3001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3014: {
                return this.createItemProperty_3014(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3002: {
                return this.createQueryField_3002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3007: {
                return this.createSetDescriptor_3007(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3008: {
                return this.createField_3008(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3005: {
                return this.createConstraint_3005(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3012: {
                return this.createComputedField_3012(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3009: {
                return this.createOutlinerField_3009(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        MapVisualIDRegistry.getVisualID(elementTypeHint);
        return null;
    }

    public Node createQuery_2001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        Node label5001 = this.createLabel((View)node, MapVisualIDRegistry.getType(5001));
        Node label5007 = this.createLabel((View)node, MapVisualIDRegistry.getType(5007));
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7001), false, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7011), false, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7002), true, false, true, true);
        Node label5008 = this.createLabel((View)node, MapVisualIDRegistry.getType(5008));
        label5008.getStyles().add((Object)NotationFactory.eINSTANCE.createDrawerStyle());
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7007), true, false, false, false);
        return node;
    }

    public Node createOutliner_2009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2009));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        Node label5001 = this.createLabel((View)node, MapVisualIDRegistry.getType(5090));
        Node label5007 = this.createLabel((View)node, MapVisualIDRegistry.getType(5007));
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7091), true, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7093), true, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7092), true, false, false, false);
        return node;
    }

    public Node createFilter_2002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFillStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        return node;
    }

    public Node createVariable_2003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2003));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        Node label5002 = this.createLabel((View)node, MapVisualIDRegistry.getType(5002));
        return node;
    }

    public Node createDatastore_2004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2004));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        Node label5005 = this.createLabel((View)node, MapVisualIDRegistry.getType(5005));
        Node label5007 = this.createLabel((View)node, MapVisualIDRegistry.getType(5007));
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7003), false, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7009), false, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7004), true, false, true, true);
        Node label5009 = this.createLabel((View)node, MapVisualIDRegistry.getType(5009));
        label5009.getStyles().add((Object)NotationFactory.eINSTANCE.createDrawerStyle());
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7005), false, false, true, true);
        return node;
    }

    public Node createJoin_2005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFillStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2005));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        return node;
    }

    public Node createInputParameter_2007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2007));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        Node label5010 = this.createLabel((View)node, MapVisualIDRegistry.getType(5010));
        return node;
    }

    public Node createOperator_2008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFillStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(MapVisualIDRegistry.getType(2008));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        return node;
    }

    public Node createSetDescriptor_3001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createItemProperty_3014(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3014));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createQueryField_3002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createOutlinerField_3009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3009));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createSetDescriptor_3007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3007));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createField_3008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3008));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        Field field = (Field)domainElement;
        if (!field.getChildren().isEmpty()) {
            FontStyle s = (FontStyle)node.getStyle(NotationPackage.eINSTANCE.getFontStyle());
            if (s == null) {
                s = NotationFactory.eINSTANCE.createFontStyle();
                node.getStyles().add((Object)s);
            }
            if (field.hasMappedChild()) {
                s.setItalic(true);
                s.setFontColor(FigureUtilities.colorToInteger((Color)ColorConstants.blue).intValue());
            } else {
                s.setFontColor(FigureUtilities.colorToInteger((Color)ColorConstants.black).intValue());
                s.setItalic(false);
            }
        }
        return node;
    }

    public Node createConstraint_3005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3005));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createComputedField_3012(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(MapVisualIDRegistry.getType(3012));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    private void stampShortcut(View containerView, Node target) {
        if (!"Map".equals(MapVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"Map");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            ts.setShowTitle(true);
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    private EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    public Node createDatastoreView(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        NodeView node = MappingNotationFactory.eINSTANCE.createNodeView();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType("datastore.view");
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement.eContainer());
        node.setSubElement(domainElement);
        this.stampShortcut(containerView, node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        Node label5005 = this.createLabel((View)node, MapVisualIDRegistry.getType(5005));
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7003), false, false, false, false);
        this.createCompartment((View)node, MapVisualIDRegistry.getType(7004), true, false, true, true);
        return node;
    }
}

