/*
 * Decompiled with CFR 0.152.
 */
package com.indy.administration.impl;

import com.indy.administration.AdministrationService;
import com.indy.administration.impl.Messages;
import com.semarchy.xdi.designer.core.services.IComponentService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;

@org.osgi.service.component.annotations.Component(service={IComponentService.class})
public class ComponentService
implements IComponentService {
    public static final String EXTENTION_POINT_ID = "com.indy.ui.custom.out.internalResources";
    private static final String EXTENSION_LICENSE_KEY = "permission.name";
    private static final String DEFINITION_PATH = "/internalResources/component.permission";
    private List<IComponentService.IComponent> components = new ArrayList<IComponentService.IComponent>();
    @Reference
    private AdministrationService adminService;

    @Activate
    public void activate(BundleContext ctx) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENTION_POINT_ID);
        HashSet<String> createdComponents = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String componentLabel = el.getDeclaringExtension().getLabel();
            if (componentLabel == null) {
                componentLabel = String.format(Messages.ComponentService_component_default_label, el.getContributor().getName());
            }
            if (createdComponents.add(componentLabel)) {
                Bundle bundle = Platform.getBundle((String)el.getContributor().getName());
                URL url = bundle.getEntry(DEFINITION_PATH);
                String licenseKey = null;
                if (url != null) {
                    Properties prop = new Properties();
                    try {
                        Throwable throwable = null;
                        Object var15_17 = null;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
                            prop.load(reader);
                            licenseKey = prop.getProperty(EXTENSION_LICENSE_KEY);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Component component = new Component(licenseKey, el.getContributor().getName(), componentLabel);
                this.components.add(component);
                if (licenseKey != null) {
                    this.adminService.createRole4Component(component);
                }
            }
            ++n2;
        }
    }

    public Optional<IComponentService.IComponent> getComponentByBundleProvider(String bundleName) {
        return this.components.stream().filter(c -> c instanceof Component && bundleName != null && bundleName.equals(((Component)c).bundleName)).findFirst();
    }

    public Collection<IComponentService.IComponent> getComponents() {
        return Collections.unmodifiableCollection(this.components);
    }

    private class Component
    implements IComponentService.IComponent {
        String licenseKey;
        String bundleName;
        String label;

        Component(String licenseKey, String bundleName, String label) {
            this.licenseKey = licenseKey;
            this.bundleName = bundleName;
            this.label = label;
        }

        public String getLicensePermission() {
            return this.licenseKey;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

