/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.impact.views;

import com.indy.ui.custom.out.Util;
import com.indy.ui.impact.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ViewPart;

public class DependencyView
extends ViewPart {
    public static final String ID = "com.indy.ui.impact.views.DependencyView";
    private ResourceManager resourceManager;
    private TableViewer viewer;
    private TableViewer missingViewer;
    static final ImageDescriptor copyImg;
    static final ImageDescriptor linkImg;

    static {
        try {
            copyImg = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/etool16/copy_edit.png"));
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        try {
            linkImg = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.ui.custom.out/icons/link_to_projectExplorer_16x16.png"));
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new FillLayout());
        SashForm cc = new SashForm(main, 256);
        Composite d = new Composite((Composite)cc, 0);
        TableColumnLayout layout = new TableColumnLayout();
        d.setLayout((Layout)layout);
        this.viewer = new TableViewer(d, 65538);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider(false));
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof URI) || ((URI)element).isPlatformResource();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                URI uri = null;
                if (o instanceof IFile) {
                    uri = Util.convertIFileToEMFURI((IFile)((IFile)o));
                } else if (o instanceof URI) {
                    uri = (URI)o;
                }
                if (uri != null) {
                    try {
                        IEditorDescriptor d = IDE.getEditorDescriptor((String)uri.lastSegment());
                        URIEditorInput editorInput = new URIEditorInput(uri);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, d.getId());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        TableColumn col = new TableColumn(this.viewer.getTable(), 16384);
        col.setText(Messages.DependencyView_5);
        col.setResizable(true);
        layout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(100, true));
        d = new Composite((Composite)cc, 0);
        layout = new TableColumnLayout();
        d.setLayout((Layout)layout);
        this.missingViewer = new TableViewer(d, 65538);
        this.missingViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.missingViewer.getTable().setHeaderVisible(true);
        this.missingViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.missingViewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider(true));
        TableColumn col1 = new TableColumn(this.missingViewer.getTable(), 16384);
        col1.setText(Messages.DependencyView_6);
        col1.setResizable(true);
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(1, 200, true));
        col1 = new TableColumn(this.missingViewer.getTable(), 16384);
        col1.setText(Messages.DependencyView_7);
        col1.setResizable(true);
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(3, 200, true));
        cc.setWeights(new int[]{2, 1});
        IActionBars actionBars = this.getViewSite().getActionBars();
        Action copy = new Action(Messages.DependencyView_8){

            public void run() {
                StringBuffer buf = new StringBuffer();
                if (DependencyView.this.viewer.getControl().isFocusControl()) {
                    Collection c = null;
                    c = DependencyView.this.viewer.getSelection().isEmpty() ? (Collection)DependencyView.this.viewer.getInput() : ((IStructuredSelection)DependencyView.this.viewer.getSelection()).toList();
                    for (Object o : c) {
                        buf.append(((ILabelProvider)DependencyView.this.viewer.getLabelProvider()).getText(o));
                        buf.append("\n");
                    }
                } else if (DependencyView.this.missingViewer.getControl().isFocusControl()) {
                    List model = (List)DependencyView.this.missingViewer.getInput();
                    List c = null;
                    c = DependencyView.this.missingViewer.getSelection().isEmpty() ? model : ((IStructuredSelection)DependencyView.this.missingViewer.getSelection()).toList();
                    for (Object[] o : c) {
                        buf.append((String)o[0]);
                        buf.append(";");
                        buf.append(((CustomLabelProvider)DependencyView.this.missingViewer.getLabelProvider()).getColumnText(o, 1));
                        buf.append("\n");
                    }
                }
                if (buf.length() > 0) {
                    String textData = buf.toString();
                    Clipboard clipboard = new Clipboard(DependencyView.this.viewer.getTable().getDisplay());
                    clipboard.setContents(new Object[]{textData}, new Transfer[]{TextTransfer.getInstance()});
                    clipboard.dispose();
                }
            }
        };
        copy.setToolTipText(Messages.DependencyView_12);
        copy.setImageDescriptor(copyImg);
        Action linkInProjectExplorer = new Action(Messages.DependencyView_13){

            public void run() {
                if (DependencyView.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                Object o = ((IStructuredSelection)DependencyView.this.viewer.getSelection()).getFirstElement();
                IFile f = null;
                if (o instanceof IFile) {
                    f = (IFile)o;
                } else if (o instanceof URI) {
                    f = Util.convertEMFURIToFile((URI)((URI)o));
                }
                if (f != null) {
                    IViewPart v = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (v == null) {
                        return;
                    }
                    CommonViewer viewer = (CommonViewer)v.getAdapter(CommonViewer.class);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)f), true);
                }
            }
        };
        linkInProjectExplorer.setToolTipText(Messages.DependencyView_14);
        linkInProjectExplorer.setImageDescriptor(linkImg);
        linkInProjectExplorer.setActionDefinitionId("com.indy.ui.custom.out.navigator.linkCommand");
        this.getSite().getKeyBindingService().registerAction((IAction)linkInProjectExplorer);
        actionBars.getToolBarManager().add((IAction)copy);
        actionBars.getToolBarManager().add((IContributionItem)new Separator());
        actionBars.getToolBarManager().add((IAction)linkInProjectExplorer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setInput(Object dependantFiles, Object missingFiles) {
        this.viewer.setInput(dependantFiles);
        this.missingViewer.setInput(missingFiles);
    }

    class CustomLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        boolean multiColumn = false;

        CustomLabelProvider(boolean multiColumn) {
            this.multiColumn = multiColumn;
        }

        private ResourceManager getResourceManager() {
            if (DependencyView.this.resourceManager == null) {
                DependencyView.this.resourceManager = (ResourceManager)new LocalResourceManager(JFaceResources.getResources());
            }
            return DependencyView.this.resourceManager;
        }

        protected Object getAdapter(Object o) {
            Object result;
            IAdaptable adaptable;
            Object result2;
            if (IWorkbenchAdapter.class.isInstance(o)) {
                return o;
            }
            if (o instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)o).getAdapter(IWorkbenchAdapter.class)) != null) {
                Assert.isTrue((boolean)IWorkbenchAdapter.class.isInstance(result2));
                return result2;
            }
            if (!(o instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(o, IWorkbenchAdapter.class)) != null) {
                return result;
            }
            return null;
        }

        public String getText(Object element) {
            IFile f;
            URI u;
            if (element instanceof URI && (u = (URI)element) != null && (f = Util.convertEMFURIToFile((URI)u)) != null) {
                element = f;
            }
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toPortableString();
            }
            if (element instanceof URI) {
                return ((URI)element).toPlatformString(true);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            IFile f;
            if (element instanceof String) {
                return null;
            }
            if (element instanceof URI && (f = Util.convertEMFURIToFile((URI)((URI)element))) != null) {
                element = f;
            }
            if (element instanceof URI && (f = Util.convertEMFURIToFile((URI)((URI)element))) != null && f.exists() && f.getProject().isOpen()) {
                element = f;
            }
            if ((adapter = (IWorkbenchAdapter)this.getAdapter(element)) == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor(element);
            if (descriptor == null) {
                return null;
            }
            return (Image)this.getResourceManager().get((DeviceResourceDescriptor)descriptor);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (this.multiColumn) {
                if (columnIndex == 1 && ((Object[])element).length > 1) {
                    return this.getImage(((Object[])element)[1]);
                }
                return null;
            }
            return this.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (this.multiColumn) {
                if (columnIndex == 1 && ((Object[])element).length > 1) {
                    return this.getText(((Object[])element)[1]);
                }
                if (columnIndex == 0) {
                    Object previous;
                    int index = ((List)DependencyView.this.missingViewer.getInput()).indexOf(element);
                    if (index != 0 && ((Object[])(previous = ((List)DependencyView.this.missingViewer.getInput()).get(index - 1)))[0].equals(((Object[])element)[0])) {
                        return "";
                    }
                    return (String)((Object[])element)[0];
                }
                return "";
            }
            return this.getText(element);
        }
    }
}

