/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.impact.views;

import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.UDFRef;
import com.indy.ui.custom.out.CustomSelectionListener;
import com.indy.ui.custom.out.INoPropertySheetProvider;
import com.indy.ui.impact.Messages;
import com.indy.ui.impact.SourceProvider;
import com.indy.ui.impact.views.ContentProvider;
import com.semarchy.xdi.designer.core.ImpactCapability;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

public class ImpactMonitor
extends ViewPart
implements INoPropertySheetProvider {
    private static final int CONTENT_PARENT = 1;
    private static final int CONTENT_CHILD = 16;
    private static final int CONTENT_USAGE = 256;
    private static final int CONTENT_REFERENCE = 4096;
    public static final String ID = "com.indy.ui.impact.views.ImpactView";
    private static final String DEFAULT_FILTER_TEXT = Messages.ImpactMonitor_1;
    private int contentTypeFlag = 4369;
    private TreeViewer viewer;
    private NameFilter nameFilter = new NameFilter();
    private EObject eObject;
    private EObject currentSelection;
    private static Image usageImg;
    private static Image referencesImg;
    private static Image containerImg;
    private static Image childrenImg;
    private Controler controler = new Controler();
    private static final String[] COMMABD_FILTER_IDS;

    static {
        ICommandImageService cmdImgService = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
        usageImg = cmdImgService.getImageDescriptor("com.indy.ui.impact.commands.filterUsedBy").createImage();
        referencesImg = cmdImgService.getImageDescriptor("com.indy.ui.impact.commands.filterUses").createImage();
        containerImg = cmdImgService.getImageDescriptor("com.indy.ui.impact.commands.filterContainer").createImage();
        childrenImg = cmdImgService.getImageDescriptor("com.indy.ui.impact.commands.filterChildren").createImage();
        COMMABD_FILTER_IDS = new String[]{"com.indy.ui.impact.commands.filterContainer", "com.indy.ui.impact.commands.filterChildren", "com.indy.ui.impact.commands.filterUses", "com.indy.ui.impact.commands.filterUsedBy"};
    }

    public ImpactMonitor() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        String[] stringArray = COMMABD_FILTER_IDS;
        int n = COMMABD_FILTER_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Command command = service.getCommand(s);
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            state.setValue((Object)true);
            service.refreshElements(s, null);
            ++n2;
        }
    }

    public Controler getControler() {
        return this.controler;
    }

    public void createPartControl(Composite parent) {
        this.setTitleToolTip(this.getTitle());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.indy.ui.help.redirects/designer/impact-view");
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        Composite impactComposite = new Composite(parent, 0);
        impactComposite.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        impactComposite.setLayoutData((Object)gridData);
        this.createImpactComposite(impactComposite);
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        CustomSelectionListener listener = null;
        listener = new CustomSelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part == ImpactMonitor.this) {
                    return;
                }
                super.selectionChanged(part, selection);
                ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
                SourceProvider commandStateService = (SourceProvider)sourceProviderService.getSourceProvider("com.indy.ui.impact.variables.impactAllowed");
                commandStateService.enableImpact(this.getEObject() != null && !(this.getEObject() instanceof Diagram));
                if (commandStateService.getCurrentState().get("com.indy.ui.impact.variables.impactAllowed").equals("DISABLED")) {
                    ImpactMonitor.this.eObject = null;
                    ImpactMonitor.this.currentSelection = null;
                }
            }

            public void handleSelectionChanged() {
                Object _temp;
                ImpactMonitor.this.currentSelection = this.getEObject();
                if (ImpactMonitor.this.currentSelection != null && (_temp = Platform.getAdapterManager().getAdapter((Object)ImpactMonitor.this.currentSelection, ImpactCapability.class)) != null) {
                    ImpactMonitor.this.currentSelection = ((ImpactCapability)_temp).getRef();
                }
            }

            protected void releasSpecializedResources(IWorkbenchPart part) {
                ImpactMonitor.this.currentSelection = null;
            }
        };
        service.addSelectionListener((ISelectionListener)listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        try {
            IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (part != null) {
                listener.selectionChanged((IWorkbenchPart)part, part.getSite().getSelectionProvider().getSelection());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            listener.selectionChanged(null, service.getSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createImpactComposite(Composite impactComposite) {
        final Tree tree = new Tree(impactComposite, 67584);
        tree.setHeaderVisible(true);
        GridData gridData = new GridData();
        gridData.heightHint = 100;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (tree.getSelection() != null && tree.getSelection().length == 1) {
                    TreeItem ti = tree.getSelection()[0];
                    if (!(ti.getData() instanceof ContentProvider.EntryNode)) {
                        return;
                    }
                    EObject o = (EObject)((ContentProvider.EntryNode)ti.getData()).getData();
                    if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        URI uri = EcoreUtil.getURI((EObject)o);
                        URIEditorInput input = null;
                        IEditorDescriptor desc = null;
                        input = new URIEditorInput(uri);
                        IEditorPart part = page.findEditor((IEditorInput)input);
                        if (part == null) {
                            desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(uri.trimFragment().lastSegment());
                            if (input != null && desc != null) {
                                try {
                                    part = page.openEditor((IEditorInput)input, desc.getId());
                                }
                                catch (PartInitException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        EObject toSelect = null;
                        if (part instanceof IEditingDomainProvider) {
                            toSelect = ((IEditingDomainProvider)part).getEditingDomain().getResourceSet().getEObject(uri, false);
                        } else {
                            AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
                            ((InternalEObject)proxy).eSetProxyURI(uri);
                            toSelect = proxy;
                        }
                        if (toSelect != null) {
                            IDiagramGraphicalViewer viewer;
                            if (part instanceof IViewerProvider) {
                                ((IViewerProvider)part).getViewer().setSelection((ISelection)new StructuredSelection((Object)toSelect));
                                page.activate((IWorkbenchPart)part);
                            } else if (part != null && (viewer = (IDiagramGraphicalViewer)part.getAdapter(GraphicalViewer.class)) != null) {
                                EditPart ep = ((IGraphicalEditPart)((DiagramRootEditPart)viewer.getRootEditPart()).getContents()).findEditPart((EditPart)viewer.getRootEditPart(), toSelect);
                                while (ep == null && (o instanceof Field || o instanceof Expression)) {
                                    o = o.eContainer();
                                    ep = ((IGraphicalEditPart)((DiagramRootEditPart)viewer.getRootEditPart()).getContents()).findEditPart((EditPart)viewer.getRootEditPart(), o);
                                }
                                if (ep != null) {
                                    StructuredSelection s = new StructuredSelection((Object)ep);
                                    viewer.setSelection((ISelection)s);
                                    viewer.reveal(ep);
                                    IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                    ed.getSite().getSelectionProvider().setSelection((ISelection)s);
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ed);
                                }
                                page.activate((IWorkbenchPart)part);
                            }
                        }
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Text text = new Text(impactComposite, 2048);
        text.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        text.setToolTipText(Messages.ImpactMonitor_21);
        text.setText(DEFAULT_FILTER_TEXT);
        text.setForeground(ColorConstants.gray);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String t = ((Text)e.widget).getText();
                if (ImpactMonitor.this.nameFilter.isActive()) {
                    ImpactMonitor.this.nameFilter.setFilter(t);
                }
            }
        });
        text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text text = (Text)e.widget;
                text.setForeground(ColorConstants.gray);
                if (text.getText().equals("")) {
                    ImpactMonitor.this.nameFilter.setActive(false);
                    text.setText(DEFAULT_FILTER_TEXT);
                    ImpactMonitor.this.nameFilter.setActive(true);
                }
            }

            public void focusGained(FocusEvent e) {
                Text text = (Text)e.widget;
                text.setForeground(ColorConstants.black);
                if (text.getText().equals(DEFAULT_FILTER_TEXT)) {
                    ImpactMonitor.this.nameFilter.setActive(false);
                    text.setText("");
                    ImpactMonitor.this.nameFilter.setActive(true);
                }
            }
        });
        this.viewer = new TreeViewer(tree);
        TreeColumn objectColumn = new TreeColumn(tree, 0);
        objectColumn.setText(Messages.ImpactMonitor_24);
        objectColumn.setResizable(true);
        objectColumn.setWidth(250);
        TreeColumn selfColumn = new TreeColumn(tree, 0);
        selfColumn.setText(Messages.ImpactMonitor_25);
        selfColumn.setResizable(true);
        selfColumn.setWidth(200);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ViewLabelProvider baseLabelProvider = new ViewLabelProvider(new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)baseLabelProvider);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addFilter((ViewerFilter)new ContentFilter());
        this.viewer.addFilter((ViewerFilter)this.nameFilter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void refreshViewer() {
        TreePath[] state = this.viewer.getExpandedTreePaths();
        this.viewer.refresh();
        this.viewer.setExpandedTreePaths(state);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class ContentFilter
    extends ViewerFilter {
        ContentFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ContentProvider.StaticNode) {
                ContentProvider.StaticNode n = (ContentProvider.StaticNode)element;
                if (ContentProvider.StaticNode.PARENT.equals(n.getData())) {
                    return (ImpactMonitor.this.contentTypeFlag & 1) == 1;
                }
                if (ContentProvider.StaticNode.CHILDREN.equals(n.getData())) {
                    return (ImpactMonitor.this.contentTypeFlag & 0x10) == 16;
                }
                if (ContentProvider.StaticNode.USAGE.equals(n.getData())) {
                    return (ImpactMonitor.this.contentTypeFlag & 0x100) == 256;
                }
                if (ContentProvider.StaticNode.REFERENCES.equals(n.getData())) {
                    return (ImpactMonitor.this.contentTypeFlag & 0x1000) == 4096;
                }
            }
            return true;
        }
    }

    public class Controler {
        public void filterContainer(boolean enabled) {
            if (enabled) {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag | 1;
            } else {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag & 0xFFFFFFFE;
            }
            ImpactMonitor.this.refreshViewer();
        }

        public void filterChildren(boolean enabled) {
            if (enabled) {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag | 0x10;
            } else {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag & 0xFFFFFFEF;
            }
            ImpactMonitor.this.refreshViewer();
        }

        public void filterUsedBy(boolean enabled) {
            if (enabled) {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag | 0x100;
            } else {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag & 0xFFFFFEFF;
            }
            ImpactMonitor.this.refreshViewer();
        }

        public void filterUses(boolean enabled) {
            if (enabled) {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag | 0x1000;
            } else {
                ImpactMonitor impactMonitor = ImpactMonitor.this;
                impactMonitor.contentTypeFlag = impactMonitor.contentTypeFlag & 0xFFFFEFFF;
            }
            ImpactMonitor.this.refreshViewer();
        }

        public void computeImpact() {
            ImpactMonitor.this.eObject = ImpactMonitor.this.currentSelection;
            ImpactMonitor.this.viewer.setInput((Object)ImpactMonitor.this.eObject);
        }

        public void clear() {
            ImpactMonitor.this.viewer.setInput(null);
            if (ImpactMonitor.this.viewer.getContentProvider() != null && ImpactMonitor.this.viewer.getContentProvider() instanceof ContentProvider) {
                ContentProvider cp = (ContentProvider)ImpactMonitor.this.viewer.getContentProvider();
                cp.reset();
            }
        }
    }

    class NameFilter
    extends ViewerFilter {
        private String[] filtersPart = null;
        private boolean active = true;

        NameFilter() {
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setFilter(String s) {
            this.filtersPart = s.split("\\*");
            if (this.active) {
                ImpactMonitor.this.viewer.refresh();
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ContentProvider.Node && ((ContentProvider.Node)element).getChilds().isEmpty()) {
                return false;
            }
            if (element instanceof ContentProvider.EntryNode) {
                if (this.filtersPart == null || this.filtersPart.length == 0) {
                    return true;
                }
                return this.checkRecursively((ContentProvider.EntryNode)element);
            }
            return true;
        }

        private boolean checkRecursively(ContentProvider.EntryNode element) {
            String label = ((ViewLabelProvider)ImpactMonitor.this.viewer.getLabelProvider()).getColumnText(element, 0);
            int currentIndex = 0;
            boolean match = true;
            String[] stringArray = this.filtersPart;
            int n = this.filtersPart.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.isEmpty()) {
                    int i = label.indexOf(s, currentIndex);
                    if (i >= 0) {
                        currentIndex = i;
                    } else {
                        match = false;
                        break;
                    }
                }
                ++n2;
            }
            if (!match) {
                for (ContentProvider.Node o : element.getChildNodes()) {
                    match = this.checkRecursively((ContentProvider.EntryNode)o);
                    if (!match) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        public boolean isActive() {
            return this.active;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AdapterFactoryLabelProvider o;

        public ViewLabelProvider(AdapterFactoryLabelProvider o) {
            this.o = o;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ContentProvider.Node) {
                obj = ((ContentProvider.Node)obj).getData();
            }
            if (index == 0) {
                EObject ref;
                if (obj instanceof UDFRef && (ref = ((UDFRef)obj).basicGetRef()) != null) {
                    try {
                        String fragment = CacheHelper.extractEltID((EObject)ref);
                        String[] parts = fragment.split("!");
                        if (parts.length == 3) {
                            StringBuffer b = new StringBuffer();
                            b.append(String.valueOf(parts[0]) + "::" + parts[1] + "(");
                            int i = 0;
                            while (i < Integer.valueOf(parts[2])) {
                                if (i > 0) {
                                    b.append(",");
                                }
                                b.append("p" + i);
                                ++i;
                            }
                            b.append(")");
                            return b.toString();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return this.o.getText(obj);
            }
            if (obj instanceof EObject && ((EObject)obj).eResource() != null) {
                String s = URI.decode((String)((EObject)obj).eResource().getURI().path());
                if (s.startsWith("/resource/")) {
                    s = s.substring("/resource".length());
                }
                return s;
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            Image img = null;
            if (index == 0) {
                if (obj instanceof ContentProvider.StaticNode) {
                    if (((String)((ContentProvider.StaticNode)obj).getData()).equals(ContentProvider.StaticNode.REFERENCES)) {
                        img = referencesImg;
                    }
                    if (((String)((ContentProvider.StaticNode)obj).getData()).equals(ContentProvider.StaticNode.USAGE)) {
                        img = usageImg;
                    }
                    if (((String)((ContentProvider.StaticNode)obj).getData()).equals(ContentProvider.StaticNode.CHILDREN)) {
                        img = childrenImg;
                    }
                    if (((String)((ContentProvider.StaticNode)obj).getData()).equals(ContentProvider.StaticNode.PARENT)) {
                        img = containerImg;
                    }
                } else if (obj instanceof ContentProvider.EntryNode) {
                    obj = ((ContentProvider.Node)obj).getData();
                    img = this.o.getColumnImage(obj, index);
                }
            }
            if (img != null && img.getImageData().width > 16) {
                return null;
            }
            return img;
        }

        public Image getImage(Object obj) {
            return this.getColumnImage(obj, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

