/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.hadoop;

import com.stambia.hadoop.kerberos.KerberosAuthentication;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class FileSystemWithAuth {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem get(final URI uri, final Configuration conf, String user, Properties authProperties) throws Exception {
        if (authProperties.size() > 0 && authProperties.get("KERBEROS_USER") != null) {
            FileSystem fs;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FileSystem.get((URI)uri, (Configuration)conf);
                }
            };
            ClassLoader clOrigin = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                fs = (FileSystem)KerberosAuthentication.doWithAuthentication(action, conf, authProperties);
            }
            finally {
                Thread.currentThread().setContextClassLoader(clOrigin);
            }
            return fs;
        }
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf, (String)user);
        return fs;
    }
}

