/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.hadoop;

import com.stambia.hadoop.kerberos.KerberosAuthentication;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;

public class HBaseWithAuth {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection(final Configuration conf, Properties authProperties) throws Exception {
        if (authProperties.size() > 0 && authProperties.get("KERBEROS_USER") != null) {
            Connection conn;
            String disabled = authProperties.getProperty("KERBEROS_DISABLE");
            if (disabled == null || !disabled.equals("true")) {
                String tmp;
                conf.set("hbase.security.authentication", "kerberos");
                if (conf.get("hbase.master.kerberos.principal") == null) {
                    tmp = authProperties.getProperty("KERBEROS_HBASE_MASTER_PRINCIPAL");
                    if (tmp != null) {
                        conf.set("hbase.master.kerberos.principal", tmp);
                    } else {
                        tmp = authProperties.getProperty("KERBEROS_USER");
                        if (tmp != null) {
                            conf.set("hbase.master.kerberos.principal", tmp);
                        }
                    }
                }
                if (conf.get("hbase.regionserver.kerberos.principal") == null) {
                    tmp = authProperties.getProperty("KERBEROS_HBASE_REGIONSERVER_PRINCIPAL");
                    if (tmp != null) {
                        conf.set("hbase.regionserver.kerberos.principal", tmp);
                    } else {
                        tmp = authProperties.getProperty("KERBEROS_USER");
                        if (tmp != null) {
                            conf.set("hbase.regionserver.kerberos.principal", tmp);
                        }
                    }
                }
            }
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConnectionFactory.createConnection((Configuration)conf);
                }
            };
            ClassLoader clOrigin = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                conn = (Connection)KerberosAuthentication.doWithAuthentication(action, conf, authProperties);
            }
            finally {
                Thread.currentThread().setContextClassLoader(clOrigin);
            }
            return conn;
        }
        return ConnectionFactory.createConnection((Configuration)conf);
    }
}

