/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.hadoop;

import com.stambia.hadoop.kerberos.KerberosAuthentication;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;

public class HttpURLConnectionWithAuth {
    public static HttpURLConnection get(final URL url, Configuration conf, Properties authProperties) throws Exception {
        if (authProperties.size() > 0 && authProperties.get("KERBEROS_USER") != null) {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                    return new AuthenticatedURL().openConnection(url, token);
                }
            };
            HttpURLConnection conn = (HttpURLConnection)KerberosAuthentication.doWithAuthentication(action, conf, authProperties);
            return conn;
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn;
    }
}

