/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.hadoop.kerberos;

import com.stambia.hadoop.kerberos.Messages;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class KerberosAuthentication {
    private static void setProperty(String key, String value) throws Exception {
        String _value = System.getProperty(key);
        if (!(_value == null || value != null && value.equals(_value))) {
            throw new Exception(Messages.getString("KerberosAuthentication.0") + key + Messages.getString("KerberosAuthentication.1"));
        }
        System.setProperty(key, value);
    }

    public static Object doWithAuthentication(PrivilegedExceptionAction callable, Configuration conf, Properties prop) throws Exception {
        String tmp = prop.getProperty("KERBEROS_DISABLE");
        if (tmp == null || !tmp.equals("true")) {
            tmp = prop.getProperty("KERBEROS_KRB5_CONF");
            if (tmp != null && System.getProperty("java.security.krb5.conf") == null) {
                KerberosAuthentication.setProperty("java.security.krb5.conf", tmp);
            }
            if ((tmp = prop.getProperty("KERBEROS_KRB5_DEBUG")) != null && System.getProperty("sun.security.krb5.debug") == null) {
                KerberosAuthentication.setProperty("sun.security.krb5.debug", tmp);
            }
            if ((tmp = prop.getProperty("KERBEROS_SECURITY_DEBUG")) != null && System.getProperty("java.security.debug") == null) {
                KerberosAuthentication.setProperty("java.security.debug", tmp);
            }
            if ((tmp = prop.getProperty("KERBEROS_SECURITY_AUTH_LOGIN_CONFIG")) != null && System.getProperty("java.security.auth.login.config") == null) {
                KerberosAuthentication.setProperty("java.security.auth.login.config", tmp);
            }
            if ((tmp = prop.getProperty("KERBEROS_DEBUG")) != null && tmp.equals("true")) {
                System.out.println(prop);
            }
            conf.set("hadoop.security.authentication", "Kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)prop.getProperty("KERBEROS_USER"), (String)prop.getProperty("KERBEROS_KEY_TAB_FILE"));
            return ugi.doAs(callable);
        }
        return callable.run();
    }

    public static Object doWithAuthentication2(PrivilegedExceptionAction callable, Configuration conf, Properties prop) throws Exception {
        String tmp = prop.getProperty("java.security.krb5.conf");
        if (tmp != null && System.getProperty("java.security.krb5.conf") == null) {
            KerberosAuthentication.setProperty("java.security.krb5.conf", tmp);
        }
        if ((tmp = prop.getProperty("sun.security.krb5.debug")) != null && System.getProperty("sun.security.krb5.debug") == null) {
            KerberosAuthentication.setProperty("sun.security.krb5.debug", tmp);
        }
        if ((tmp = prop.getProperty("java.security.debug")) != null && System.getProperty("java.security.debug") == null) {
            KerberosAuthentication.setProperty("java.security.debug", tmp);
        }
        if ((tmp = prop.getProperty("java.security.auth.login.config")) != null && System.getProperty("java.security.auth.login.config") == null) {
            KerberosAuthentication.setProperty("java.security.auth.login.config", tmp);
        }
        conf.set("hadoop.security.authentication", "Kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)prop.getProperty("KERBEROS_USER"), (String)prop.getProperty("KERBEROS_KEY_TAB_FILE"));
        return ugi.doAs(callable);
    }
}

