/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.hbase;

import com.stambia.udriver.hbase.HBaseDatabaseMetadata;
import com.stambia.udriver.hbase.HBasePreparedStatement;
import com.stambia.udriver.hbase.Messages;
import com.stambia.udriver.jdbc.ConnectionImpl;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hbase.client.Connection;

public class HBaseConnection
extends ConnectionImpl {
    private Connection connection;
    long startTimeStamp = -1L;
    long stopTimeStamp = -1L;
    Driver driver;
    int tableRowAnalyzeLimit = 100;

    public void setGlobalStopTimetamp(long ts) {
        this.stopTimeStamp = ts;
    }

    public void setGlobalStartTimetamp(long ts) {
        this.startTimeStamp = ts;
    }

    public HBaseConnection(Driver driver, Connection connection) {
        this.connection = connection;
        this.driver = driver;
    }

    public Connection getHbaseConnection() {
        return this.connection;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new HBaseDatabaseMetadata(this.driver, this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        HBasePreparedStatement st = new HBasePreparedStatement(this);
        return st;
    }

    @Override
    public PreparedStatement prepareStatement(String query) throws SQLException {
        HBasePreparedStatement st = new HBasePreparedStatement(this, query);
        return st;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("HBaseConnection.0"), e);
            }
            super.close();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
    }

    public int getTableRowAnalyzeLimit() {
        return this.tableRowAnalyzeLimit;
    }

    public void setMetadataAnalyse(int i) {
        this.tableRowAnalyzeLimit = i;
    }
}

