/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.hbase;

import com.stambia.udriver.hbase.HBaseConnection;
import com.stambia.udriver.hbase.Messages;
import com.stambia.udriver.jdbc.DatabaseMetadataImpl;
import com.stambia.udriver.jdbc.metadata.MetadataCatalogResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataColumnResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataSchemaResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataTableResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataTableTypeResultSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;

public class HBaseDatabaseMetadata
extends DatabaseMetadataImpl {
    public HBaseDatabaseMetadata(Driver driver, Connection connection) {
        super(driver, connection);
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaName, String filter, String[] typesFilter) throws SQLException {
        MetadataTableResultSetImpl res = new MetadataTableResultSetImpl();
        try {
            HTableDescriptor[] tableNames;
            for (HTableDescriptor tableName : tableNames = ((HBaseConnection)this.getConnection()).getHbaseConnection().getAdmin().listTableDescriptorsByNamespace(schemaName)) {
                if (((HBaseConnection)this.getConnection()).getHbaseConnection().getAdmin().isTableDisabled(tableName.getTableName()) || filter != null && !tableName.getTableName().getQualifierAsString().matches(filter.replace("%", "(.*)"))) continue;
                res.newRow();
                res.addField(new String(tableName.getTableName().getQualifier()), "TABLE_NAME");
                res.addField(new String(tableName.getTableName().getNamespace()), "TABLE_SCHEM");
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("HBaseDatabaseMetadata.0"), e);
        }
        return res;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        MetadataCatalogResultSetImpl res = new MetadataCatalogResultSetImpl();
        return res;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        MetadataColumnResultSetImpl res = new MetadataColumnResultSetImpl();
        res.addColumn("HBASE_FAMILY_NAME", 12);
        res.addColumn("HBASE_IS_MOB_ENABLED", 4);
        res.addColumn("HBASE_IS_ROW_KEY", 4);
        if (schemaPattern == null) {
            throw new SQLException(Messages.getString("HBaseDatabaseMetadata.1"));
        }
        try {
            HTableDescriptor desc = ((HBaseConnection)this.getConnection()).getHbaseConnection().getAdmin().getTableDescriptor(TableName.valueOf((byte[])schemaPattern.getBytes(), (byte[])tableNamePattern.getBytes()));
            try (Table table = ((HBaseConnection)this.getConnection()).getHbaseConnection().getTable(desc.getTableName());){
                Scan scan = new Scan();
                scan.setFilter((Filter)new PageFilter((long)((HBaseConnection)this.getConnection()).getTableRowAnalyzeLimit()));
                ResultScanner scanner = table.getScanner(scan);
                LinkedHashMap<String, ReverseFamilyInfo> allColumnsFound = new LinkedHashMap<String, ReverseFamilyInfo>();
                ReverseFamilyInfo rfi = new ReverseFamilyInfo();
                ReverseColumnInfo rci = new ReverseColumnInfo();
                rci.column = "row_key";
                rci.isKey = true;
                rfi.columns.put(rci.column, rci);
                allColumnsFound.put("", rfi);
                for (HColumnDescriptor hcd : table.getTableDescriptor().getColumnFamilies()) {
                    rfi = new ReverseFamilyInfo();
                    rfi.family = hcd.getNameAsString();
                    try {
                        rfi.isMob = hcd.isMobEnabled();
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    allColumnsFound.put(hcd.getNameAsString(), rfi);
                }
                Result rr = scanner.next();
                while (rr != null) {
                    for (Map.Entry pair : rr.getNoVersionMap().entrySet()) {
                        String family = new String((byte[])pair.getKey(), StandardCharsets.UTF_8);
                        rfi = (ReverseFamilyInfo)allColumnsFound.get(family);
                        if (rfi == null) continue;
                        for (Map.Entry pair2 : ((Map)pair.getValue()).entrySet()) {
                            String column = new String((byte[])pair2.getKey(), StandardCharsets.UTF_8);
                            if (rfi.columns.get(column) != null) continue;
                            rci = new ReverseColumnInfo();
                            rci.column = column;
                            rci.isKey = false;
                            rfi.columns.put(rci.column, rci);
                        }
                    }
                    rr = scanner.next();
                }
                int position = 1;
                for (ReverseFamilyInfo _rfi : allColumnsFound.values()) {
                    for (ReverseColumnInfo _rci : _rfi.columns.values()) {
                        res.newRow();
                        res.addField(table.getName().getNameAsString(), MetadataColumnResultSetImpl.MetadataColumnName.TABLE_NAME.name());
                        res.addField(table.getName().getNamespaceAsString(), MetadataColumnResultSetImpl.MetadataColumnName.TABLE_CAT.name());
                        res.addField(_rci.column, MetadataColumnResultSetImpl.MetadataColumnName.COLUMN_NAME.name());
                        res.addField(_rfi.family, "HBASE_FAMILY_NAME");
                        res.addField(_rci.isKey ? 1 : 0, "HBASE_IS_ROW_KEY");
                        res.addField(_rfi.isMob ? 1 : 0, "HBASE_IS_MOB_ENABLED");
                        res.addField(position++, "ORDINAL_POSITION");
                    }
                }
            }
        }
        catch (TableNotFoundException e) {
            throw new SQLException(Messages.getString("HBaseDatabaseMetadata.2"), e);
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("HBaseDatabaseMetadata.3"), e);
        }
        return res;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        MetadataSchemaResultSetImpl res = new MetadataSchemaResultSetImpl();
        if (catalog == null || catalog.isEmpty()) {
            try {
                NamespaceDescriptor[] namespaceDescriptors;
                for (NamespaceDescriptor nd : namespaceDescriptors = ((HBaseConnection)this.getConnection()).getHbaseConnection().getAdmin().listNamespaceDescriptors()) {
                    if (schemaPattern != null && !nd.getName().matches(schemaPattern.replace("%", "(.*)"))) continue;
                    res.newRow();
                    res.addField(nd.getName(), MetadataSchemaResultSetImpl.MetadataColumnName.TABLE_SCHEM.name());
                    res.addField(null, MetadataSchemaResultSetImpl.MetadataColumnName.TABLE_CAT.name());
                }
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("HBaseDatabaseMetadata.5"), e);
            }
        }
        return res;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        MetadataTableTypeResultSet mt = new MetadataTableTypeResultSet();
        mt.newRow();
        mt.addField("TABLE", "TABLE_TYPE");
        return mt;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "HBase";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return ((HBaseConnection)this.getConnection()).getHbaseConnection().getAdmin().getClusterStatus().getHBaseVersion();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getDriverName() throws SQLException {
        return "HBase Driver";
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            String str = this.getDatabaseProductVersion();
            String[] strs = str.split("\\.");
            return Integer.valueOf(strs[0]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            String str = this.getDatabaseProductVersion();
            String[] strs = str.split("\\.");
            return Integer.valueOf(strs[1]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new UnsupportedOperationException();
    }

    private class ReverseFamilyInfo {
        String family;
        Map<String, ReverseColumnInfo> columns = new LinkedHashMap<String, ReverseColumnInfo>();
        public boolean isMob;

        private ReverseFamilyInfo() {
        }
    }

    private class ReverseColumnInfo {
        String column;
        boolean isKey;

        private ReverseColumnInfo() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + Objects.hash(this.column);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReverseColumnInfo other = (ReverseColumnInfo)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.column, other.column);
        }

        private HBaseDatabaseMetadata getEnclosingInstance() {
            return HBaseDatabaseMetadata.this;
        }
    }
}

