/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.hbase;

import com.stambia.hadoop.ConfigurationUtils;
import com.stambia.hadoop.HBaseWithAuth;
import com.stambia.udriver.hbase.HBaseConnection;
import com.stambia.udriver.hbase.Messages;
import com.stambia.udriver.jdbc.DriverImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;

public class HBaseDriver
extends DriverImpl {
    public HBaseDriver() {
        super("jdbc:semarchy:hbase(.*)|jdbc:stambia:hbase(.*)", 1, 4);
    }

    @Override
    public Connection connect(String url, Properties prop) throws SQLException {
        String hbaseEncoding = "UTF-8";
        Properties arg1 = this.getProperties(url, "UTF-8", prop);
        Configuration conf = HBaseConfiguration.create();
        Properties props = arg1;
        conf = ConfigurationUtils.addConfigurationFromFiles(conf, props.getProperty("HADOOP_CONF_FILES"));
        conf.set("hbase.zookeeper.property.clientPort", arg1.getProperty("hbase.zookeeper.property.clientPort"));
        conf.set("hbase.zookeeper.quorum", arg1.getProperty("hbase.zookeeper.quorum"));
        try {
            SaslClientAuthenticationProviders.getInstance((Configuration)conf);
            HBaseWithAuth hwa = new HBaseWithAuth();
            org.apache.hadoop.hbase.client.Connection connection = hwa.createConnection(conf, props);
            HBaseConnection hc = new HBaseConnection(this, connection);
            String scanSize = arg1.getProperty("HBASE_TABLE_ROW_ANALYZE_LIMIT");
            if (scanSize == null) {
                hc.setMetadataAnalyse(100);
            } else {
                hc.setMetadataAnalyse(Integer.valueOf(scanSize));
            }
            return hc;
        }
        catch (Exception e) {
            throw new SQLException(Messages.getString("HBaseDriver.1"), e);
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            DriverManager.registerDriver(new HBaseDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(Messages.getString("HBaseDriver.0") + e.getMessage());
        }
    }
}

