/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.hbase;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.io.ByteStreams;
import com.stambia.udriver.hbase.HBaseConnection;
import com.stambia.udriver.hbase.HBaseDriver;
import com.stambia.udriver.hbase.HBaseResultSet;
import com.stambia.udriver.hbase.Messages;
import com.stambia.udriver.hbase.sql.parser.VerySimpleSqlParser;
import com.stambia.udriver.jdbc.ParameterMetaDataImpl;
import com.stambia.udriver.jdbc.PreparedStatementImpl;
import com.stambia.udriver.jdbc.ResultSetMetaDataImpl;
import com.stambia.udriver.jdbc.tools.ScriptManagerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class HBasePreparedStatement
extends PreparedStatementImpl {
    private HBaseConnection jdbcConnection;
    private String metadataEncoding = "UTF-8";
    private String dataEncoding = "UTF-8";
    Connection hbaseConnection;
    ResultSet rs;
    boolean prepared;
    ScriptDescriptor scriptDescriptor = new ScriptDescriptor();
    int updateCount = -1;
    Writer writer = new Writer();
    DMLDescriptor dmlDdlDescriptor = new DMLDescriptor();
    SelectDescriptor selectQuery = new SelectDescriptor();
    QueryType type;
    byte[][] parameters = new byte[0][];

    public HBasePreparedStatement(HBaseConnection hbaseConnection) {
        this.jdbcConnection = hbaseConnection;
        this.hbaseConnection = hbaseConnection.getHbaseConnection();
    }

    public HBasePreparedStatement(HBaseConnection hbaseConnection, String query) throws SQLException {
        this.jdbcConnection = hbaseConnection;
        this.hbaseConnection = hbaseConnection.getHbaseConnection();
        this.prepareStatement(query);
    }

    public void setMetadataEncoding(String encoding) {
        this.metadataEncoding = encoding;
    }

    private void prepareStatement(String paramQuery) throws SQLException {
        this.rs = null;
        this.writer = new Writer();
        this.dmlDdlDescriptor = new DMLDescriptor();
        this.selectQuery = new SelectDescriptor();
        this.scriptDescriptor = new ScriptDescriptor();
        if (paramQuery != null) {
            this.prepared = true;
            String lower = paramQuery.trim();
            if (lower.startsWith("script:")) {
                this.prepareWithScript(lower);
            } else if (lower.startsWith("descriptor:properties")) {
                this.prepareWithDescriptor(lower);
            } else {
                throw new SQLException(Messages.getString("HBasePreparedStatement.0") + paramQuery);
            }
        }
    }

    private void prepareWithScript(String statement) {
        String scriptLanguage;
        String lower = statement.trim();
        lower = lower.substring(7);
        int index = lower.indexOf("\n");
        this.type = QueryType.script;
        String queryToExecute = lower.substring(index).trim();
        this.scriptDescriptor.language = scriptLanguage = lower.substring(0, index);
        this.scriptDescriptor.script = queryToExecute;
    }

    private Query.Column parseColumn(String colExp) throws SQLException {
        Query.Column column = new Query.Column();
        String colTrim = colExp.trim();
        while (colTrim.contains("  ")) {
            colTrim = colTrim.replace("  ", " ");
        }
        String[] parts = colTrim.split("\\.");
        if (parts.length == 1) {
            colTrim = parts[0];
        } else if (parts.length == 2) {
            column.table = parts[0];
            colTrim = parts[1];
        } else {
            throw new SQLException(Messages.getString("HBasePreparedStatement.1"));
        }
        colTrim = colTrim.trim();
        parts = colTrim.split(" ");
        if (parts.length == 1) {
            column.name = parts[0];
        } else if (parts.length == 2) {
            column.name = parts[0];
            column.alias = parts[1];
        } else {
            throw new SQLException(Messages.getString("HBasePreparedStatement.2"));
        }
        return column;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareWithDescriptor(String paramStatement) throws SQLException {
        try {
            String statement = VerySimpleSqlParser.removeComment(paramStatement);
            Properties prop = new Properties();
            prop.load(new ByteArrayInputStream(statement.getBytes()));
            String version = (String)prop.get("descriptor.version");
            if (version == null) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.3"));
            }
            if (!version.equals("1")) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.4") + version);
            }
            String localType = (String)prop.get("type");
            if (localType == null) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.5"));
            }
            this.type = QueryType.valueOf(localType);
            if (this.type == QueryType.scan) {
                String joinsTypes;
                String joins;
                String tables = (String)prop.get("tables");
                HashMap<String, TableDescriptor> tableMap = new HashMap<String, TableDescriptor>();
                for (String _table : tables.trim().split(",")) {
                    Query.Table table = this.parseTable(_table);
                    TableDescriptor td = new TableDescriptor();
                    td.setTableName(table.namespace, table.name);
                    tableMap.put(table.alias != null ? table.alias : table.getName(), td);
                }
                String scanTable = (String)prop.get("scanTable");
                if (scanTable != null) {
                    scanTable = scanTable.trim();
                }
                if (scanTable != null && scanTable.contains(",")) {
                    throw new SQLException(Messages.getString("HBasePreparedStatement.6"));
                }
                String dataTable = null;
                if (tableMap.size() == 1) {
                    String alias = (String)tableMap.keySet().iterator().next();
                    TableDescriptor td = (TableDescriptor)tableMap.values().iterator().next();
                    if (scanTable != null && !alias.equals(scanTable)) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.7"));
                    }
                    dataTable = scanTable;
                    this.selectQuery.setDataTable(td);
                } else {
                    if (tableMap.size() != 2) throw new SQLException(Messages.getString("HBasePreparedStatement.10"));
                    if (scanTable == null) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.8"));
                    }
                    TableDescriptor td = (TableDescriptor)tableMap.get(scanTable);
                    if (td == null) throw new SQLException(Messages.getString("HBasePreparedStatement.9") + scanTable);
                    this.selectQuery.setScanTable(td);
                    for (String key : tableMap.keySet()) {
                        if (key.equals(scanTable)) continue;
                        dataTable = key;
                        this.selectQuery.setDataTable((TableDescriptor)tableMap.get(dataTable));
                    }
                }
                this.parseColumns(prop, tableMap);
                String filter = (String)prop.get("filters");
                if (filter != null) {
                    this.selectQuery.setFilter(filter);
                }
                if ((joins = (String)prop.get("joins")) != null) {
                    if (scanTable == null || dataTable == null) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.11"));
                    }
                    joins = joins.replace("\n", "");
                    joins = joins.replace("\t", "");
                    joins = joins.replace(" ", "");
                    joins = joins.trim();
                    String test1 = scanTable + ".row_key=" + dataTable + ".row_key";
                    String test2 = dataTable + ".row_key=" + scanTable + ".row_key";
                    if (!test1.equals(joins) && !test2.equals(joins)) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.12"));
                    }
                }
                if ((joinsTypes = (String)prop.get("joins.types")) != null) {
                    if (joinsTypes != null && joinsTypes.contains(",")) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.13"));
                    }
                    if (!joinsTypes.equalsIgnoreCase("inner")) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.14"));
                    }
                }
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    if (!(entry.getKey() instanceof String) || !entry.getKey().toString().startsWith("scan.")) continue;
                    this.selectQuery.addScanOption(entry.getKey().toString().substring("scan.".length()), entry.getValue().toString());
                }
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    if (!(entry.getKey() instanceof String) || !entry.getKey().toString().startsWith("get.")) continue;
                    this.selectQuery.addGetOption(entry.getKey().toString().substring("get.".length()), entry.getValue().toString());
                }
                return;
            } else if (this.type == QueryType.truncate || this.type == QueryType.drop) {
                String table = (String)prop.get("table");
                if (table == null) throw new SQLException();
                Query.Table t = this.parseTable(table);
                this.dmlDdlDescriptor.table = new TableDescriptor();
                this.dmlDdlDescriptor.table.setTableName(t.namespace, t.name);
                return;
            } else {
                if (this.type != QueryType.createTable && this.type != QueryType.put && this.type != QueryType.delete) return;
                String table = (String)prop.get("table");
                Query.Table t = this.parseTable(table);
                this.dmlDdlDescriptor.table = new TableDescriptor();
                this.dmlDdlDescriptor.table.setTableName(t.namespace, t.name);
                HashMap<String, TableDescriptor> map = new HashMap<String, TableDescriptor>();
                map.put(table, this.dmlDdlDescriptor.table);
                this.parseColumns(prop, map);
                if (this.type == QueryType.delete) {
                    this.writer.deleteMode = true;
                    if (this.dmlDdlDescriptor.table.columns.size() != 1) throw new SQLException(Messages.getString("HBasePreparedStatement.16"));
                    for (TableDescriptor.ColumnInfo name : this.dmlDdlDescriptor.table.columns) {
                        if (name.typeCol == TypeCol.key) continue;
                        throw new SQLException(Messages.getString("HBasePreparedStatement.15"));
                    }
                    return;
                } else if (this.type == QueryType.put) {
                    ArrayList<ParameterMetaDataImpl.Parameter> list = new ArrayList<ParameterMetaDataImpl.Parameter>();
                    for (TableDescriptor.ColumnInfo name : this.dmlDdlDescriptor.table.columns) {
                        ParameterMetaDataImpl.Parameter cm = new ParameterMetaDataImpl.Parameter();
                        list.add(cm);
                        if (name.dataType != null) {
                            if (name.dataType.equalsIgnoreCase("string")) {
                                cm.typeName = "VARCHAR";
                                cm.type = 12;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("longstring")) {
                                cm.typeName = "LONGVARCHAR";
                                cm.type = -1;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("integer")) {
                                cm.typeName = "INTEGER";
                                cm.type = 4;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("float")) {
                                cm.typeName = "FLOAT";
                                cm.type = 6;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("double")) {
                                cm.typeName = "DOUBLE";
                                cm.type = 8;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("long")) {
                                cm.typeName = "LONG";
                                cm.type = -5;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("boolean")) {
                                cm.typeName = "BOOLEAN";
                                cm.type = 16;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("bytes")) {
                                cm.typeName = "VARBINARY";
                                cm.type = -3;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("longbytes")) {
                                cm.typeName = "LONGVARBINARY";
                                cm.type = -4;
                                continue;
                            }
                            if (name.dataType.equalsIgnoreCase("decimal")) {
                                cm.typeName = "DECIMAL";
                                cm.type = 3;
                                continue;
                            }
                            if (!name.dataType.equalsIgnoreCase("short")) throw new SQLException(Messages.getString("HBasePreparedStatement.17"));
                            cm.typeName = "SMALLINT";
                            cm.type = 5;
                            continue;
                        }
                        cm.typeName = "LONGVARBINARY";
                        cm.type = -4;
                    }
                    this.setMetadata(new ParameterMetaDataImpl(list));
                    return;
                } else {
                    if (this.type != QueryType.createTable) return;
                    String mv = (String)prop.get("create.maxVersions");
                    this.dmlDdlDescriptor.maxVersions = Integer.valueOf(mv != null ? mv : "-1");
                    mv = (String)prop.get("create.minVersions");
                    this.dmlDdlDescriptor.minVersions = Integer.valueOf(mv != null ? mv : "-1");
                }
            }
            return;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Messages.getString("HBasePreparedStatement.18"), e);
        }
    }

    private void parseColumns(Properties prop, Map<String, TableDescriptor> tableMap) throws SQLException, UnsupportedEncodingException {
        String columns = (String)prop.get("columns");
        String defaultDataType = (String)prop.get("columns.defaultDataType");
        String dataTypes = (String)prop.get("columns.dataTypes");
        if (columns != null) {
            ArrayList<String> dataTypesList = new ArrayList<String>();
            if (dataTypes != null) {
                for (String dt : dataTypes.trim().split(",")) {
                    dataTypesList.add(dt.trim());
                }
            }
            int i = 0;
            for (String _column : columns.trim().split(",")) {
                Query.Column col = this.parseColumn(_column);
                if (col.table == null) {
                    if (tableMap.size() == 1) {
                        col.table = tableMap.values().iterator().next().tableName.getNameAsString();
                    } else {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.19") + col.name);
                    }
                }
                if (col.table != null) {
                    TableDescriptor t = tableMap.get(col.table);
                    if (t == null) {
                        if (tableMap.size() == 1) {
                            t = tableMap.values().iterator().next();
                        } else {
                            throw new SQLException(Messages.getString("HBasePreparedStatement.20") + col.table);
                        }
                    }
                    if (dataTypesList.size() > i) {
                        t.addColumn(col.name, col.alias, (String)dataTypesList.get(i));
                    } else {
                        t.addColumn(col.name, col.alias, defaultDataType);
                    }
                }
                ++i;
            }
        }
    }

    private Query.Table parseTable(String table) throws SQLException {
        while (table.contains("  ")) {
            table = table.replace("  ", " ");
        }
        Query.Table ttable = new Query.Table();
        String[] parts = table.split("\\.|:");
        Object namespace = null;
        if (parts.length == 1) {
            table = parts[0];
        } else if (parts.length == 2) {
            ttable.namespace = parts[0];
            table = parts[1];
        } else {
            throw new SQLException(Messages.getString("HBasePreparedStatement.21"));
        }
        table = table.trim();
        parts = table.split(" ");
        if (parts.length == 1) {
            ttable.name = parts[0];
        } else if (parts.length == 2) {
            ttable.name = parts[0];
            ttable.alias = parts[1];
        } else {
            throw new SQLException(Messages.getString("HBasePreparedStatement.22"));
        }
        return ttable;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public boolean execute(String paramQuery) throws SQLException {
        this.prepareStatement(paramQuery);
        this.doExecute();
        return this.rs != null;
    }

    private void doExecute() throws SQLException {
        if (this.type == QueryType.scan) {
            this.doExecuteResultSet();
        } else if (this.type == QueryType.truncate) {
            this.doExecuteTruncate();
        } else if (this.type == QueryType.createTable) {
            this.doExecuteCreate();
        } else if (this.type == QueryType.drop) {
            this.doExecuteDrop();
        } else if (this.type == QueryType.put) {
            this.doExecutePut();
        } else if (this.type == QueryType.delete) {
            this.doExecuteDelete();
        } else if (this.type == QueryType.script) {
            this.doExecuteScript();
        }
    }

    private void doExecuteScript() throws SQLException {
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HBaseDriver.class.getClassLoader());
        try {
            ScriptEngineManager stem = ScriptManagerUtil.getScriptEngineManager(HBaseDriver.class.getClassLoader());
            ScriptEngine se = stem.getEngineByName(this.scriptDescriptor.language);
            Bindings b = se.getBindings(100);
            b.put("__connection__", (Object)this.jdbcConnection);
            se.eval(this.scriptDescriptor.script);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
    }

    private void doExecuteDelete() throws SQLException {
        this.writer.execute();
    }

    private void doExecutePut() throws SQLException {
        this.writer.execute();
    }

    private void doExecuteTruncate() throws SQLException {
        try {
            HTableDescriptor td = this.hbaseConnection.getAdmin().getTableDescriptor(this.dmlDdlDescriptor.table.tableName);
            this.hbaseConnection.getAdmin().truncateTable(this.dmlDdlDescriptor.table.tableName, true);
            this.hbaseConnection.getAdmin().createTable((org.apache.hadoop.hbase.client.TableDescriptor)td);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void doExecuteDrop() throws SQLException {
        try {
            this.hbaseConnection.getAdmin().disableTable(this.dmlDdlDescriptor.table.tableName);
            this.hbaseConnection.getAdmin().deleteTable(this.dmlDdlDescriptor.table.tableName);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void doExecuteCreate() throws SQLException {
        HTableDescriptor desc = new HTableDescriptor(this.dmlDdlDescriptor.table.tableName);
        HashMap<String, byte[]> families = new HashMap<String, byte[]>();
        for (TableDescriptor.ColumnInfo ci : this.dmlDdlDescriptor.table.columns) {
            if (ci.typeCol != TypeCol.standard) continue;
            families.put(ci.familyAsString, ci.family);
        }
        for (byte[] family : families.values()) {
            HColumnDescriptor fDesc = new HColumnDescriptor(family);
            if (this.dmlDdlDescriptor.maxVersions > -1) {
                fDesc.setMaxVersions(this.dmlDdlDescriptor.maxVersions.intValue());
            }
            if (this.dmlDdlDescriptor.minVersions > -1) {
                fDesc.setMinVersions(this.dmlDdlDescriptor.minVersions);
            }
            desc.addFamily(fDesc);
        }
        try {
            this.hbaseConnection.getAdmin().createTable((org.apache.hadoop.hbase.client.TableDescriptor)desc);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.writer.createRow();
        this.writer.addCurrentRowToBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] ret = new int[]{0};
        if (this.type == QueryType.delete) {
            ret[0] = this.writer.executeBatch();
        } else if (this.type == QueryType.put) {
            ret[0] = this.writer.executeBatch();
        } else {
            throw new SQLException(Messages.getString("HBasePreparedStatement.29"));
        }
        return ret;
    }

    @Override
    public boolean execute() throws SQLException {
        this.rs = null;
        if (!this.prepared) {
            throw new SQLException(Messages.getString("HBasePreparedStatement.30"));
        }
        this.doExecute();
        return this.rs != null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.rs = null;
        this.prepareStatement(sql);
        this.doExecute();
        return this.rs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExecuteResultSet() throws SQLException {
        this.rs = new HBaseResultSet();
        ArrayList<ResultSetMetaDataImpl.ColumnMetadata> list = new ArrayList<ResultSetMetaDataImpl.ColumnMetadata>();
        for (int i = 0; i < this.selectQuery.dataTableDescriptor.columns.size(); ++i) {
            ResultSetMetaDataImpl.ColumnMetadata cm;
            block44: {
                block46: {
                    TableDescriptor.ColumnInfo name;
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    name = this.selectQuery.dataTableDescriptor.columns.get(i);
                                                    if (name.typeCol == TypeCol.key) {
                                                        ((HBaseResultSet)this.rs).addRowKey();
                                                    } else if (name.typeCol == TypeCol.timestamp) {
                                                        ((HBaseResultSet)this.rs).addTimeStamp();
                                                    } else {
                                                        ((HBaseResultSet)this.rs).addColumn(name.family, name.columnName);
                                                    }
                                                    cm = new ResultSetMetaDataImpl.ColumnMetadata();
                                                    cm.columnName = name.getNameAsString();
                                                    String string = cm.columnLabel = name.getAlias() != null ? name.getAlias() : name.getNameAsString();
                                                    if (name.dataType == null) break block46;
                                                    if (!name.dataType.equalsIgnoreCase("string")) break block47;
                                                    cm.columnTypeName = "VARCHAR";
                                                    cm.columnType = 12;
                                                    break block44;
                                                }
                                                if (!name.dataType.equalsIgnoreCase("longstring")) break block48;
                                                cm.columnTypeName = "LONGVARCHAR";
                                                cm.columnType = -1;
                                                break block44;
                                            }
                                            if (!name.dataType.equalsIgnoreCase("integer")) break block49;
                                            cm.columnTypeName = "INTEGER";
                                            cm.columnType = 4;
                                            break block44;
                                        }
                                        if (!name.dataType.equalsIgnoreCase("float")) break block50;
                                        cm.columnTypeName = "FLOAT";
                                        cm.columnType = 6;
                                        break block44;
                                    }
                                    if (!name.dataType.equalsIgnoreCase("double")) break block51;
                                    cm.columnTypeName = "DOUBLE";
                                    cm.columnType = 8;
                                    break block44;
                                }
                                if (!name.dataType.equalsIgnoreCase("long")) break block52;
                                cm.columnTypeName = "LONG";
                                cm.columnType = -5;
                                break block44;
                            }
                            if (!name.dataType.equalsIgnoreCase("boolean")) break block53;
                            cm.columnTypeName = "BOOLEAN";
                            cm.columnType = 16;
                            break block44;
                        }
                        if (!name.dataType.equalsIgnoreCase("bytes")) break block54;
                        cm.columnTypeName = "VARBINARY";
                        cm.columnType = -3;
                        break block44;
                    }
                    if (name.dataType.equalsIgnoreCase("longbytes")) {
                        cm.columnTypeName = "LONGVARBINARY";
                        cm.columnType = -4;
                        break block44;
                    } else if (name.dataType.equalsIgnoreCase("decimal")) {
                        cm.columnTypeName = "DECIMAL";
                        cm.columnType = 3;
                        break block44;
                    } else {
                        if (!name.dataType.equalsIgnoreCase("short")) {
                            throw new SQLException(Messages.getString("HBasePreparedStatement.31"));
                        }
                        cm.columnTypeName = "SMALLINT";
                        cm.columnType = 5;
                    }
                    break block44;
                }
                cm.columnTypeName = "LONGVARBINARY";
                cm.columnType = -4;
            }
            list.add(cm);
        }
        Scan scan = new Scan();
        if (this.jdbcConnection.stopTimeStamp > -1L) {
            try {
                if (this.jdbcConnection.startTimeStamp > -1L) {
                    scan.setTimeRange(this.jdbcConnection.startTimeStamp, this.jdbcConnection.stopTimeStamp);
                } else {
                    scan.setTimeRange(0L, this.jdbcConnection.stopTimeStamp);
                }
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.32"));
            }
        }
        ParseFilter pf = new ParseFilter();
        try {
            if (this.selectQuery.filter != null) {
                scan.setFilter(pf.parseFilterString(this.selectQuery.filter));
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("HBasePreparedStatement.33"), e);
        }
        Iterator<Map.Entry<String, String>> e = this.selectQuery.scanOptions.entrySet().iterator();
        while (true) {
            if (!e.hasNext()) {
                ((HBaseResultSet)this.rs).setQueryResult(this.jdbcConnection, scan, this.selectQuery.scanTableDescriptor, this.selectQuery.dataTableDescriptor, this.selectQuery.getOptions);
                ResultSetMetaDataImpl rsmi = new ResultSetMetaDataImpl(list);
                ((HBaseResultSet)this.rs).setMetadata(rsmi);
                return;
            }
            Map.Entry<String, String> entry = e.next();
            Method method = null;
            String[] values = entry.getValue().split(",");
            int nb = values.length;
            for (Method search : Scan.class.getMethods()) {
                if (!search.getName().equalsIgnoreCase("set" + entry.getKey()) || search.getParameterTypes().length != nb) continue;
                method = search;
                break;
            }
            if (method == null) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.34") + entry.getKey() + Messages.getString("HBasePreparedStatement.35"));
            }
            Object[] paramValues = new Object[nb];
            int i = 0;
            Class<?>[] classArray = method.getParameterTypes();
            int n = classArray.length;
            for (int j = 0; j < n; ++i, ++j) {
                Class<?> clazz = classArray[j];
                String value = values[i];
                if (clazz == byte[].class) {
                    if (value.startsWith("base64Binary:")) {
                        paramValues[i] = DatatypeConverter.parseBase64Binary((String)value.substring("base64Binary:".length()));
                        continue;
                    }
                    if (value.startsWith("string:")) {
                        paramValues[i] = Bytes.toBytes((String)value.substring("string:".length()));
                        continue;
                    }
                    if (value.startsWith("integer:")) {
                        paramValues[i] = Bytes.toBytes((int)Integer.valueOf(value.substring("integer:".length())));
                        continue;
                    }
                    if (value.startsWith("boolean:")) {
                        paramValues[i] = Bytes.toBytes((boolean)Boolean.valueOf(value.substring("boolean:".length())));
                        continue;
                    }
                    if (value.startsWith("double:")) {
                        paramValues[i] = Bytes.toBytes((double)Double.valueOf(value.substring("double:".length())));
                        continue;
                    }
                    if (value.startsWith("short:")) {
                        paramValues[i] = Bytes.toBytes((short)Short.valueOf(value.substring("short:".length())));
                        continue;
                    }
                    if (value.startsWith("long:")) {
                        paramValues[i] = Bytes.toBytes((long)Long.valueOf(value.substring("long:".length())));
                        continue;
                    }
                    if (value.toLowerCase().startsWith("decimal:")) {
                        paramValues[i] = Bytes.toBytes((BigDecimal)new BigDecimal(value.substring("long:".length())));
                        continue;
                    }
                    if (value.contains(":")) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.36") + value + Messages.getString("HBasePreparedStatement.37"));
                    }
                    throw new SQLException(Messages.getString("HBasePreparedStatement.38") + value + Messages.getString("HBasePreparedStatement.39"));
                }
                if (clazz == Boolean.TYPE) {
                    paramValues[i] = Boolean.valueOf(value);
                    continue;
                }
                if (clazz == Integer.TYPE) {
                    paramValues[i] = Integer.valueOf(value);
                    continue;
                }
                if (clazz == Double.TYPE) {
                    paramValues[i] = Double.valueOf(value);
                    continue;
                }
                if (clazz == Long.TYPE) {
                    paramValues[i] = Long.valueOf(value);
                    continue;
                }
                if (clazz == Float.TYPE) {
                    paramValues[i] = Float.valueOf(value);
                    continue;
                }
                if (clazz == Short.TYPE) {
                    paramValues[i] = Short.valueOf(value);
                    continue;
                }
                if (clazz != String.class) {
                    throw new SQLException(Messages.getString("HBasePreparedStatement.40") + clazz.getName() + Messages.getString("HBasePreparedStatement.41"));
                }
                paramValues[i] = value;
            }
            try {
                method.invoke((Object)scan, paramValues);
            }
            catch (IllegalArgumentException e2) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.42") + method.getName(), e2);
            }
            catch (IllegalAccessException e3) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.43") + method.getName(), e3);
            }
            catch (InvocationTargetException e4) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.44") + method.getName(), e4);
            }
        }
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        this.doSetValue(arg0, Bytes.toBytes((int)arg1));
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        this.doSetValue(arg0, Bytes.toBytes((short)arg1));
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        this.doSetValue(arg0, Bytes.toBytes((long)arg1));
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.doSetValue(arg0, Bytes.toBytes((double)arg1));
    }

    private void doSetValue(int arg0, byte[] o) {
        if (arg0 > this.parameters.length) {
            this.parameters = (byte[][])Arrays.copyOf(this.parameters, arg0);
        }
        this.parameters[arg0 - 1] = o;
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        if (arg1 == null) {
            this.doSetValue(arg0, null);
        } else if (this.dataEncoding == null) {
            this.doSetValue(arg0, arg1.getBytes());
        } else {
            try {
                this.doSetValue(arg0, arg1.getBytes(this.dataEncoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(Messages.getString("HBasePreparedStatement.45"), e);
            }
        }
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        if (arg1 == null) {
            this.doSetValue(arg0, null);
        } else {
            this.doSetValue(arg0, Bytes.toBytes((BigDecimal)arg1));
        }
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.doSetValue(arg0, Bytes.toBytes((boolean)arg1));
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        if (arg1 == null) {
            this.doSetValue(arg0, null);
        } else {
            try {
                byte[] inputAsBytes = ByteStreams.toByteArray((InputStream)arg1);
                this.doSetValue(arg0, inputAsBytes);
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = null;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            super.close();
        }
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        this.doSetValue(arg0, null);
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        this.setNull(arg0, arg1);
    }

    public class ScriptDescriptor {
        String language;
        String script;
    }

    public class Writer {
        Map<String, String> deleteOptions = new HashMap<String, String>();
        boolean deleteMode = false;
        Table table;
        List<Put> batchPut = new ArrayList<Put>();
        List<Delete> batchDelete = new ArrayList<Delete>();
        Put put;
        Delete delete;

        void addValue(byte[] familly, byte[] column, byte[] value) {
            this.put.addColumn(familly, column, value);
        }

        void addCurrentRowToBatch() {
            if (this.deleteMode) {
                this.batchDelete.add(this.delete);
                this.delete = null;
            } else {
                this.batchPut.add(this.put);
                this.put = null;
            }
        }

        void createRow() throws SQLException {
            if (HBasePreparedStatement.this.dmlDdlDescriptor.table.rowKeyPosition > -1) {
                if (this.deleteMode) {
                    this.delete = HBasePreparedStatement.this.jdbcConnection.stopTimeStamp > -1L ? new Delete(HBasePreparedStatement.this.parameters[HBasePreparedStatement.this.dmlDdlDescriptor.table.rowKeyPosition], HBasePreparedStatement.this.jdbcConnection.stopTimeStamp) : new Delete(HBasePreparedStatement.this.parameters[HBasePreparedStatement.this.dmlDdlDescriptor.table.rowKeyPosition]);
                } else {
                    byte[] rowKey = HBasePreparedStatement.this.parameters[HBasePreparedStatement.this.dmlDdlDescriptor.table.rowKeyPosition];
                    this.put = new Put(rowKey);
                }
            } else {
                throw new SQLException(Messages.getString("HBasePreparedStatement.23"));
            }
            if (!this.deleteMode) {
                for (int i = 0; i < HBasePreparedStatement.this.dmlDdlDescriptor.table.columns.size(); ++i) {
                    if (i == HBasePreparedStatement.this.dmlDdlDescriptor.table.rowKeyPosition) continue;
                    byte[] o = HBasePreparedStatement.this.parameters[i];
                    TableDescriptor.ColumnInfo name = HBasePreparedStatement.this.dmlDdlDescriptor.table.columns.get(i);
                    this.addValue(name.family, name.columnName, o);
                }
            }
        }

        int executeBatch() throws SQLException {
            int ret = 0;
            try {
                if (this.table == null) {
                    if (!HBasePreparedStatement.this.hbaseConnection.getAdmin().isTableEnabled(HBasePreparedStatement.this.dmlDdlDescriptor.table.tableName)) {
                        throw new SQLException(Messages.getString("HBasePreparedStatement.25") + HBasePreparedStatement.this.dmlDdlDescriptor.table.tableName.getNameAsString() + Messages.getString("HBasePreparedStatement.26"));
                    }
                    this.table = HBasePreparedStatement.this.hbaseConnection.getTable(HBasePreparedStatement.this.dmlDdlDescriptor.table.tableName);
                }
                if (!this.deleteMode) {
                    ret = this.batchPut.size();
                    if (ret > 0) {
                        this.table.put(this.batchPut);
                        HBasePreparedStatement.this.hbaseConnection.getAdmin().flush(this.table.getName());
                        this.batchPut.clear();
                    }
                    return ret;
                }
                ret = this.batchDelete.size();
                if (ret > 0) {
                    this.table.delete(this.batchDelete);
                    HBasePreparedStatement.this.hbaseConnection.getAdmin().flush(this.table.getName());
                    this.batchDelete.clear();
                }
                return ret;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }

        void execute() throws SQLException {
            try {
                if (this.table == null) {
                    this.table = HBasePreparedStatement.this.hbaseConnection.getTable(HBasePreparedStatement.this.dmlDdlDescriptor.table.tableName);
                }
                this.createRow();
                if (this.deleteMode) {
                    this.table.delete(this.delete);
                    HBasePreparedStatement.this.hbaseConnection.getAdmin().flush(this.table.getName());
                    this.delete = null;
                } else {
                    this.table.put(this.put);
                    HBasePreparedStatement.this.hbaseConnection.getAdmin().flush(this.table.getName());
                    this.put = null;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }

        void close() throws SQLException {
            if (this.table != null) {
                try {
                    this.table.close();
                    this.table = null;
                }
                catch (IOException e) {
                    throw new SQLException(Messages.getString("HBasePreparedStatement.27"), e);
                }
            }
        }
    }

    public class DMLDescriptor {
        public Integer maxVersions;
        TableDescriptor table;
        public int minVersions;
    }

    public class SelectDescriptor {
        Map<String, String> scanOptions = new HashMap<String, String>();
        Map<String, String> getOptions = new HashMap<String, String>();
        private TableDescriptor scanTableDescriptor;
        private TableDescriptor dataTableDescriptor;
        String filter;

        public void addScanOption(String key, String value) {
            this.scanOptions.put(key, value);
        }

        public void addGetOption(String key, String value) {
            this.getOptions.put(key, value);
        }

        public void setFilter(String filter) {
            if (filter != null && !filter.trim().isEmpty()) {
                this.filter = filter.trim();
            }
        }

        public TableDescriptor setScanTable(String name) throws IOException {
            if (name.contains(":")) {
                return this.setScanTable(name.substring(0, name.indexOf(":")), name.substring(name.indexOf(":") + 1));
            }
            return this.setScanTable("default", name);
        }

        public TableDescriptor setScanTable(String namespace, String paramTableName) throws IOException {
            TableDescriptor indexTableDescriptor = new TableDescriptor();
            indexTableDescriptor.setTableName(namespace, paramTableName);
            return indexTableDescriptor;
        }

        public void setScanTable(TableDescriptor indexTableDescriptor) {
            this.scanTableDescriptor = indexTableDescriptor;
        }

        public TableDescriptor setDataTable(String name) throws IOException {
            if (name.contains(":")) {
                return this.setDataTable(name.substring(0, name.indexOf(":")), name.substring(name.indexOf(":") + 1));
            }
            return this.setDataTable("default", "name");
        }

        public void setDataTable(TableDescriptor dataTableDescriptor) {
            this.dataTableDescriptor = dataTableDescriptor;
            if (this.scanTableDescriptor == null) {
                this.scanTableDescriptor = dataTableDescriptor;
            } else if (this.scanTableDescriptor.tableName.equals((Object)dataTableDescriptor.tableName)) {
                this.dataTableDescriptor = this.scanTableDescriptor;
            }
        }

        public TableDescriptor setDataTable(String namespace, String paramTableName) throws IOException {
            TableDescriptor localDataTableDescriptor = new TableDescriptor();
            localDataTableDescriptor.setTableName(namespace, paramTableName);
            this.setDataTable(localDataTableDescriptor);
            return localDataTableDescriptor;
        }
    }

    static enum QueryType {
        scan,
        script,
        truncate,
        createTable,
        drop,
        put,
        delete;

    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    static final class Query {
        int version = -1;
        Select select;

        Query() {
        }

        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
        static final class Filter {
            String expression;

            Filter() {
            }
        }

        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
        static final class Table {
            String name;
            String alias;
            String namespace;

            Table() {
            }

            public String getName() {
                if (this.namespace == null) {
                    return "default:" + this.name;
                }
                return this.namespace + ":" + this.name;
            }

            public String getAlias() {
                return this.alias;
            }
        }

        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
        static final class Column {
            public String table;
            String name;
            String alias;
            String dataType;

            Column() {
            }
        }

        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
        static final class Lookup {
            Table table;
            List<Column> columns;

            Lookup() {
            }
        }

        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
        static final class Select {
            Filter filter;
            Table table;
            List<Column> columns;
            Lookup lookup;

            Select() {
            }
        }
    }

    public class TableDescriptor {
        List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        TableName tableName;
        int rowKeyPosition = -1;

        public void setTableName(String namespace, String paramTableName) throws IOException {
            this.tableName = namespace != null ? TableName.valueOf((byte[])namespace.getBytes(HBasePreparedStatement.this.metadataEncoding), (byte[])paramTableName.getBytes(HBasePreparedStatement.this.metadataEncoding)) : TableName.valueOf((byte[])paramTableName.getBytes(HBasePreparedStatement.this.metadataEncoding));
        }

        private void doAddColumn(String familly, String colName, String alias, String type) throws UnsupportedEncodingException {
            this.columns.add(new ColumnInfo(familly, colName, alias, type));
            if (familly == null && colName.equals("row_key")) {
                this.rowKeyPosition = this.columns.size() - 1;
            }
        }

        public void addColumn(String name, String alias, String type) throws UnsupportedEncodingException {
            if (name.equals("row_key") || name.equals("Rowkey")) {
                this.doAddColumn(null, "row_key", alias, type);
            } else if (name.equals("cells_max_timestamp")) {
                this.doAddColumn(null, "cells_max_timestamp", alias, type);
            } else {
                this.doAddColumn(name.substring(0, name.indexOf(":")), name.substring(name.indexOf(":") + 1), alias, type);
            }
        }

        class ColumnInfo {
            String nameAsString;
            String familyAsString;
            byte[] family;
            byte[] columnName;
            TypeCol typeCol;
            private String alias;
            String dataType;

            String getNameAsString() {
                return this.nameAsString;
            }

            String getAlias() {
                return this.alias;
            }

            private ColumnInfo() {
                this.typeCol = TypeCol.key;
            }

            private ColumnInfo(String familly, String columnName, String alias, String type) throws UnsupportedEncodingException {
                StringBuilder sb = new StringBuilder();
                if (familly != null) {
                    this.familyAsString = familly;
                    sb.append(familly);
                    sb.append(":");
                    this.family = familly.getBytes(HBasePreparedStatement.this.metadataEncoding);
                } else {
                    if (columnName.equals("row_key")) {
                        this.typeCol = TypeCol.key;
                    }
                    if (columnName.equals("cells_max_timestamp")) {
                        this.typeCol = TypeCol.timestamp;
                    }
                }
                this.columnName = columnName.getBytes(HBasePreparedStatement.this.metadataEncoding);
                sb.append(columnName);
                this.nameAsString = sb.toString();
                this.alias = alias;
                this.dataType = type;
            }
        }
    }

    static enum TypeCol {
        standard,
        key,
        timestamp;

    }

    public static interface StreamHandler {
        public void readInputStream(InputStream var1);
    }

    public static interface CloseHandler {
        public void close();
    }
}

