/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.hbase;

import com.stambia.udriver.hbase.HBaseConnection;
import com.stambia.udriver.hbase.HBasePreparedStatement;
import com.stambia.udriver.hbase.Messages;
import com.stambia.udriver.jdbc.ResultSetImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseResultSet
extends ResultSetImpl {
    ResultScanner firstScanner;
    private Table dataTable;
    private HBasePreparedStatement.TableDescriptor dataTableDescriptor;
    private Table scanTable;
    long minTimeRange = -1L;
    long maxTimeRange = -1L;
    Iterator<Result> all;
    byte[][] families = new byte[0][];
    byte[][] colNames = new byte[0][];
    boolean[] rowKeys = new boolean[0];
    boolean[] timestamps = new boolean[0];
    Result current;
    Result[] currents;
    List<Get> fetchArray = new ArrayList<Get>();
    int fetchSize = 100;
    int i;
    int fetchIndex = 0;
    byte[] lastValue;

    public void setQueryResult(HBaseConnection connection, Scan scan, HBasePreparedStatement.TableDescriptor scanTableD, HBasePreparedStatement.TableDescriptor dataTableD, Map<String, String> getOptions) throws SQLException {
        try {
            String str;
            this.dataTableDescriptor = dataTableD;
            Table scanTable = connection.getHbaseConnection().getTable(scanTableD.tableName);
            if (dataTableD != null && !scanTableD.tableName.equals((Object)dataTableD.tableName)) {
                this.dataTable = connection.getHbaseConnection().getTable(dataTableD.tableName);
            }
            if (getOptions != null && (str = getOptions.get("timeRange")) != null) {
                int i = 0;
                for (String minMax : str.split(",")) {
                    if (i == 0) {
                        this.minTimeRange = Long.valueOf(minMax.trim());
                    } else if (i == 1) {
                        this.maxTimeRange = Long.valueOf(minMax.trim());
                    }
                    ++i;
                }
                if (i != 2) {
                    throw new SQLException(Messages.getString("HBaseResultSet.0"));
                }
            }
            if (connection.startTimeStamp > -1L) {
                this.minTimeRange = connection.startTimeStamp;
            }
            if (connection.stopTimeStamp > -1L) {
                this.maxTimeRange = connection.stopTimeStamp;
            }
            this.firstScanner = scanTable.getScanner(scan);
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("HBaseResultSet.1"), e);
        }
    }

    public void addColumn(byte[] family, byte[] column) {
        this.families = (byte[][])Arrays.copyOf(this.families, this.families.length + 1);
        this.colNames = (byte[][])Arrays.copyOf(this.colNames, this.colNames.length + 1);
        this.rowKeys = Arrays.copyOf(this.rowKeys, this.rowKeys.length + 1);
        this.timestamps = Arrays.copyOf(this.timestamps, this.timestamps.length + 1);
        this.families[this.families.length - 1] = family;
        this.colNames[this.colNames.length - 1] = column;
        this.rowKeys[this.rowKeys.length - 1] = false;
        this.timestamps[this.timestamps.length - 1] = false;
    }

    public void addRowKey() {
        this.addColumn(null, null);
        this.rowKeys[this.rowKeys.length - 1] = true;
    }

    private boolean read() throws SQLException {
        if (this.all == null) {
            this.all = this.firstScanner.iterator();
        }
        if (this.dataTable != null) {
            this.i = 0;
            while (this.i < this.fetchSize && this.all.hasNext()) {
                ++this.i;
                Get gets = new Get(this.all.next().getRow());
                if (this.minTimeRange > -1L) {
                    try {
                        gets.setTimeRange(this.minTimeRange, this.maxTimeRange);
                    }
                    catch (IOException e) {
                        throw new SQLException(Messages.getString("HBaseResultSet.2"), e);
                    }
                }
                this.fetchArray.add(gets);
            }
            return this.i > 0;
        }
        if (this.all.hasNext()) {
            this.current = this.all.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        boolean b;
        while ((b = this._next()) && this.current.isEmpty()) {
        }
        return b;
    }

    private boolean _next() throws SQLException {
        if (this.currents != null && this.fetchIndex < this.currents.length) {
            this.current = this.currents[this.fetchIndex++];
            return true;
        }
        if (this.read()) {
            if (this.dataTable != null) {
                this.currents = null;
                this.fetchIndex = 0;
                if (this.fetchArray.size() > 0) {
                    try {
                        this.currents = this.dataTable.get(this.fetchArray);
                        this.fetchArray.clear();
                    }
                    catch (IOException e) {
                        throw new SQLException(Messages.getString("HBaseResultSet.3"), e);
                    }
                    if (this.currents != null && this.fetchIndex < this.currents.length) {
                        this.current = this.currents[this.fetchIndex++];
                        return true;
                    }
                    return false;
                }
                this.currents = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        HBasePreparedStatement.TableDescriptor.ColumnInfo col = this.dataTableDescriptor.columns.get(columnIndex - 1);
        if (col.dataType != null) {
            if (col.dataType.equalsIgnoreCase("string") || col.dataType.equalsIgnoreCase("longstring")) {
                return this.getString(columnIndex);
            }
            if (col.dataType.equalsIgnoreCase("integer")) {
                return this.getInt(columnIndex);
            }
            if (col.dataType.equalsIgnoreCase("long")) {
                return this.getLong(columnIndex);
            }
            if (col.dataType.equalsIgnoreCase("double")) {
                return this.getDouble(columnIndex);
            }
            if (col.dataType.equalsIgnoreCase("decimal")) {
                return this.getBigDecimal(columnIndex);
            }
            if (col.dataType.equalsIgnoreCase("short")) {
                return this.getShort(columnIndex);
            }
            return this.lastValue;
        }
        return null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toString((byte[])this.lastValue);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str != null) {
            return new StringReader(str);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        final byte[] bytes = this.getBytes(columnIndex);
        if (bytes != null) {
            return new Blob(){

                @Override
                public long length() throws SQLException {
                    return bytes.length;
                }

                @Override
                public byte[] getBytes(long paramLong, int paramInt) throws SQLException {
                    throw new SQLFeatureNotSupportedException("getBytes");
                }

                @Override
                public InputStream getBinaryStream() throws SQLException {
                    return new ByteArrayInputStream(bytes);
                }

                @Override
                public long position(byte[] paramArrayOfByte, long paramLong) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public long position(Blob paramBlob, long paramLong) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public int setBytes(long paramLong, byte[] paramArrayOfByte) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public int setBytes(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public OutputStream setBinaryStream(long paramLong) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public void truncate(long paramLong) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public void free() throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }

                @Override
                public InputStream getBinaryStream(long paramLong1, long paramLong2) throws SQLException {
                    throw new SQLFeatureNotSupportedException("position");
                }
            };
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toBoolean((byte[])this.lastValue);
        }
        return false;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        return this.lastValue;
    }

    byte[] getFieldValue(int columnIndex) {
        int pos = columnIndex - 1;
        if (this.rowKeys[pos]) {
            return this.current.getRow();
        }
        if (this.timestamps[pos]) {
            long ts = 0L;
            for (Cell cell : this.current.listCells()) {
                if (cell.getTimestamp() <= ts) continue;
                ts = cell.getTimestamp();
            }
            return Bytes.toBytes((long)ts);
        }
        return this.current.getValue(this.families[pos], this.colNames[pos]);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValue == null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.firstScanner.close();
            this.fetchArray.clear();
            this.current = null;
            this.currents = null;
            if (this.dataTable != null) {
                try {
                    this.dataTable.close();
                    this.dataTable = null;
                }
                catch (IOException e) {
                    throw new SQLException(Messages.getString("HBaseResultSet.4"), e);
                }
            }
            if (this.scanTable != null) {
                try {
                    this.scanTable.close();
                    this.scanTable = null;
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
            if (this.firstScanner != null) {
                this.firstScanner.close();
                this.firstScanner = null;
            }
            super.close();
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        int type = this.getMetaData().getColumnType(columnIndex);
        switch (type) {
            case 6: {
                return this.getFloat(columnIndex);
            }
        }
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toDouble((byte[])this.lastValue);
        }
        return 0.0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        int type = this.getMetaData().getColumnType(columnIndex);
        if (type == 6) {
            this.lastValue = this.getFieldValue(columnIndex);
            if (this.lastValue != null) {
                return Bytes.toFloat((byte[])this.lastValue);
            }
        } else {
            throw new SQLException(Messages.getString("HBaseResultSet.5"));
        }
        return 0.0f;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int type = this.getMetaData().getColumnType(columnIndex);
        switch (type) {
            case -6: 
            case 5: {
                return this.getShort(columnIndex);
            }
        }
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toInt((byte[])this.lastValue);
        }
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toShort((byte[])this.lastValue);
        }
        return 0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toBigDecimal((byte[])this.lastValue);
        }
        return null;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        int type = this.getMetaData().getColumnType(columnIndex);
        switch (type) {
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
        }
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Bytes.toLong((byte[])this.lastValue);
        }
        return 0L;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    public void addTimeStamp() {
        this.addColumn(null, null);
        this.timestamps[this.timestamps.length - 1] = true;
    }
}

