/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.hbase.sql.parser;

import com.stambia.udriver.hbase.sql.parser.Messages;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class VerySimpleSqlParser {
    boolean removeOneEqualsOne = true;
    boolean parseWereClause = false;

    public static String removeComment(String query) {
        StringBuilder sb = new StringBuilder();
        char c1 = '\u0000';
        char c2 = '\u0000';
        int i = 0;
        int position = -1;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (char c : query.toCharArray()) {
            if (i == 0) {
                c2 = c;
            } else {
                c1 = c2;
                c2 = c;
            }
            if (i > 0) {
                if (position == -1) {
                    if (c1 == '/' && c2 == '*') {
                        position = i - 1;
                    }
                } else if (c1 == '*' && c2 == '/') {
                    map.put(position, i);
                    position = -1;
                }
            }
            ++i;
        }
        i = 0;
        int k = -1;
        for (char c : query.toCharArray()) {
            Integer _k = (Integer)map.get(i);
            if (_k != null) {
                k = _k;
            }
            if (k <= -1 || k < i) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws SQLException {
        System.out.println(VerySimpleSqlParser.removeComment("bla /* mmm */ bla "));
        System.out.println(VerySimpleSqlParser.removeComment("/* mmm */"));
        System.out.println(new VerySimpleSqlParser().parse("Select\ncol1 from tt coucou, tata kiki\nwhere\nkk").toString());
    }

    public void setRemoveOneEqualsOne(boolean bool) {
        this.removeOneEqualsOne = bool;
    }

    public void setParseWhereClause(boolean bool) {
        this.parseWereClause = bool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sql parse(String _query) throws SQLException {
        Sql sql = new Sql();
        String query = _query.trim();
        String lower = (query = VerySimpleSqlParser.removeComment(query)).toLowerCase();
        if (!lower.startsWith("select ") && !lower.startsWith("select\n") && !lower.startsWith("select\t")) throw new SQLException();
        int index = this.indexOf(query = query.substring("select".length() + 1), "from");
        if (index <= -1) throw new SQLException(Messages.getString("VerySimpleSqlParser.0") + _query);
        String select = query.substring(0, index);
        select = select.trim();
        sql.select.parse(select);
        query = query.substring(index + " from ".length());
        query = query.trim();
        lower = query.toLowerCase();
        index = this.indexOf(query, "where");
        if (index > -1) {
            String from = query.substring(0, index);
            sql.from.parse(from);
            query = query.substring(index + " where ".length());
            query = query.trim();
            lower = query.toLowerCase();
            String where = query;
            sql.where.parse(where);
            return sql;
        } else {
            String from = query;
            sql.from.parse(from);
        }
        return sql;
    }

    int indexOf(String str, String exp) {
        char[] chars;
        for (char _charPre : chars = new char[]{' ', '\n', '\t'}) {
            for (char _charPost : chars) {
                String _str = _charPre + exp + _charPost;
                int index = str.indexOf(_str);
                if (index <= -1) continue;
                return index;
            }
        }
        return -1;
    }

    public class Sql {
        Select select;
        From from;
        Where where;

        public Sql() {
            this.select = new Select();
            this.from = new From();
            this.where = new Where();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.select.toString());
            sb.append("\n");
            sb.append(this.from.toString());
            sb.append("\n");
            sb.append(this.where.toString());
            sb.append("\n");
            return sb.toString();
        }

        public From getFrom() {
            return this.from;
        }

        public Select getSelect() {
            return this.select;
        }

        public Where getWhere() {
            return this.where;
        }
    }

    public class Select {
        List<Column> columns = new ArrayList<Column>();

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT \n");
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                sb.append(this.columns.get(i).toString());
            }
            return sb.toString();
        }

        public void parse(String _select) throws SQLException {
            String select = _select.trim();
            for (String _col : _select.split(",")) {
                Column column = new Column();
                this.columns.add(column);
                String colTrim = _col.trim();
                while (colTrim.contains("  ")) {
                    colTrim = colTrim.replace("  ", " ");
                }
                String[] parts = colTrim.split("\\.");
                Object table = null;
                if (parts.length == 1) {
                    colTrim = parts[0];
                } else if (parts.length == 2) {
                    column.table = parts[0];
                    colTrim = parts[1];
                } else {
                    throw new SQLException();
                }
                colTrim = colTrim.trim();
                parts = colTrim.split(" ");
                if (parts.length == 1) {
                    column.name = parts[0];
                    continue;
                }
                if (parts.length == 2) {
                    column.name = parts[0];
                    column.alias = parts[1];
                    continue;
                }
                throw new SQLException();
            }
        }

        public List<Column> getColumns() {
            return Collections.unmodifiableList(this.columns);
        }
    }

    public class From {
        List<Table> tables = new ArrayList<Table>();

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FROM \n");
            for (int i = 0; i < this.tables.size(); ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                sb.append(this.tables.get(i).toString());
            }
            return sb.toString();
        }

        public Table parseTable(String table) throws SQLException {
            Table ttable = new Table();
            String[] parts = table.split("\\.");
            Object namespace = null;
            if (parts.length == 1) {
                table = parts[0];
            } else if (parts.length == 2) {
                ttable.namespace = parts[0];
                table = parts[1];
            } else {
                throw new SQLException();
            }
            table = table.trim();
            parts = table.split(" ");
            if (parts.length == 1) {
                ttable.name = parts[0];
            } else if (parts.length == 2) {
                ttable.name = parts[0];
                ttable.alias = parts[1];
            } else {
                throw new SQLException();
            }
            return ttable;
        }

        public void parse(String _from) throws SQLException {
            String from = _from.trim();
            for (String _table : from.split(",")) {
                String table = _table.trim();
                table = table.replace("\n", " ");
                table = table.replace("\t", " ");
                while (table.contains("  ")) {
                    table = table.replace("  ", " ");
                }
                int index = table.indexOf(" inner join ");
                if (index > -1) {
                    String left = table.substring(0, index);
                    String right = table.substring(index + 1);
                    if ((index = right.indexOf(" on ")) <= -1) {
                        throw new SQLException();
                    }
                    String expression = right.substring(index + " on ".length());
                    right = right.substring(" inner join ".length() - 1, index);
                    Table tleft = this.parseTable(left);
                    this.tables.add(tleft);
                    Table tright = this.parseTable(right);
                    Join join = new Join();
                    join.left = tleft;
                    join.right = tright;
                    join.expression = expression;
                    tleft.join = join;
                    continue;
                }
                this.parseTable(table);
            }
        }

        public List<Table> getTable() {
            return Collections.unmodifiableList(this.tables);
        }
    }

    public class Where {
        List<Clause> clauses = new ArrayList<Clause>();

        public void parse(String _where) throws SQLException {
            String where = _where.trim();
            if (VerySimpleSqlParser.this.removeOneEqualsOne) {
                where = where.replaceFirst("\\([ \t\n]*1[ \t\n]*=[ \t\n]*1[ \t\n]*\\)[ \t\n]*((?i)a(?i)n(?i)d[ \t\n]*)?", "");
                where = where.trim();
            }
            if (!where.isEmpty()) {
                if (!VerySimpleSqlParser.this.parseWereClause) {
                    Clause clause = new Clause();
                    clause.expression = where;
                    this.clauses.add(clause);
                } else {
                    throw new SQLException();
                }
            }
        }

        public String toString() {
            if (this.clauses.size() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("WHERE\n");
                for (int i = 0; i < this.clauses.size(); ++i) {
                    if (i > 0) {
                        sb.append(",\n");
                    }
                    sb.append(this.clauses.get(i).toString());
                }
                return sb.toString();
            }
            return "";
        }

        public List<Clause> getClauses() {
            return Collections.unmodifiableList(this.clauses);
        }
    }

    public class Column {
        public String table;
        public String name;
        public String alias;

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            if (this.alias != null) {
                return this.name + " " + this.alias;
            }
            return this.name;
        }
    }

    public class Table {
        public Join join;
        public String name;
        public String alias;
        public String namespace;

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            if (this.alias != null) {
                return this.name + " " + this.alias;
            }
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public class Join {
        public Table left;
        public Table right;
        public String expression;
    }

    public class Clause {
        String expression;

        public String toString() {
            return this.expression;
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

