/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom;

import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.custom.ActionDefinitionHelper;
import com.indy.gmf.proc.diagram.non_rcp.custom.Messages;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheEventResource;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.tech.DocumentRoot;
import com.stambia.tech.Level;
import com.stambia.tech.MetaDataLinkType;
import com.stambia.tech.Tech;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={MdLinkHelper.class, ICacheListener.class, ICacheService.ICacheServiceListener.class}, scope=ServiceScope.SINGLETON)
public class MdLinkHelper
implements ICacheListener,
ICacheService.ICacheServiceListener {
    private Graph graph = new Graph();
    private Map<String, Collection<ActionDefinitionHelper.ActionDefinition>> actionDefByLevelCode = new HashMap<String, Collection<ActionDefinitionHelper.ActionDefinition>>();
    private Map<String, Collection<String>> lvlCodeByTechIds = new HashMap<String, Collection<String>>();
    private Lock writeLock = new ReentrantLock();
    private boolean inited = false;
    private HashMap<String, Collection<String>> paramDefLvlCodes = new HashMap();
    private Collection<ActionDefinitionHelper.ActionDefinition> currentResult = null;

    private void initialize() {
        try {
            ResourceSetImpl rs = new ResourceSetImpl();
            rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
            rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
            for (URI uri : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getMdTechRegistry().getTechUris()) {
                Resource r = null;
                try {
                    try {
                        r = rs.getResource(uri, true);
                        Tech t = ((DocumentRoot)r.getContents().get(0)).getTech();
                        if (t != null) {
                            this.analyzeCode(t);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (r == null) continue;
                        r.unload();
                        rs.getResources().remove((Object)r);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        r.unload();
                        rs.getResources().remove((Object)r);
                    }
                    throw throwable;
                }
                if (r == null) continue;
                r.unload();
                rs.getResources().remove((Object)r);
            }
            this.inited = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Collection<ActionDefinitionHelper.ActionDefinition> getActionDefinitionFor(Level lvl) {
        Collection<ActionDefinitionHelper.ActionDefinition> l;
        if (!this.inited) {
            this.initialize();
        }
        if ((l = this.actionDefByLevelCode.get(lvl.getCode())) == null && lvl.eContainer() instanceof Tech) {
            this.analyzeCode((Tech)lvl.eContainer());
            l = this.actionDefByLevelCode.get(lvl.getCode());
            if (l == null) {
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<ActionDefinitionHelper.ActionDefinition> res = new ArrayList<ActionDefinitionHelper.ActionDefinition>(l);
        Collections.sort(res, new Comparator<ActionDefinitionHelper.ActionDefinition>(){

            @Override
            public int compare(ActionDefinitionHelper.ActionDefinition arg0, ActionDefinitionHelper.ActionDefinition arg1) {
                String s1 = arg0.getPaletteCategory();
                String s2 = arg1.getPaletteCategory();
                if (s1 != null && s2 != null) {
                    int k = 0;
                    k = s1.compareTo(s2);
                    if (k == 0) {
                        return arg0.getDisplayName().compareTo(arg1.getDisplayName());
                    }
                    return k;
                }
                return 0;
            }
        });
        Iterator it = res.iterator();
        while (it.hasNext()) {
            ActionDefinitionHelper.ActionDefinition ad = (ActionDefinitionHelper.ActionDefinition)it.next();
            if (!ad.isHidden()) continue;
            it.remove();
        }
        return res;
    }

    public Collection<String> getMdlinkLvlCodes(ActionCode action, Parameter p) {
        return this.paramDefLvlCodes.get(String.valueOf(action.getActionDefinition().getName()) + "/" + p.getName());
    }

    public MetaDataLink getMdLinkSettingParameter(ActionCode action, Parameter p) {
        Collection<String> l = this.getMdlinkLvlCodes(action, p);
        if (l == null) {
            new Exception(String.format(Messages.MdLinkHelper_0, action.getTechnology(), p.getName())).printStackTrace();
            return null;
        }
        for (MetaDataLink m : action.getMetaDataLink()) {
            Level level;
            if (!m.isPublishParameters() && m.isSetPublishParameters() || !(m.getTarget() instanceof MetaDataLinkCapability) || (level = (Level)((MetaDataLinkCapability)m.getTarget()).getLevelTech()) == null || !l.contains(level.getCode())) continue;
            for (MetaDataLinkType t : level.getMetaDataLinkType(action.getTechnology())) {
                for (com.stambia.tech.Parameter _p : t.getParameter()) {
                    if (!_p.getName().equals(p.getName())) continue;
                    return m;
                }
            }
            if (!action.getActionDefinition().hasParamatersWithMdLinkInitializer()) continue;
            for (ProcessToolDescriptor.ParameterDescriptor desc : action.getActionDefinition().getToolDescriptor().getParameters()) {
                if (!desc.getName().equals(p.getName()) || !desc.defineInitializer4(level.getCode())) continue;
                return m;
            }
        }
        return null;
    }

    private void analyzeCode(Tech tech) {
        this.writeLock.lock();
        try {
            String techID = null;
            if (tech.eResource() == null) {
                techID = tech.getId();
            } else {
                CacheHelper.extractFileID((String)tech.eResource().getURI().fragment());
                if (techID == null) {
                    techID = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(tech.eResource().getURI().trimFragment());
                }
            }
            ArrayList<String> lvls = new ArrayList<String>();
            for (Level l : tech.getLevel()) {
                if (l.getCode() == null) continue;
                this.graph.add(new Node(l.getCode()));
                lvls.add(l.getCode());
            }
            this.lvlCodeByTechIds.put(techID, lvls);
            for (Level l : tech.getLevel()) {
                for (String s : l.getParent()) {
                    this.graph.add(new Edge(this.graph.getNode(s), this.graph.getNode(l.getCode())));
                }
            }
            for (MetaDataLinkType t : tech.getMetaDataLinkType()) {
                HashSet<ActionDefinitionHelper.ActionDefinition> actionDefs = new HashSet<ActionDefinitionHelper.ActionDefinition>();
                block7: for (String s : t.getTechnology()) {
                    Iterator p2;
                    if (s.equals("*")) {
                        block8: for (ActionDefinitionHelper.ActionDefinition def : ActionDefinitionHelper.getAllAction()) {
                            for (Iterator p2 : t.getParameter()) {
                                if (def.getParameter(p2.getName()) == null) continue;
                                actionDefs.add(def);
                                continue block8;
                            }
                        }
                        continue;
                    }
                    ActionDefinitionHelper.ActionDefinition d = ActionDefinitionHelper.getActionDefinition((String)s);
                    if (d == null) continue;
                    p2 = t.getParameter().iterator();
                    while (p2.hasNext()) {
                        com.stambia.tech.Parameter p3 = (com.stambia.tech.Parameter)p2.next();
                        if (d.getParameter(p3.getName()) == null) continue;
                        actionDefs.add(d);
                        continue block7;
                    }
                }
                for (ActionDefinitionHelper.ActionDefinition def : ActionDefinitionHelper.getAllAction()) {
                    if (!def.hasParamatersWithMdLinkInitializer()) continue;
                    actionDefs.add(def);
                }
                if (actionDefs.isEmpty()) continue;
                for (Level l : t.getLevel()) {
                    this.store(l, actionDefs);
                }
                for (ActionDefinitionHelper.ActionDefinition def : actionDefs) {
                    for (com.stambia.tech.Parameter p : t.getParameter()) {
                        ActionDefinitionHelper.ParameterDefinition pd = def.getParameter(p.getName());
                        if (pd == null) continue;
                        Collection<String> r = this.paramDefLvlCodes.get(String.valueOf(def.getName()) + "/" + p.getName());
                        if (r == null) {
                            r = new HashSet<String>();
                            this.paramDefLvlCodes.put(String.valueOf(def.getName()) + "/" + p.getName(), r);
                        }
                        for (Level l : t.getLevel()) {
                            r.add(l.getCode());
                        }
                    }
                    for (ProcessToolDescriptor.ParameterDescriptor pd : def.getToolDescriptor().getParameters()) {
                        ActionDefinitionHelper.ParameterDefinition pDef = def.getParameter(pd.getName());
                        if (pDef == null || !pd.hasInitializer()) continue;
                        for (String l : lvls) {
                            if (!pd.defineInitializer4(l)) continue;
                            Collection<String> r = this.paramDefLvlCodes.get(String.valueOf(def.getName()) + "/" + pDef.getName());
                            if (r == null) {
                                r = new HashSet<String>();
                                this.paramDefLvlCodes.put(String.valueOf(def.getName()) + "/" + pDef.getName(), r);
                            }
                            r.add(l);
                        }
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void store(Level lvl, Set<ActionDefinitionHelper.ActionDefinition> actionDefs) {
        Collection<ActionDefinitionHelper.ActionDefinition> cc;
        Collection<ActionDefinitionHelper.ActionDefinition> c = this.actionDefByLevelCode.get(lvl.getCode());
        if (c == null) {
            c = new HashSet<ActionDefinitionHelper.ActionDefinition>();
            this.actionDefByLevelCode.put(lvl.getCode(), c);
        }
        c.addAll(actionDefs);
        for (Node n : this.graph.getDescendant(this.graph.getNode(lvl.getCode()), new HashSet<Node>())) {
            cc = this.actionDefByLevelCode.get(n.name);
            if (cc == null) {
                cc = new HashSet<ActionDefinitionHelper.ActionDefinition>();
                this.actionDefByLevelCode.put(n.name, cc);
            }
            cc.addAll(actionDefs);
        }
        for (Node n : this.graph.getAscendant(this.graph.getNode(lvl.getCode()), new HashSet<Node>())) {
            cc = this.actionDefByLevelCode.get(n.name);
            if (cc == null) continue;
            c.addAll(cc);
        }
    }

    public void freeSelection() {
        this.currentResult = null;
    }

    public void select(Level lvl) {
        this.currentResult = this.getActionDefinitionFor(lvl);
    }

    public void reset() {
        this.graph = new Graph();
        this.currentResult = null;
        this.actionDefByLevelCode.clear();
    }

    public Collection<ActionDefinitionHelper.ActionDefinition> getActionDefinitionForSelection() {
        return this.currentResult;
    }

    private void handleTechResourceChanges(URI techResourceURI) {
        try {
            Collection<String> lvls;
            this.writeLock.lock();
            String fileID = CacheHelper.extractFileID((String)techResourceURI.fragment());
            if (fileID == null) {
                fileID = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(techResourceURI.trimFragment());
            }
            if ((lvls = this.lvlCodeByTechIds.get(fileID)) != null) {
                for (String lvlCode : lvls) {
                    this.actionDefByLevelCode.remove(lvlCode);
                    ArrayList<String> keys = new ArrayList<String>();
                    for (String k : this.paramDefLvlCodes.keySet()) {
                        Collection<String> c = this.paramDefLvlCodes.get(lvlCode);
                        if (c == null || !c.contains(lvlCode)) continue;
                        keys.add(k);
                    }
                    for (String s : keys) {
                        this.paramDefLvlCodes.remove(s);
                    }
                }
            }
            this.lvlCodeByTechIds.remove(fileID);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void resourceBuildStateChanged(CacheEventResource event) {
    }

    public void resourceErrorStateChanged(CacheEventResource event) {
    }

    public boolean handleEvent(CacheEventResource event) {
        return false;
    }

    public boolean handleEvent(CacheEventURI event) {
        if (event.getModelURI() != null && "tech".equals(event.getModelURI().fileExtension())) {
            switch (event.getType()) {
                case REMOVED: 
                case SYNCHRONIZED: 
                case DUPLICATED: {
                    return true;
                }
            }
            if (event.isUnduplicated()) {
                return true;
            }
        }
        return false;
    }

    public void handleEventsTriggered() {
    }

    public void handleCacheSourceChanged(CacheEventURI event) {
        this.handleTechResourceChanges(event.getModelURI());
    }

    public void handleCacheInitialized() {
        this.initialize();
    }

    public void handleCacheInitializing() {
        this.reset();
    }

    private class Edge {
        Node parent;
        Node child;

        Edge(Node parent, Node child) {
            this.child = child;
            this.parent = parent;
        }
    }

    private class Graph {
        public List<Node> nodes = new ArrayList<Node>();
        public List<Edge> edges = new ArrayList<Edge>();

        private Graph() {
        }

        void add(Node node) {
            for (Node n : this.nodes) {
                if (!n.name.equals(node.name)) continue;
                return;
            }
            this.nodes.add(node);
        }

        void add(Edge edge) {
            for (Edge e : this.edges) {
                if (e.parent != edge.parent || e.child != edge.child) continue;
                return;
            }
            this.edges.add(edge);
        }

        Collection<Node> getDescendant(Node n, Collection<Node> toDiscard) {
            HashSet<Node> l = new HashSet<Node>();
            for (Edge e : this.edges) {
                if (e.parent != n || e.child == null || !toDiscard.add(e.child)) continue;
                l.add(e.child);
            }
            toDiscard.addAll(l);
            ArrayList<Node> toAdd = new ArrayList<Node>();
            for (Node nn : l) {
                for (Node i : this.getDescendant(nn, toDiscard)) {
                    toAdd.add(i);
                }
            }
            l.addAll(toAdd);
            return l;
        }

        Collection<Node> getAscendant(Node n, Collection<Node> toDiscard) {
            HashSet<Node> l = new HashSet<Node>();
            for (Edge e : this.edges) {
                if (e.child != n || e.parent == null || !toDiscard.add(e.parent)) continue;
                l.add(e.parent);
            }
            toDiscard.addAll(l);
            ArrayList<Node> toAdd = new ArrayList<Node>();
            for (Node nn : l) {
                for (Node i : this.getAscendant(nn, toDiscard)) {
                    toAdd.add(i);
                }
            }
            l.addAll(toAdd);
            return l;
        }

        public Node getNode(String s) {
            for (Node n : this.nodes) {
                if (!n.name.equals(s)) continue;
                return n;
            }
            return null;
        }
    }

    private class Node {
        private String name;

        public Node(String name) {
            this.name = name;
        }
    }
}

