/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste;

import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;

public class NameGenerator {
    private static final String prefix = Messages.NameGenerator_0;
    private static final String of = Messages.NameGenerator_1;
    private String name;
    private int max = -1;
    private boolean noPrefixExists = false;
    private String noPrefixedName = null;

    public NameGenerator(String name) {
        this.name = name;
        this.noPrefixedName = this.removePrefix(name);
    }

    private String removePrefix(String s) {
        if (!s.startsWith(prefix)) {
            return s;
        }
        return s.substring(s.indexOf(of) + of.length());
    }

    private int extractNumber(String s) {
        if (!s.startsWith(prefix)) {
            return 0;
        }
        int end = s.indexOf(of);
        if (end == -1) {
            return -1;
        }
        String n = s.substring(prefix.length() - 1, end);
        if (n.length() == 0) {
            return 0;
        }
        return Integer.parseInt(n.trim());
    }

    private boolean needName(String existing) {
        return this.removePrefix(this.name).trim().equals(this.removePrefix(existing).trim());
    }

    public void addName(String existing) {
        int i;
        if (this.noPrefixedName.equals(existing)) {
            this.noPrefixExists = true;
        }
        if (existing != null && this.needName(existing) && this.max < (i = this.extractNumber(existing))) {
            this.max = i;
        }
    }

    public String generate() {
        if (!this.noPrefixExists) {
            return this.noPrefixedName;
        }
        ++this.max;
        if (this.max == 0) {
            return this.name;
        }
        return String.valueOf(prefix) + this.max + of + this.removePrefix(this.name);
    }
}

