/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.multi;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.DocumentRoot;
import com.indy.gmf.proc.ProcPackage;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditorHelper;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.ui.custom.out.emf.SharingReadOnlyEditingDomainFactory;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.IEditorInput;

public class NavigationManager {
    private List<Step> currentPath = new ArrayList<Step>();
    private TransactionalEditingDomain editingDomain;
    private IEditorInput editorInput;
    private int currentIndexPosition = -1;
    private EContentAdapter actionNameChangeListener = new EContentAdapter(){
        private NotificationFilter filter = NotificationFilter.createEventTypeFilter((int)1).and(NotificationFilter.createFeatureFilter(Resource.class, (int)4));

        public void notifyChanged(Notification notification) {
            block13: {
                int index;
                block12: {
                    super.notifyChanged(notification);
                    index = -1;
                    ArrayList<URI> toClose = new ArrayList<URI>();
                    if (!this.filter.matches(notification) || !Boolean.TRUE.equals(notification.getNewValue())) break block12;
                    Resource r = (Resource)notification.getNotifier();
                    ArrayList l = new ArrayList(NavigationManager.this.currentPath);
                    for (Step s : l) {
                        try {
                            s.resolveSemantic();
                        }
                        catch (Exception ex) {
                            toClose.add(s.getEditedProcessURI());
                            continue;
                        }
                        if (s.getOriginRef() != null && s.getOriginRef().eIsProxy()) {
                            toClose.add(s.getEditedProcessURI());
                            continue;
                        }
                        ActionProcess a = s.getEditedProcess();
                        URI actionURi = a.eIsProxy() ? ((InternalEObject)a).eProxyURI() : EcoreUtil.getURI((EObject)a);
                        ++index;
                        if (a.eResource() == r || actionURi.trimFragment().equals(r.getURI())) {
                            if (a.eIsProxy()) {
                                if (notification.getNewValue() == Boolean.FALSE) {
                                    NavigationManager.this.fireActionNameChanged(index, (Action)a);
                                }
                            } else {
                                NavigationManager.this.fireActionNameChanged(index, (Action)a);
                            }
                        }
                        if ((a = s.getOriginRef()) == null) continue;
                        URI uRI = actionURi = a.eIsProxy() ? ((InternalEObject)a).eProxyURI() : EcoreUtil.getURI((EObject)a);
                        if (a.eResource() != r && !actionURi.trimFragment().equals(r.getURI())) continue;
                        if (a.eIsProxy()) {
                            if (notification.getNewValue() != Boolean.FALSE) continue;
                            NavigationManager.this.fireActionNameChanged(index, (Action)a);
                            continue;
                        }
                        NavigationManager.this.fireActionNameChanged(index, (Action)a);
                    }
                    for (URI u : toClose) {
                        MultiPageEditorHelper.closeSubActionProcessPageOrEditor(NavigationManager.this.editorInput, u);
                    }
                    break block13;
                }
                if (notification.getFeature() != ProcPackage.eINSTANCE.getAction_Name()) break block13;
                for (Step a : NavigationManager.this.currentPath) {
                    ++index;
                    if (a.getEditedProcess() == notification.getNotifier()) {
                        NavigationManager.this.fireActionNameChanged(index, (Action)a.getEditedProcess());
                    }
                    if (a.getOriginRef() != notification.getNotifier()) continue;
                    NavigationManager.this.fireActionNameChanged(index, (Action)a.getOriginRef());
                }
            }
        }
    };
    private List<INavigationListener> navigationListeners = new ArrayList<INavigationListener>();

    public Step getStep(int index) {
        if (index >= this.currentPath.size()) {
            return null;
        }
        return this.currentPath.get(index);
    }

    public int getCurrentPosition() {
        return this.currentIndexPosition;
    }

    private void fireActionNameChanged(int index, Action action) {
        for (INavigationListener l : this.navigationListeners) {
            l.handleActionChanged(index, action);
        }
    }

    public void addNavigationLister(INavigationListener listener) {
        this.navigationListeners.add(listener);
    }

    public void removeNavigationLister(INavigationListener listener) {
        this.navigationListeners.remove(listener);
    }

    private EObject findSemanticObject(URI semanticObjectURI) {
        EObject object = null;
        if (this.editingDomain != null && semanticObjectURI != null) {
            if (semanticObjectURI.fragment() == null) {
                Resource r = this.editingDomain.getResourceSet().getResource(semanticObjectURI, true);
                EObject eObject = object = r.getContents().isEmpty() ? null : (EObject)r.getContents().get(0);
                if (object instanceof DocumentRoot) {
                    object = ((DocumentRoot)object).getProcess();
                } else if (r.getContents().isEmpty()) {
                    r.unload();
                    try {
                        r.load(new HashMap());
                        EObject eObject2 = object = r.getContents().isEmpty() ? null : (EObject)r.getContents().get(0);
                        if (object instanceof DocumentRoot) {
                            object = ((DocumentRoot)object).getProcess();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Resource r;
                object = this.editingDomain.getResourceSet().getEObject(semanticObjectURI, true);
                if (object == null && (r = this.editingDomain.getResourceSet().getResource(semanticObjectURI.trimFragment(), false)) != null) {
                    if (r.isLoaded() && r.getContents().isEmpty()) {
                        r.unload();
                    }
                    String sourceId = CacheHelper.extractEltInfo((String)semanticObjectURI.fragment(), (String)"fileId");
                    URI sourceURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(sourceId);
                    object = sourceURI != null ? this.editingDomain.getResourceSet().getEObject(sourceURI.appendFragment(semanticObjectURI.fragment()), true) : this.editingDomain.getResourceSet().getEObject(semanticObjectURI, true);
                }
            }
        }
        return object;
    }

    public NavigationResult navigate(URI semanticObjectURI, URI semanticOriginReferenceURI) {
        if (this.editingDomain != null) {
            EObject semanticObject = this.findSemanticObject(semanticObjectURI);
            while (semanticObject != null && !(semanticObject instanceof ActionProcess)) {
                semanticObject = semanticObject.eContainer();
            }
            EObject semanticOriginReference = this.findSemanticObject(semanticOriginReferenceURI);
            if (semanticObject instanceof ActionProcess) {
                return this.mergeCurrentPath(new Step((ActionProcess)semanticObject, (ActionProcessRef)semanticOriginReference));
            }
            throw new RuntimeException(Messages.bind((String)Messages.NavigationManager_11, (Object)semanticObjectURI.toPlatformString(true), (Object)semanticObject));
        }
        return null;
    }

    public void setCurrentIndexPosition(int curPos) {
        this.currentIndexPosition = curPos;
        this.fireCurrentPositionChanged(this.currentIndexPosition);
    }

    private void fireCurrentPositionChanged(int newPosition) {
        for (INavigationListener l : this.navigationListeners) {
            l.handleCurrentIndexPositionChanged(newPosition);
        }
    }

    public void dispose() {
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.actionNameChangeListener);
        this.editingDomain = null;
        this.currentPath.clear();
    }

    public void initialize(TransactionalEditingDomain editingDomain, IEditorInput editorInput) {
        this.editorInput = editorInput;
        this.editingDomain = editingDomain;
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.actionNameChangeListener);
    }

    public List<Step> getStepsFrom(int start) {
        ArrayList<Step> l = new ArrayList<Step>();
        if (start < 0) {
            return l;
        }
        int i = start;
        while (i < this.currentPath.size()) {
            l.add(this.currentPath.get(i));
            ++i;
        }
        return l;
    }

    private NavigationResult mergeCurrentPath(Step step) {
        boolean isReadOnly = !this.currentPath.isEmpty();
        boolean bl = isReadOnly = isReadOnly && !this.currentPath.get(0).getEditedProcessURI().trimFragment().equals(step.getEditedProcessURI().trimFragment());
        if (!SharingReadOnlyEditingDomainFactory.getInstance().hasLock(step.getEditedProcessURI().trimFragment(), this.editingDomain.getID())) {
            boolean bl2 = isReadOnly = isReadOnly || SharingReadOnlyEditingDomainFactory.getInstance().isLockedByAnotherEditingDomain(step.getEditedProcessURI().trimFragment(), this.editingDomain.getID());
            if (!SharingReadOnlyEditingDomainFactory.getInstance().isLockedByAnotherEditingDomain(step.getEditedProcessURI().trimFragment(), this.editingDomain.getID()) && SharingReadOnlyEditingDomainFactory.getInstance().hasLock(step.getEditedProcessURI().trimFragment(), this.editingDomain.getID())) {
                isReadOnly = false;
            }
            if (!isReadOnly && !SharingReadOnlyEditingDomainFactory.getInstance().canLock(step.getEditedProcessURI().trimFragment(), this.editingDomain.getID())) {
                isReadOnly = true;
            }
        } else {
            isReadOnly = SharingReadOnlyEditingDomainFactory.getInstance().isLockedByAnotherEditingDomain(step.getEditedProcessURI().trimFragment(), this.editingDomain.getID());
        }
        if (this.currentPath.isEmpty()) {
            if (step.getEditedProcess().eContainer() instanceof Action) {
                Stack<ActionProcess> s = new Stack<ActionProcess>();
                Object p = (ActionProcess)step.getEditedProcess().eContainer();
                while (p != null) {
                    s.push((ActionProcess)p);
                    p = p.eContainer() instanceof ActionProcess ? (ActionProcess)p.eContainer() : null;
                }
                while (!s.isEmpty()) {
                    this.currentPath.add(new Step((ActionProcess)s.pop(), null));
                }
                this.currentPath.add(step);
                return new NavigationResult(NavigationType.Add, this.currentPath.size() - 1, 0, isReadOnly);
            }
            this.currentPath.add(step);
            return new NavigationResult(NavigationType.Add, this.currentPath.size() - 1, this.currentPath.size() - 1, isReadOnly);
        }
        Step currentStep = this.currentPath.get(this.currentIndexPosition);
        int index = this.getStepIndex(step);
        if (index != -1) {
            return new NavigationResult(NavigationType.Exist, index, -1, isReadOnly);
        }
        if (currentStep.isParent(step) && this.currentIndexPosition == this.currentPath.size() - 1) {
            this.currentPath.add(step);
            return new NavigationResult(NavigationType.Add, this.currentPath.size() - 1, this.currentPath.size() - 1, isReadOnly);
        }
        int i = index = this.findEmbranchment(step);
        int sz = this.currentPath.size();
        while (i < sz) {
            this.currentPath.remove(this.currentPath.size() - 1);
            ++i;
        }
        this.currentPath.add(step);
        return new NavigationResult(NavigationType.Merge, this.currentPath.size() - 1, index, isReadOnly);
    }

    private int findEmbranchment(Step step) {
        int i = this.currentPath.size() - 1;
        while (i >= 0) {
            Step s = this.currentPath.get(i);
            if (s.isParent(step)) {
                return i + 1;
            }
            --i;
        }
        return -1;
    }

    private int getStepIndex(Step step) {
        int i = 0;
        while (i < this.currentPath.size()) {
            Step s = this.currentPath.get(i);
            if (step.originRef != null) {
                if (s.originRef == step.originRef) {
                    if (s.editedProcess != step.editedProcess) {
                        try {
                            URI uri2;
                            URI uri1;
                            URI uRI = s.editedProcess == null ? null : (uri1 = s.editedProcess.eIsProxy() ? ((InternalEObject)s.editedProcess).eProxyURI() : EcoreUtil.getURI((EObject)s.editedProcess));
                            URI uRI2 = step.editedProcess == null ? null : (uri2 = step.editedProcess.eIsProxy() ? ((InternalEObject)step.editedProcess).eProxyURI() : EcoreUtil.getURI((EObject)step.editedProcess));
                            if (uri1 != null && uri2 != null && NavigationManager.equals(uri1, uri2)) {
                                return i;
                            }
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Unable to find step index", ex);
                        }
                    }
                    return i;
                }
            } else if (s.editedProcess == step.editedProcess) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean equals(URI processURI1, URI processURI2) {
        if (processURI1 == null || processURI2 == null) {
            return false;
        }
        if (processURI1.equals(processURI2)) {
            return true;
        }
        String fileID = CacheHelper.extractFileID((String)processURI1.fragment());
        String fileID2 = CacheHelper.extractFileID((String)processURI2.fragment());
        if (fileID != null && fileID2 != null && fileID.equals(fileID2)) {
            String eltID = CacheHelper.extractEltID((String)processURI1.fragment());
            String eltID2 = CacheHelper.extractEltID((String)processURI2.fragment());
            if (eltID != null && eltID2 != null && eltID.equals(eltID2)) {
                return true;
            }
        }
        return false;
    }

    public int remove(URI actionProcessUri) {
        int res;
        block8: {
            res = -1;
            int i = 0;
            while (i < this.currentPath.size()) {
                Step s = this.currentPath.get(i);
                if (NavigationManager.equals(s.getEditedProcessURI(), actionProcessUri)) {
                    res = i;
                    break;
                }
                ++i;
            }
            if (res == -1) {
                try {
                    EObject o = this.findSemanticObject(actionProcessUri);
                    if (o == null) break block8;
                    URI uri = o.eIsProxy() ? ((InternalEObject)o).eProxyURI() : EcoreUtil.getURI((EObject)o);
                    int i2 = 0;
                    while (i2 < this.currentPath.size()) {
                        Step s = this.currentPath.get(i2);
                        if (s.getEditedProcessURI().equals(uri)) {
                            res = i2;
                            break;
                        }
                        ++i2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        while (res > 0 && this.currentPath.size() > res) {
            this.removeLast();
        }
        return res;
    }

    private void removeLast() {
        this.currentPath.remove(this.currentPath.get(this.currentPath.size() - 1));
        if (this.currentIndexPosition >= this.currentPath.size()) {
            this.setCurrentIndexPosition(this.currentPath.size() - 1);
        }
    }

    public URI getCurrentUri() {
        return this.currentPath.get(this.currentPath.size() - 1).getEditedProcessURI();
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public static interface INavigationListener {
        public void handleActionChanged(int var1, Action var2);

        public void handleCurrentIndexPositionChanged(int var1);
    }

    public class NavigationResult {
        private int index = -1;
        private int mergeIndex = -1;
        private NavigationType type;
        private boolean readOnly;

        private NavigationResult(NavigationType type, int index, int mergeIndex, boolean readOnly) {
            this.type = type;
            this.index = index;
            this.mergeIndex = mergeIndex;
            NavigationManager.this.setCurrentIndexPosition(this.index);
            this.readOnly = readOnly;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public int getIndex() {
            return this.index;
        }

        public NavigationType getType() {
            return this.type;
        }

        public int getMergeIndex() {
            return this.mergeIndex;
        }
    }

    public static enum NavigationType {
        Exist,
        Insert,
        Merge,
        Add;

    }

    public class Step {
        private ActionProcess editedProcess;
        private ActionProcessRef originRef;

        Step(ActionProcess editedProcess, ActionProcessRef originRef) {
            this.editedProcess = editedProcess;
            this.originRef = originRef;
        }

        public ActionProcess getEditedProcess() {
            if (this.editedProcess != null && this.editedProcess.eIsProxy()) {
                this.editedProcess = (ActionProcess)NavigationManager.this.editingDomain.getResourceSet().getEObject(((InternalEObject)this.editedProcess).eProxyURI(), true);
            }
            return this.editedProcess;
        }

        public ActionProcessRef getOriginRef() {
            return this.originRef;
        }

        public boolean isParent(Step step) {
            if (step.getOriginRef() != null) {
                return this.getEditedProcess().getActionProcessRef().contains((Object)step.getOriginRef());
            }
            return this.getEditedProcess().getAction().contains(step.getEditedProcess());
        }

        public URI getEditedProcessURI() {
            if (this.getEditedProcess().eIsProxy()) {
                return ((InternalEObject)this.getEditedProcess()).eProxyURI();
            }
            return EcoreUtil.getURI((EObject)this.getEditedProcess());
        }

        public String getName() {
            if (this.getOriginRef() != null) {
                return this.getOriginRef().getName();
            }
            return this.getEditedProcess().getName();
        }

        public URI getOriginRefURI() {
            if (this.getOriginRef() == null) {
                return null;
            }
            if (this.getOriginRef().eIsProxy()) {
                return ((InternalEObject)this.getOriginRef()).eProxyURI();
            }
            return EcoreUtil.getURI((EObject)this.getOriginRef());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void resolveSemantic() throws Exception {
            if (this.originRef != null && this.originRef.eIsProxy()) {
                this.originRef = (ActionProcessRef)EcoreUtil.resolve((EObject)this.originRef, (ResourceSet)NavigationManager.this.getEditingDomain().getResourceSet());
                if (this.originRef == null || this.originRef.eIsProxy()) {
                    throw new Exception(Messages.NavigationManager_0);
                }
            }
            if (this.editedProcess != null && this.editedProcess.eIsProxy()) {
                this.editedProcess = (ActionProcess)EcoreUtil.resolve((EObject)this.editedProcess, (ResourceSet)NavigationManager.this.getEditingDomain().getResourceSet());
                if (this.editedProcess == null || this.editedProcess.eIsProxy()) {
                    throw new Exception(Messages.NavigationManager_1);
                }
            }
            if (this.originRef == null) return;
            EObject proxyRef = this.originRef.getTargetAsProxy();
            URI proxyURI = proxyRef.eIsProxy() ? ((InternalEObject)proxyRef).eProxyURI() : EcoreUtil.getURI((EObject)proxyRef);
            URI uri = EcoreUtil.getURI((EObject)this.editedProcess);
            String proxyID = CacheHelper.extractEltID((String)proxyURI.fragment());
            String proxyFileID = CacheHelper.extractFileID((String)proxyURI.fragment());
            String id = CacheHelper.extractEltID((String)uri.fragment());
            String fileID = CacheHelper.extractFileID((String)uri.fragment());
            if (fileID == null || proxyFileID == null) throw new Exception(Messages.NavigationManager_9);
            if (fileID.equals(proxyFileID)) {
                if (proxyID == null || id == null) throw new Exception(Messages.NavigationManager_3);
                if (proxyID.equals(id)) return;
                throw new Exception(Messages.NavigationManager_2);
            }
            if (!"map".equals(proxyURI.fileExtension())) return;
            if (!fileID.equals(String.valueOf(proxyFileID) + "-proc")) {
                throw new Exception(Messages.NavigationManager_6);
            }
            if (id.equals(String.valueOf(proxyID) + "-proc")) return;
            throw new Exception(Messages.NavigationManager_8);
        }
    }
}

