/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditorHelper;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.NavigationManager;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump.Breadcrump;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump.BreadcrumpItem;
import com.indy.gmf.proc.provider.ProcEditPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BreadCrumpViewer {
    public static BreadCrumpViewer INSTANCE = new BreadCrumpViewer();
    private Shell shell;
    private TableViewer viewer;
    private URI currentURI;
    private Breadcrump _breadcrump;
    private int _index;
    private Listener displayListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 3) {
                Point shellLocation = BreadCrumpViewer.this.shell.getLocation();
                Point shellSize = BreadCrumpViewer.this.shell.getSize();
                Point p = event.widget instanceof Control ? ((Control)event.widget).toDisplay(event.x, event.y) : new Point(event.x, event.y);
                Rectangle r = new Rectangle(shellLocation.x, shellLocation.y, shellSize.x, shellSize.y);
                if (!r.contains(p.x, p.y)) {
                    BreadCrumpViewer.this.close();
                }
            }
        }
    };

    protected void createDialog(Shell p) {
        p.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (BreadCrumpViewer.this.shell != null && !BreadCrumpViewer.this.shell.isDisposed() && BreadCrumpViewer.this.shell.isVisible()) {
                    BreadCrumpViewer.this.refreshShellLocation(BreadCrumpViewer.this._breadcrump.getItem(BreadCrumpViewer.this._index).getPopupLocation());
                }
            }

            public void controlMoved(ControlEvent e) {
                if (BreadCrumpViewer.this.shell != null && !BreadCrumpViewer.this.shell.isDisposed() && BreadCrumpViewer.this.shell.isVisible()) {
                    BreadCrumpViewer.this.refreshShellLocation(BreadCrumpViewer.this._breadcrump.getItem(BreadCrumpViewer.this._index).getPopupLocation());
                }
            }
        });
        this.shell = new Shell(p, 16400);
        this.shell.setVisible(false);
        this.shell.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer((Composite)this.shell, 512);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                EObject a = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                URI uri = BreadCrumpViewer.this.computeSelectedItemURI(a, true);
                MultiPageEditorHelper.openPageOrEditor(uri, a instanceof ActionProcessRef ? EcoreUtil.getURI((EObject)a) : null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput());
                BreadCrumpViewer.this.close();
            }
        });
        this.shell.open();
    }

    private URI computeSelectedItemURI(EObject a, boolean replaceRefByTarget) {
        URI uri;
        if (replaceRefByTarget && a instanceof ActionProcessRef) {
            a = ((ActionProcessRef)a).getTargetName();
        }
        URI uRI = uri = a.eIsProxy() ? ((InternalEObject)a).eProxyURI() : EcoreUtil.getURI((EObject)a);
        if ("map".equals(uri.fileExtension())) {
            URI u = a.eResource().getURI().trimFileExtension().trimFragment();
            Path path = new Path("");
            int i = 1;
            while (i < u.segmentCount()) {
                path = path.append(URI.decode((String)u.segment(i)));
                if (i == 1) {
                    path = path.append("indy.build");
                }
                ++i;
            }
            path = path.addFileExtension("proc");
            uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        }
        return uri;
    }

    public void show(Breadcrump breadcrump, int index) {
        NavigationManager.Step step;
        URI uri;
        if (this.shell == null || this.shell.isDisposed()) {
            this.createDialog(breadcrump.getControl().getShell());
        }
        URI uRI = uri = (step = breadcrump.getNavigationManager().getStep(index)).getOriginRef() == null ? step.getEditedProcessURI() : step.getOriginRefURI();
        if (uri.equals(this.currentURI)) {
            this.close();
            return;
        }
        this.currentURI = uri;
        ArrayList<Action> content = new ArrayList<Action>();
        ActionProcess proc = step.getEditedProcess();
        for (Action a : proc.getAction()) {
            if (a instanceof ActionProcess) {
                content.add(a);
                continue;
            }
            if (!(a instanceof ActionProcessRef)) continue;
            content.add(a);
        }
        this._breadcrump = breadcrump;
        this._index = index;
        this.viewer.setInput(content);
        this.shell.setSize(100, 100);
        if (content.isEmpty()) {
            return;
        }
        this.refreshShellLocation(breadcrump.getItem(this._index).getPopupLocation());
        this.shell.setVisible(true);
        this.shell.getDisplay().addFilter(3, this.displayListener);
    }

    private void close() {
        this.currentURI = null;
        this.shell.getDisplay().removeFilter(3, this.displayListener);
        this.shell.setVisible(false);
    }

    private void refreshShellLocation(Point itemLocation) {
        Point preferredSize = this.shell.computeSize(-1, -1);
        this.shell.setLocation(itemLocation.x, itemLocation.y);
        this.shell.setSize(preferredSize.x, Math.min(200, preferredSize.y));
    }

    private class CustomLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private CustomLabelProvider() {
        }

        public Font getFont(Object element) {
            if (BreadCrumpViewer.this._breadcrump != null) {
                URI uri = BreadCrumpViewer.this.computeSelectedItemURI((EObject)element, false);
                NavigationManager.Step step = BreadCrumpViewer.this._breadcrump.getNavigationManager().getStep(BreadCrumpViewer.this._index + 1);
                if (step != null && (step.getOriginRef() != null ? step.getOriginRefURI().equals(uri) : step.getEditedProcessURI().equals(uri))) {
                    return BreadcrumpItem.bold;
                }
            }
            return BreadcrumpItem.basique;
        }

        public String getText(Object element) {
            if (element instanceof Action) {
                return ((Action)element).getName();
            }
            if (element instanceof EObject) {
                return URI.decode((String)((EObject)element).eResource().getURI().trimFragment().trimFileExtension().lastSegment());
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ActionProcessRef) {
                element = ((ActionProcessRef)element).getTargetName();
                URI uri = null;
                uri = ((EObject)element).eIsProxy() ? ((InternalEObject)element).eProxyURI() : EcoreUtil.getURI((EObject)((EObject)element));
                if ("map".equals(uri.fileExtension())) {
                    return ExtendedImageRegistry.getInstance().getImage(ProcEditPlugin.INSTANCE.getImage("full/obj16/Map.png"));
                }
                return Breadcrump.getActionProcessImage(uri, BreadCrumpViewer.this.currentURI, BreadCrumpViewer.this._breadcrump.getNavigationManager().getStep(0).getEditedProcessURI());
            }
            if (element instanceof Action) {
                URI uri = null;
                uri = ((EObject)element).eIsProxy() ? ((InternalEObject)element).eProxyURI() : EcoreUtil.getURI((EObject)((EObject)element));
                return Breadcrump.getActionProcessImage(EcoreUtil.getURI((EObject)((Action)element)), BreadCrumpViewer.this.currentURI, BreadCrumpViewer.this._breadcrump.getNavigationManager().getStep(0).getEditedProcessURI());
            }
            boolean cfr_ignored_0 = element instanceof EObject;
            return super.getImage(element);
        }
    }
}

