/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.multi.override;

import com.indy.gmf.proc.diagram.non_rcp.custom.multi.override._MultiPageEditorActionBarContributor;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.override._MultiPageEditorSite;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.override._MultiPageSelectionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public abstract class _MultiPageEditorPart
extends EditorPart
implements IPageChangeProvider {
    private static final String COMMAND_NEXT_SUB_TAB = "org.eclipse.ui.navigate.nextSubTab";
    private static final String COMMAND_PREVIOUS_SUB_TAB = "org.eclipse.ui.navigate.previousSubTab";
    protected static final int PAGE_CONTAINER_SITE = 65535;
    private static final String TRACING_COMPONENT = "MPE";
    private INestable activeServiceLocator;
    private Composite container;
    private ArrayList nestedEditors = new ArrayList(3);
    private HashMap<IEditorPart, Control> editorsControls = new HashMap();
    private List pageSites = new ArrayList(3);
    private IServiceLocator pageContainerSite;
    private ListenerList pageChangeListeners = new ListenerList(1);
    private int currentActivePage = -1;

    protected _MultiPageEditorPart() {
    }

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        int index = this.getPageCount();
        this.addPage(index, editor, input);
        return index;
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) throws PartInitException {
        IEditorSite site = this.createSite(editor);
        editor.init(site, input);
        Composite parent2 = new Composite(this.getContainer(), this.getOrientation(editor));
        parent2.setLayout((Layout)new FillLayout());
        editor.createPartControl(parent2);
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                _MultiPageEditorPart.this.handlePropertyChange(propertyId);
            }
        });
        this.editorsControls.put(editor, (Control)parent2);
        this.nestedEditors.add(editor);
    }

    private int getOrientation(IEditorPart editor) {
        if (editor instanceof IWorkbenchPartOrientation) {
            return ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        return this.getOrientation();
    }

    private Composite createContainer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        final Composite newContainer = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        newContainer.setLayout((Layout)layout);
        newContainer.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 256: 
                    case 512: {
                        int detail = e.detail;
                        e.doit = true;
                        e.detail = 0;
                        Composite control = newContainer.getParent();
                        do {
                            if (control.traverse(detail)) {
                                return;
                            }
                            if (control.getListeners(31).length != 0) {
                                return;
                            }
                            if (!(control instanceof Shell)) continue;
                            return;
                        } while ((control = control.getParent()) != null);
                    }
                }
            }
        });
        return newContainer;
    }

    protected abstract void createPages();

    public final void createPartControl(Composite parent) {
        Composite pageContainer = this.createPageContainer(parent);
        this.container = this.createContainer(pageContainer);
        this.createPages();
        if (this.getActivePage() == -1) {
            IEditorSite serviceLocator;
            this.setActivePage(0);
            IEditorPart part = this.getEditor(0);
            if (part != null && (serviceLocator = part.getEditorSite()) instanceof INestable) {
                this.activeServiceLocator = (INestable)serviceLocator;
                this.activeServiceLocator.activate();
            }
        }
        this.initializePageSwitching();
        this.initializeSubTabSwitching();
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("com.indy.gmf.proc.diagram.non_rcp.ui.diagramContext");
        }
    }

    protected void initializePageSwitching() {
        new PageSwitcher((IWorkbenchPart)this){

            public Object[] getPages() {
                int pageCount = _MultiPageEditorPart.this.getPageCount();
                Object[] result = new Object[pageCount];
                int i = 0;
                while (i < pageCount) {
                    result[i] = new Integer(i);
                    ++i;
                }
                return result;
            }

            public String getName(Object page) {
                return _MultiPageEditorPart.this.getPageText((Integer)page);
            }

            public ImageDescriptor getImageDescriptor(Object page) {
                Image image = _MultiPageEditorPart.this.getPageImage((Integer)page);
                if (image == null) {
                    return null;
                }
                return ImageDescriptor.createFromImage((Image)image);
            }

            public void activatePage(Object page) {
                _MultiPageEditorPart.this.setActivePage((Integer)page);
            }

            public int getCurrentPageIndex() {
                return _MultiPageEditorPart.this.getActivePage();
            }
        };
    }

    private void initializeSubTabSwitching() {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        AbstractHandler nextHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                int n = _MultiPageEditorPart.this.getPageCount();
                if (n == 0) {
                    return null;
                }
                int i = _MultiPageEditorPart.this.getActivePage() + 1;
                if (i >= n) {
                    i = 0;
                }
                _MultiPageEditorPart.this.setActivePage(i);
                return null;
            }
        };
        service.activateHandler(COMMAND_NEXT_SUB_TAB, (IHandler)nextHandler);
        AbstractHandler previousHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                int n = _MultiPageEditorPart.this.getPageCount();
                if (n == 0) {
                    return null;
                }
                int i = _MultiPageEditorPart.this.getActivePage() - 1;
                if (i < 0) {
                    i = n - 1;
                }
                _MultiPageEditorPart.this.setActivePage(i);
                return null;
            }
        };
        service.activateHandler(COMMAND_PREVIOUS_SUB_TAB, (IHandler)previousHandler);
        service.activateHandler("org.eclipse.ui.navigate.backwardHistory", (IHandler)previousHandler);
        service.activateHandler("org.eclipse.ui.navigate.forwardHistory", (IHandler)nextHandler);
    }

    protected Composite createPageContainer(Composite parent) {
        return parent;
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new _MultiPageEditorSite(this, editor);
    }

    public void dispose() {
        this.pageChangeListeners.clear();
        int i = 0;
        while (i < this.nestedEditors.size()) {
            IEditorPart editor = (IEditorPart)this.nestedEditors.get(i);
            this.disposePart((IWorkbenchPart)editor);
            ++i;
        }
        this.nestedEditors.clear();
        if (this.pageContainerSite instanceof IDisposable) {
            ((IDisposable)this.pageContainerSite).dispose();
            this.pageContainerSite = null;
        }
        i = 0;
        while (i < this.pageSites.size()) {
            IServiceLocator sl = (IServiceLocator)this.pageSites.get(i);
            if (sl instanceof IDisposable) {
                ((IDisposable)sl).dispose();
            }
            ++i;
        }
        this.pageSites.clear();
        super.dispose();
    }

    protected IEditorPart getActiveEditor() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getEditor(index);
        }
        return null;
    }

    public int getActivePage() {
        if (this.container == null || this.container.isDisposed()) {
            return -1;
        }
        return this.currentActivePage;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected Control getControl(int pageIndex) {
        return this.editorsControls.get(this.getEditor(pageIndex));
    }

    protected IEditorPart getEditor(int pageIndex) {
        return (IEditorPart)this.nestedEditors.get(pageIndex);
    }

    protected final IServiceLocator getPageSite(int pageIndex) {
        if (pageIndex == 65535) {
            return this.getPageContainerSite();
        }
        return ((IEditorPart)this.nestedEditors.get(pageIndex)).getSite();
    }

    void close() {
        PartSite partSite = (PartSite)this.getSite();
        MPart model = partSite.getModel();
        Widget widget = (Widget)model.getWidget();
        if (widget != null && !widget.isDisposed()) {
            this.getSite().getPage().closeEditor((IEditorPart)this, true);
        }
    }

    private IServiceLocator getPageContainerSite() {
        if (this.pageContainerSite == null) {
            IServiceLocatorCreator slc = (IServiceLocatorCreator)this.getSite().getService(IServiceLocatorCreator.class);
            this.pageContainerSite = slc.createServiceLocator((IServiceLocator)this.getSite(), null, new IDisposable(){

                public void dispose() {
                    _MultiPageEditorPart.this.close();
                }
            });
        }
        return this.pageContainerSite;
    }

    protected int getPageCount() {
        return this.nestedEditors.size();
    }

    protected Image getPageImage(int pageIndex) {
        return this.getEditor(pageIndex).getTitleImage();
    }

    protected String getPageText(int pageIndex) {
        return this.getEditor(pageIndex).getTitle();
    }

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new _MultiPageSelectionProvider(this));
    }

    public boolean isDirty() {
        for (IEditorPart editor : this.nestedEditors) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void pageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        this.deactivateSite(false, false);
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        if (partService.getActivePart() == this) {
            this.setFocus();
        }
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof _MultiPageEditorActionBarContributor) {
            ((_MultiPageEditorActionBarContributor)contributor).setActivePage(activeEditor);
        }
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            ISelectionProvider outerProvider = this.getSite().getSelectionProvider();
            if (outerProvider instanceof _MultiPageSelectionProvider) {
                SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
                _MultiPageSelectionProvider provider = (_MultiPageSelectionProvider)outerProvider;
                provider.fireSelectionChanged(event);
                provider.firePostSelectionChanged(event);
            } else if (Policy.DEBUG_MPE) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("MultiPageEditorPart " + this.getTitle() + " did not propogate selection for " + activeEditor.getTitle()));
            }
        }
        this.activateSite();
        Object selectedPage = this.getSelectedPage();
        if (selectedPage != null) {
            this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, selectedPage));
        }
    }

    protected final void deactivateSite(boolean immediate, boolean containerSiteActive) {
        IServiceLocator containerSite;
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        int pageIndex = this.getActivePage();
        IKeyBindingService service = this.getSite().getKeyBindingService();
        if (pageIndex < 0 || pageIndex >= this.getPageCount() || immediate) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorPart.deactivateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead."));
            }
        }
        if (containerSiteActive && (containerSite = this.getPageContainerSite()) instanceof INestable) {
            this.activeServiceLocator = (INestable)containerSite;
            this.activeServiceLocator.activate();
        }
    }

    protected final void activateSite() {
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        IKeyBindingService service = this.getSite().getKeyBindingService();
        int pageIndex = this.getActivePage();
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorPart.activateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead."));
            }
            IEditorSite serviceLocator = editor.getEditorSite();
            if (serviceLocator instanceof INestable) {
                this.activeServiceLocator = (INestable)serviceLocator;
                this.activeServiceLocator.activate();
            }
        }
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                IWorkbenchPartSite partSite = part.getSite();
                part.dispose();
                if (partSite instanceof _MultiPageEditorSite) {
                    ((_MultiPageEditorSite)partSite).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void removePage(int pageIndex) {
        Control pageControl;
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        IEditorPart editor = this.getEditor(pageIndex);
        IWorkbenchPartSite pageLocator = this.getEditor(pageIndex).getSite();
        if (this.getActivePage() == pageIndex) {
            this.setActivePage(pageIndex - 1);
        }
        if ((pageControl = this.editorsControls.get(editor)) != null && !pageControl.isDisposed()) {
            pageControl.dispose();
        }
        this.editorsControls.remove(editor);
        if (editor != null) {
            this.nestedEditors.remove(editor);
            this.disposePart((IWorkbenchPart)editor);
        }
        if (pageLocator != null) {
            this.pageSites.remove(pageLocator);
            if (pageLocator instanceof IDisposable) {
                ((IDisposable)pageLocator).dispose();
            }
        }
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.currentActivePage = pageIndex;
        ((StackLayout)this.container.getLayout()).topControl = this.getControl(pageIndex);
        this.container.layout(true);
        this.pageChange(pageIndex);
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            editor.setFocus();
        } else {
            Control control = this.getControl(pageIndex);
            if (control != null) {
                control.setFocus();
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        IEditorPart innerEditor;
        Object result = super.getAdapter(adapter);
        if (result == null && Display.getCurrent() != null && (innerEditor = this.getActiveEditor()) != null && innerEditor != this) {
            result = Adapters.adapt((Object)innerEditor, adapter);
        }
        return (T)result;
    }

    public final IEditorPart[] findEditors(IEditorInput input) {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>();
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            IEditorPart editor = this.getEditor(i);
            if (editor != null && editor.getEditorInput() != null && editor.getEditorInput().equals(input)) {
                result.add(editor);
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public final void setActiveEditor(IEditorPart editorPart) {
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            IEditorPart editor = this.getEditor(i);
            if (editor == editorPart) {
                this.setActivePage(i);
                break;
            }
            ++i;
        }
    }

    public Object getSelectedPage() {
        int index = this.getActivePage();
        if (index == -1) {
            return null;
        }
        IEditorPart editor = this.getEditor(index);
        if (editor != null) {
            return editor;
        }
        return this.getControl(index);
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.remove((Object)listener);
    }

    private void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.pageChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }
}

