/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.multi.search;

import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.Common;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.SubActionProcess;
import com.indy.gmf.proc.XslVariable;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditor;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditorHelper;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.search.AbstractSearchBar;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SearchBar
extends AbstractSearchBar {
    public static Image IMG_SEARCH = null;
    public static ImageDescriptor DESC_SEARCH = null;
    private Mode mode = Mode.NAME;
    private ViewerFilter filter = new ViewerFilter(){

        private boolean check4Name(Object element) {
            EObject item = (EObject)element;
            String s = ((Common)item).getFullPath().toLowerCase();
            String t = SearchBar.this.getFilterText().toLowerCase();
            t = "(?s).*" + t.replace("*", ".*") + ".*";
            try {
                return s.matches(t);
            }
            catch (PatternSyntaxException ex) {
                return false;
            }
        }

        private boolean check4Code(Object element) {
            String t = SearchBar.this.getFilterText().toLowerCase();
            EObject o = (EObject)element;
            if (o instanceof ActionCode && ((ActionCode)o).getCode() != null && ((ActionCode)o).getCode().toLowerCase() != null && ((ActionCode)o).getCode().toLowerCase().contains(t)) {
                return true;
            }
            if (o instanceof XslVariable && ((XslVariable)o).getCode() != null) {
                return ((XslVariable)o).getCode().toLowerCase().contains(t);
            }
            if (o instanceof Parameter) {
                if (((Parameter)o).getValue() == null) {
                    return t.trim().equals("null");
                }
                return ((Parameter)o).getValue().toLowerCase().contains(t);
            }
            return false;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            switch (SearchBar.this.mode) {
                case NAME: {
                    return this.check4Name(element);
                }
                case CODE: {
                    return this.check4Code(element);
                }
            }
            return true;
        }
    };

    public SearchBar(URIEditorInput editorInput) {
        super(editorInput, "com.indy.gmf.process.diagram.non_rcp.viewerContentBinding1", new String[]{"com.indy.gmf.process.diagram.non_rcp.searchProcessContent"});
    }

    protected void createSearchModeComposite(Composite modeComposite) {
        final FormToolkit tk = new FormToolkit(modeComposite.getDisplay());
        modeComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                tk.dispose();
            }
        });
        final Button btName = new Button(modeComposite, 16);
        btName.setEnabled(false);
        btName.setSelection(true);
        btName.setLayoutData((Object)new GridData());
        Hyperlink hName = tk.createHyperlink(modeComposite, Messages.SearchBar_7, 0);
        hName.setLayoutData((Object)new GridData(4, 2, false, false));
        final Button btCode = new Button(modeComposite, 16);
        btCode.setEnabled(false);
        btCode.setLayoutData((Object)new GridData());
        Hyperlink hCode = tk.createHyperlink(modeComposite, Messages.SearchBar_8, 0);
        hCode.setLayoutData((Object)new GridData(4, 2, false, false));
        hName.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                btName.setSelection(true);
                btCode.setSelection(false);
                SearchBar.this.mode = Mode.NAME;
                SearchBar.this.refreshViewer();
            }
        });
        hCode.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                btCode.setSelection(true);
                btName.setSelection(false);
                SearchBar.this.mode = Mode.CODE;
                SearchBar.this.refreshViewer();
            }
        });
    }

    protected ViewerFilter createViewerFilter() {
        return this.filter;
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        EObject item = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
        URI u = item.eIsProxy() ? ((InternalEObject)item).eProxyURI() : EcoreUtil.getURI((EObject)item);
        List l = ((MultiPageEditor)editor).getDiagramGraphicalViewer().findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)item), IGraphicalEditPart.class);
        EditPart candidate = null;
        for (Object o : l) {
            if (o instanceof ShapeNodeEditPart) {
                candidate = (EditPart)o;
                break;
            }
            if (!(((EditPart)o).getParent() instanceof CompartmentEditPart)) continue;
            candidate = (EditPart)o;
        }
        if (candidate != null) {
            StructuredSelection s = new StructuredSelection(candidate);
            ((MultiPageEditor)editor).getDiagramGraphicalViewer().setSelection((ISelection)s);
            ((MultiPageEditor)editor).getDiagramGraphicalViewer().reveal(candidate);
            IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ed.getSite().getSelectionProvider().setSelection((ISelection)s);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ed);
        }
    }

    public void init(Object input) {
        this.getViewer().setInput(input);
    }

    protected void customizeViewer() {
        super.customizeViewer();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EObject o = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                URI targetURI = null;
                URI refOriginURI = null;
                if (o instanceof ActionProcessRef) {
                    EObject _t = ((ActionProcessRef)o).getTargetAsProxy();
                    URI u = _t.eIsProxy() ? ((InternalEObject)_t).eProxyURI() : EcoreUtil.getURI((EObject)_t);
                    URI uRI = refOriginURI = o.eIsProxy() ? ((InternalEObject)o).eProxyURI() : EcoreUtil.getURI((EObject)o);
                    if ("map".equals(u.fileExtension())) {
                        Path path = new Path("");
                        u = u.trimFileExtension().trimFragment();
                        int i = 1;
                        while (i < u.segmentCount()) {
                            path = path.append(URI.decode((String)u.segment(i)));
                            if (i == 1) {
                                path = path.append("indy.build");
                            }
                            ++i;
                        }
                        URI builtMappingProcessUri = URI.createPlatformResourceURI((String)(path = path.addFileExtension("proc")).toString(), (boolean)true);
                        IFile f = Util.convertEMFURIToFile((URI)builtMappingProcessUri);
                        if (f != null && f.exists()) {
                            targetURI = builtMappingProcessUri;
                        }
                    } else {
                        targetURI = u;
                    }
                } else if (o instanceof SubActionProcess) {
                    URI uRI = targetURI = o.eIsProxy() ? ((InternalEObject)o).eProxyURI() : EcoreUtil.getURI((EObject)o);
                }
                if (targetURI != null) {
                    MultiPageEditorHelper.openPageOrEditor(targetURI, refOriginURI, editor.getEditorInput());
                }
            }
        });
    }

    private static enum Mode {
        NAME,
        CODE;

    }
}

