/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.refactor;

import com.indy.emf.uri.navigator.duplicated.LevelIconMdFileAdapterFactory;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.diagram.non_rcp.custom.refactor.ProcUsageReplacer;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcDomainNavigatorContentProvider;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcDomainNavigatorItem;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcDomainNavigatorLabelProvider;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.common.TextFilter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ReplaceActionProcessWizard
extends Wizard {
    static Image procImage = ExtendedImageRegistry.getInstance().getImage((Object)URI.createURI((String)"platform:/plugin/com.indy.gmf.process.diagram.non_rcp/icons/obj16/ProcDiagramFile.png"));
    private int filterMode = 30;
    private TargetSelectionPage selectionPage;
    private ActionProcess refactoredProcess;
    private Set<IFile> selectedTarget = new HashSet<IFile>();
    private URI replacementURI;

    public void addPages() {
        this.selectionPage = new TargetSelectionPage(Messages.ReplaceActionProcessWizard_19);
        this.addPage((IWizardPage)this.selectionPage);
        this.addPage((IWizardPage)new ReplacementPage("target"));
    }

    public boolean performFinish() {
        ProcUsageReplacer r = new ProcUsageReplacer(this.selectedTarget, EcoreUtil.getURI((EObject)this.refactoredProcess), this.replacementURI);
        try {
            final Map<IFile, ByteArrayOutputStream> res = r.replace();
            AbstractOperation op = new AbstractOperation(""){
                Set<IFile> modifiedFiles;
                {
                    super($anonymous0);
                    this.modifiedFiles = new HashSet<IFile>();
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    block21: {
                        boolean autoBuild = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
                        try {
                            if (!autoBuild) break block21;
                            IWorkspaceDescription d = ResourcesPlugin.getWorkspace().getDescription();
                            d.setAutoBuilding(false);
                            try {
                                ResourcesPlugin.getWorkspace().setDescription(d);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            this.modifiedFiles.clear();
                            monitor.beginTask("Replacing ActionProcess in usages ... ", res.size());
                            for (IFile f : res.keySet()) {
                                monitor.subTask(f.getFullPath().toString());
                                if (monitor.isCanceled()) {
                                    this.undo(monitor, info);
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                try {
                                    f.setContents((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)res.get(f)).toByteArray()), true, true, monitor);
                                    this.modifiedFiles.add(f);
                                }
                                catch (CoreException e) {
                                    this.undo(monitor, info);
                                    Status status = new Status(4, "com.indy.gmf.process.diagram.non_rcp", "Failed to refactor model " + f + ". The operation is cancelled", (Throwable)e);
                                    if (autoBuild) {
                                        IWorkspaceDescription d2 = ResourcesPlugin.getWorkspace().getDescription();
                                        d2.setAutoBuilding(true);
                                        try {
                                            ResourcesPlugin.getWorkspace().setDescription(d2);
                                        }
                                        catch (CoreException e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                    return status;
                                }
                                monitor.worked(1);
                            }
                            monitor.done();
                        }
                        finally {
                            if (autoBuild) {
                                IWorkspaceDescription d = ResourcesPlugin.getWorkspace().getDescription();
                                d.setAutoBuilding(true);
                                try {
                                    ResourcesPlugin.getWorkspace().setDescription(d);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return this.execute(monitor, info);
                }

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    WorkspaceJob job = new WorkspaceJob(new Runnable(){

                        @Override
                        public void run() {
                            IHistoryStore historyStore = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
                            for (IFile f : modifiedFiles) {
                                IPath path = f.getFullPath();
                                IFileState[] states = historyStore.getStates(path, (IProgressMonitor)new NullProgressMonitor());
                                IFileState lastState = null;
                                IFileState[] iFileStateArray = states;
                                int n = states.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileState s = iFileStateArray[n2];
                                    if (lastState == null) {
                                        lastState = s;
                                    } else if (lastState.getModificationTime() < s.getModificationTime()) {
                                        lastState = s;
                                    }
                                    ++n2;
                                }
                                try {
                                    f.setContents(lastState, 3, (IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                    job.setUser(true);
                    job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    job.schedule();
                    return new Status(0, "com.indy.gmf.process.diagram.non_rcp", Messages.ReplaceActionProcessWizard_25);
                }
            };
            op.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
            WorkspaceJob job = new WorkspaceJob(op);
            job.setUser(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void setActionProcess(ActionProcess refactoredProcess) {
        this.refactoredProcess = refactoredProcess;
    }

    static enum FilterExtention {
        TPC,
        MAP,
        PROC,
        MD;

    }

    class ReplacementPage
    extends WizardPage {
        boolean onlyTpl;
        Collection<IFile> tpls;

        protected ReplacementPage(String pageName) {
            super(pageName);
            this.onlyTpl = false;
            this.tpls = null;
        }

        public boolean isPageComplete() {
            return ReplaceActionProcessWizard.this.replacementURI != null;
        }

        public void createControl(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout());
            c.setLayoutData((Object)new GridData(1808));
            Composite cc = new Composite(c, 0);
            cc.setLayout((Layout)new GridLayout(2, false));
            cc.setLayoutData((Object)new GridData(4, 1, true, false));
            Button onlyTpl = new Button(cc, 32);
            onlyTpl.setText(Messages.ReplaceActionProcessWizard_11);
            onlyTpl.setLayoutData((Object)new GridData(1, 1, false, false));
            Text txt = new Text(cc, 2048);
            txt.setLayoutData((Object)new GridData(4, 1, true, false));
            TextFilter filterHelper = new TextFilter(false);
            filterHelper.hook(txt);
            final TreeViewer viewer = new TreeViewer(c, 68352);
            viewer.getControl().setLayoutData((Object)new GridData(1808));
            viewer.setComparator(new ViewerComparator());
            viewer.setContentProvider((IContentProvider)new ProcDomainNavigatorContentProvider(){

                @Override
                public Object[] getElements(Object inputElement) {
                    return ((Collection)inputElement).toArray(new Object[((Collection)inputElement).size()]);
                }

                @Override
                public boolean hasChildren(Object element) {
                    if (element instanceof ProcDomainNavigatorItem) {
                        ActionProcess ap = (ActionProcess)((ProcDomainNavigatorItem)((Object)element)).getAdapter(ActionProcess.class);
                        return ap != null && !ap.getAction().isEmpty();
                    }
                    return super.hasChildren(element);
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new ProcDomainNavigatorLabelProvider(){

                @Override
                public Image getImage(Object element) {
                    if (element instanceof IFile) {
                        return procImage;
                    }
                    return super.getImage(element);
                }

                @Override
                public String getText(Object element) {
                    if (element instanceof IFile) {
                        String s = "/" + ((IFile)element).getName();
                        while (element instanceof IResource) {
                            element = ((IResource)element).getParent();
                            s = "/" + ((IResource)element).getName() + s;
                            if (element instanceof IProject) break;
                        }
                        return s;
                    }
                    return super.getText(element);
                }
            });
            onlyTpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReplacementPage.this.onlyTpl = !ReplacementPage.this.onlyTpl;
                    viewer.refresh();
                }
            });
            this.setControl((Control)c);
            TextFilter textFilter = filterHelper;
            textFilter.getClass();
            filterHelper.registerFilter((StructuredViewer)viewer, new TextFilter.Filter(textFilter){

                public boolean select(Viewer v, Object parentElement, Object element) {
                    if (element instanceof IFile) {
                        if (((IFile)element).getProjectRelativePath().segment(0).equals("indy.build")) {
                            return false;
                        }
                        try {
                            IMarker[] m = ((IFile)element).findMarkers("com.stambia.resource.marker.duplicate", true, 0);
                            if (m != null && m.length > 0) {
                                return false;
                            }
                        }
                        catch (Exception m) {
                            // empty catch block
                        }
                        if (ReplacementPage.this.onlyTpl) {
                            if (ReplacementPage.this.tpls == null) {
                                ReplacementPage.this.tpls = new HashSet<IFile>();
                                for (URI u : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURI(".*\\.tpc")) {
                                    for (URI uu : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getDependancies(u)) {
                                        if (!uu.fileExtension().equals("proc")) continue;
                                        ReplacementPage.this.tpls.add(Util.convertEMFURIToFile((URI)uu));
                                    }
                                }
                            }
                            if (ReplacementPage.this.tpls.contains(element)) {
                                if (this.filterText != null) {
                                    return ((ILabelProvider)viewer.getLabelProvider()).getText(element).matches(this.filterText);
                                }
                            } else {
                                return false;
                            }
                        }
                    }
                    if (element instanceof ProcDomainNavigatorItem) {
                        return ((ProcDomainNavigatorItem)((Object)element)).getAdapter(ActionProcess.class) != null;
                    }
                    return !ReplaceActionProcessWizard.this.selectedTarget.contains(element);
                }
            });
            ArrayList<IFile> f = new ArrayList<IFile>();
            for (URI u : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURI(".*\\.proc")) {
                if (!u.isPlatformResource() || u.segment(1).equals("indy.build")) continue;
                f.add(Util.convertEMFURIToFile((URI)u));
            }
            viewer.setInput(f);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty()) {
                        ReplaceActionProcessWizard.this.replacementURI = null;
                    } else {
                        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (o instanceof ProcDomainNavigatorItem) {
                            o = ((ProcDomainNavigatorItem)((Object)o)).getEObject();
                        }
                        if (o instanceof ActionProcess) {
                            ReplaceActionProcessWizard.this.replacementURI = EcoreUtil.getURI((EObject)((ActionProcess)o));
                        } else {
                            ReplaceActionProcessWizard.this.replacementURI = null;
                        }
                    }
                    ReplacementPage.this.getContainer().updateButtons();
                }
            });
        }
    }

    public class ResourceLabelProvider
    extends LabelProvider {
        private LevelIconMdFileAdapterFactory factory = new LevelIconMdFileAdapterFactory();
        private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.factory.getAdapter(element, IWorkbenchAdapter.class);
            if (adapter == null) {
                adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(element, IWorkbenchAdapter.class);
            }
            if (adapter == null) {
                return super.getImage(element);
            }
            ImageDescriptor desc = adapter.getImageDescriptor(element);
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)desc);
        }

        public String getText(Object element) {
            String label = "/" + ((IResource)element).getName();
            while (element instanceof IResource) {
                if (element instanceof IProject) break;
                element = ((IResource)element).getParent();
                label = "/" + ((IResource)element).getName() + label;
            }
            return label;
        }
    }

    class TargetSelectionPage
    extends WizardPage {
        protected TargetSelectionPage(String pageName) {
            super(pageName);
            this.setTitle(Messages.ReplaceActionProcessWizard_2);
            this.setDescription(Messages.ReplaceActionProcessWizard_3);
        }

        public boolean isPageComplete() {
            return !ReplaceActionProcessWizard.this.selectedTarget.isEmpty();
        }

        public void createControl(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(2, true));
            ToolBar filterBar = new ToolBar(main, 0x800000);
            filterBar.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            Composite searchC = new Composite(main, 0);
            GridLayout gl = null;
            gl = new GridLayout();
            searchC.setLayout((Layout)gl);
            searchC.setLayoutData((Object)new GridData(4, 4, true, true));
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            Text filterTxt = new Text(searchC, 2048);
            filterTxt.setLayoutData((Object)new GridData(4, 1, true, false));
            TextFilter filterHelper = new TextFilter(false);
            filterHelper.hook(filterTxt);
            final TableViewer viewer = new TableViewer(searchC, 68354);
            viewer.getControl().setLayoutData((Object)new GridData(1808));
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            TextFilter textFilter = filterHelper;
            textFilter.getClass();
            filterHelper.registerFilter((StructuredViewer)viewer, new TextFilter.Filter(textFilter){

                public boolean select(Viewer v, Object parentElement, Object element) {
                    boolean b;
                    boolean bl = b = !ReplaceActionProcessWizard.this.selectedTarget.contains(element);
                    if (!b) {
                        return false;
                    }
                    b = false;
                    String ext = ((IFile)element).getFileExtension();
                    if (ReplaceActionProcessWizard.this.filterMode != 0) {
                        b = false;
                        if ((ReplaceActionProcessWizard.this.filterMode & 2) != 0) {
                            b |= ext.equals("tpc");
                        }
                        if ((ReplaceActionProcessWizard.this.filterMode & 4) != 0) {
                            b |= ext.equals("map");
                        }
                        if ((ReplaceActionProcessWizard.this.filterMode & 8) != 0) {
                            b |= ext.equals("proc");
                        }
                        if ((ReplaceActionProcessWizard.this.filterMode & 0x10) != 0) {
                            b |= ext.equals("md");
                        }
                    }
                    if (b && this.filterText != null) {
                        b = ((ILabelProvider)viewer.getLabelProvider()).getText(element).matches(this.filterText);
                    }
                    return b;
                }
            });
            FilterExtention[] filterExtentionArray = FilterExtention.values();
            int n = filterExtentionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FilterExtention f = filterExtentionArray[n2];
                ToolItem it = new ToolItem(filterBar, 32);
                it.setText(f.name());
                it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem it = (ToolItem)e.widget;
                        ReplaceActionProcessWizard.this.filterMode = 0;
                        int i = 0;
                        while (i < it.getParent().getItemCount()) {
                            if (it.getParent().getItem(i).getSelection()) {
                                ReplaceActionProcessWizard replaceActionProcessWizard = ReplaceActionProcessWizard.this;
                                replaceActionProcessWizard.filterMode = replaceActionProcessWizard.filterMode | 1 << i + 1;
                            }
                            ++i;
                        }
                        viewer.refresh();
                    }
                });
                it.setSelection(true);
                ++n2;
            }
            final TableViewer selectionViewer = new TableViewer(main, 68354);
            selectionViewer.getControl().setLayoutData((Object)new GridData(1808));
            selectionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            selectionViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            selectionViewer.setInput((Object)ReplaceActionProcessWizard.this.selectedTarget);
            selectionViewer.setComparator(new ViewerComparator());
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    List c = null;
                    c = ((IStructuredSelection)viewer.getSelection()).toList();
                    ReplaceActionProcessWizard.this.selectedTarget.addAll(c);
                    viewer.refresh();
                    viewer.setSelection((ISelection)new StructuredSelection((Object)c));
                    selectionViewer.refresh();
                    TargetSelectionPage.this.getContainer().updateButtons();
                }
            });
            selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    List c = null;
                    c = ((IStructuredSelection)selectionViewer.getSelection()).toList();
                    ReplaceActionProcessWizard.this.selectedTarget.removeAll(c);
                    selectionViewer.refresh();
                    selectionViewer.setSelection((ISelection)new StructuredSelection((Object)c));
                    viewer.refresh();
                    TargetSelectionPage.this.getContainer().updateButtons();
                }
            });
            this.setControl((Control)main);
            HashSet<URI> resourceURI = new HashSet<URI>();
            ArrayList<IFile> files = new ArrayList<IFile>();
            for (URI u : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsageElements(EcoreUtil.getURI((EObject)ReplaceActionProcessWizard.this.refactoredProcess))) {
                URI _u = u.trimFragment();
                if (!resourceURI.add(_u)) continue;
                IFile f = Util.convertEMFURIToFile((URI)_u);
                try {
                    IMarker[] m = f.findMarkers("com.stambia.resource.marker.duplicate", true, 0);
                    if (m != null && m.length > 0) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                files.add(Util.convertEMFURIToFile((URI)_u));
            }
            viewer.setInput(files);
        }
    }

    public static class WorkspaceJob
    extends Job {
        AbstractOperation op;
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        Runnable runnable;

        public WorkspaceJob(Runnable runnable) {
            super("Undoing refactor ActionProcess Usages");
            this.runnable = runnable;
        }

        public WorkspaceJob(AbstractOperation op) {
            super("Refactor ActionProcess Usages");
            this.op = op;
        }

        public final IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            block9: {
                monitor = Policy.monitorFor((IProgressMonitor)monitor);
                int depth = -1;
                try {
                    this.workspace.prepareOperation(null, monitor);
                    this.workspace.beginOperation(true);
                    depth = this.workspace.getWorkManager().beginUnprotected();
                    iStatus = this.runInWorkspace(monitor);
                    if (depth < 0) break block9;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus2;
                    block10: {
                        try {
                            this.workspace.getWorkManager().operationCanceled();
                            iStatus2 = Status.CANCEL_STATUS;
                            if (depth < 0) break block10;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (depth >= 0) {
                                    this.workspace.getWorkManager().endUnprotected(depth);
                                }
                                this.workspace.endOperation(null, false);
                                throw throwable;
                            }
                            catch (CoreException e2) {
                                return e2.getStatus();
                            }
                        }
                        this.workspace.getWorkManager().endUnprotected(depth);
                    }
                    this.workspace.endOperation(null, false);
                    return iStatus2;
                }
                this.workspace.getWorkManager().endUnprotected(depth);
            }
            this.workspace.endOperation(null, false);
            return iStatus;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IStatus st;
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            if (this.op != null) {
                try {
                    st = operationHistory.execute((IUndoableOperation)this.op, monitor, null);
                }
                catch (Throwable e) {
                    st = new Status(4, "com.indy.gmf.process.diagram.non_rcp", "Refactoring failed : " + e.getMessage(), e);
                    e.printStackTrace();
                }
            } else {
                this.runnable.run();
                st = Status.OK_STATUS;
            }
            return st;
        }
    }
}

