/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.navigator;

import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcAbstractNavigatorItem;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcNavigatorGroup;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcNavigatorItem;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcVisualIDRegistry;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ProcNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public ProcNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (ProcNavigatorContentProvider.this.myViewer != null) {
                    ProcNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : ProcNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ProcNavigatorContentProvider.this.myViewer != null) {
                    ProcNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ProcNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : ProcNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ProcNavigatorContentProvider.this.myViewer != null) {
                    ProcNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ProcNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : ProcNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ProcNavigatorContentProvider.this.myViewer != null) {
                    ProcNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ProcNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Proc"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof ProcNavigatorGroup) {
            ProcNavigatorGroup group = (ProcNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof ProcNavigatorItem) {
            ProcNavigatorItem navigatorItem = (ProcNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (ProcVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                ArrayList<ProcNavigatorGroup> result = new ArrayList<ProcNavigatorGroup>();
                ProcNavigatorGroup links = new ProcNavigatorGroup(Messages.NavigatorGroupName_ActionProcess_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 2001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 2003);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 2004);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 2005);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 2006);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 2007);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 4001);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 4002);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 2001: {
                ArrayList<ProcNavigatorGroup> result = new ArrayList<ProcNavigatorGroup>();
                ProcNavigatorGroup incominglinks = new ProcNavigatorGroup(Messages.NavigatorGroupName_ActionCode_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                ProcNavigatorGroup outgoinglinks = new ProcNavigatorGroup(Messages.NavigatorGroupName_ActionCode_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7001);
                connectedViews = this.getChildrenByType(connectedViews, 3001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7002);
                connectedViews = this.getChildrenByType(connectedViews, 3002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4001);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2003: {
                ArrayList<ProcNavigatorGroup> result = new ArrayList<ProcNavigatorGroup>();
                ProcNavigatorGroup incominglinks = new ProcNavigatorGroup(Messages.NavigatorGroupName_ActionProcessRef_2003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                ProcNavigatorGroup outgoinglinks = new ProcNavigatorGroup(Messages.NavigatorGroupName_ActionProcessRef_2003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7003);
                connectedViews = this.getChildrenByType(connectedViews, 3003);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7004);
                connectedViews = this.getChildrenByType(connectedViews, 3004);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4001);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2004: {
                ArrayList<ProcNavigatorGroup> result = new ArrayList<ProcNavigatorGroup>();
                ProcNavigatorGroup incominglinks = new ProcNavigatorGroup(Messages.NavigatorGroupName_SubActionProcess_2004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                ProcNavigatorGroup outgoinglinks = new ProcNavigatorGroup(Messages.NavigatorGroupName_SubActionProcess_2004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7005);
                connectedViews = this.getChildrenByType(connectedViews, 3005);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7006);
                connectedViews = this.getChildrenByType(connectedViews, 3006);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4001);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4001: {
                ArrayList<ProcNavigatorGroup> result = new ArrayList<ProcNavigatorGroup>();
                ProcNavigatorGroup target = new ProcNavigatorGroup(Messages.NavigatorGroupName_Link_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ProcNavigatorGroup source = new ProcNavigatorGroup(Messages.NavigatorGroupName_Link_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2003);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2004);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2001);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2003);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2004);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4002: {
                ArrayList<ProcNavigatorGroup> result = new ArrayList<ProcNavigatorGroup>();
                ProcNavigatorGroup target = new ProcNavigatorGroup(Messages.NavigatorGroupName_BindLink_4002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ProcNavigatorGroup source = new ProcNavigatorGroup(Messages.NavigatorGroupName_BindLink_4002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2003);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2004);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2001);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2003);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2004);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = ProcVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = ProcVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ProcVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ProcVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ProcVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, int visualID) {
        ArrayList result = new ArrayList();
        String type = ProcVisualIDRegistry.getType(visualID);
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Proc".equals(ProcVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<ProcNavigatorItem> result = new ArrayList<ProcNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new ProcNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof ProcAbstractNavigatorItem) {
            ProcAbstractNavigatorItem abstractNavigatorItem = (ProcAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

