/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.shell.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=upgradeMapping"}, service={Command.class})
public class UpgradeMappingCommand
implements Command {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @ShellCommandParameter(commutator="trace")
    private boolean trace;
    IModelUpgrader mapUgrapder;
    @Reference
    private IWorkspace wksp;

    @Reference(policy=ReferencePolicy.DYNAMIC, target="(type=map)")
    public void bind(IModelUpgrader mapUgrapder) {
        this.mapUgrapder = mapUgrapder;
    }

    public void unbind(IModelUpgrader mapUgrapder) {
        this.mapUgrapder = mapUgrapder;
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        final PrintWriter writer = new PrintWriter(out, true);
        try {
            this.parseLine(line.trim().substring(this.getName().length()));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("ERROR - Command Parsing - " + ex.getMessage());
            return;
        }
        boolean autobuildEnabled = this.wksp.getDescription().isAutoBuilding();
        if (autobuildEnabled) {
            IWorkspaceDescription description = this.wksp.getDescription();
            description.setAutoBuilding(false);
            try {
                this.wksp.setDescription(description);
            }
            catch (Exception ex) {
                ex.printStackTrace(err);
                writer.println("ERROR - Failed to disable autoBuild - " + ex.getMessage());
                return;
            }
        }
        WorkspaceJob job = new WorkspaceJob("Updating Mappings"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    Visitor v = new Visitor();
                    UpgradeMappingCommand.this.wksp.getRoot().accept((IResourceVisitor)v);
                    UpgradeMappingCommand.this.mapUgrapder.upgradeModels(v.mappingFiles, null, writer, UpgradeMappingCommand.this.trace);
                }
                catch (Exception ex) {
                    return new Status(4, "com.indy.gmf.map", "Failed ", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this.wksp.getRoot());
        job.schedule();
        try {
            job.join();
            IStatus s = job.getResult();
            if (!s.isOK()) {
                s.getException().printStackTrace(err);
                writer.println("ERROR - Failed to upgrade mappings - " + s.getException().getMessage());
            } else {
                writer.println("SUCCESS - Mapping prepared for indexations");
            }
        }
        catch (InterruptedException ex) {
            this.logger.debug("interrupted", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        if (autobuildEnabled) {
            IWorkspaceDescription description = this.wksp.getDescription();
            description.setAutoBuilding(true);
            try {
                this.wksp.setDescription(description);
            }
            catch (Exception ex) {
                ex.printStackTrace(err);
                writer.println("ERROR - Failed to enable autoBuild - " + ex.getMessage());
                return;
            }
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join(ICacheService.class, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            this.logger.warn("Canceled", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.debug("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        return "upgradeMapping";
    }

    public String getShortDescription() {
        return "force save Mapping [usefull to update a Mapping from older versions to add hints for mapping coming from migration tools to improve indexation]";
    }

    public String getUsage() {
        return "upgradeMapping";
    }

    public void upgradeMapping(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    private class Visitor
    implements IResourceVisitor {
        Set<URI> mappingFiles = new HashSet<URI>();

        Visitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 4) {
                if (!resource.getProject().exists() || !resource.getProject().isOpen()) {
                    return false;
                }
            } else if (resource.getType() == 2) {
                if (resource.getName().equals("indy.build") || resource.getName().equals("indy.diagram")) {
                    return false;
                }
            } else if (resource.getType() == 1 && "map".equals(resource.getFileExtension())) {
                try {
                    this.mappingFiles.add(URIUtils.convertIPathToEMFURI2((IPath)resource.getFullPath()));
                }
                catch (Exception ex) {
                    throw new CoreException((IStatus)new Status(4, "com.indy.gmf.map", "Failed to save resource " + resource.getFullPath(), (Throwable)ex));
                }
            }
            return true;
        }
    }
}

