/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.ui.build.Messages;
import com.indy.ui.build.internal.ExecutionInterrupter;
import com.indy.ui.build.internal.SynchronizerJobListener;
import com.indy.ui.build.internal.UILoggingConfiguration;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.generation.ExecuteAnt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IGenerationService.ITaskSynchronizer.class}, scope=ServiceScope.SINGLETON)
public class AntTaskSynchronizer
implements ISchedulingRule,
IGenerationService.ITaskSynchronizer {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private Job currentJob = null;
    private List<Job> queue = Collections.synchronizedList(new ArrayList());

    public synchronized void startJob(Job job) {
        this.currentJob = job;
    }

    public synchronized void stopJob(Job job) {
        if (this.currentJob == job) {
            this.currentJob = null;
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule == this) {
            return rule == this;
        }
        return false;
    }

    public synchronized boolean isBusy() {
        return this.currentJob != null || !this.queue.isEmpty();
    }

    public <T> void executeTask(String actionType, URI modelURI, IGenerationService.EnvironmentInitializer initializer, IGenerationService.ITaskDoneHandler<T> handler) {
        AntJob job = new AntJob(modelURI, actionType, initializer, new UILoggingConfiguration(actionType));
        job.setRule(this);
        job.setUser(true);
        SynchronizerJobListener<T> listener = new SynchronizerJobListener<T>(job, actionType, handler);
        job.addJobChangeListener(listener);
        job.schedule();
        if ("workspace.liteTransfo".equals(actionType)) {
            try {
                job.join();
                while (!listener.isDone()) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("interrupted", (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    class AntJob
    extends Job {
        ExecuteAnt ant;
        String target;
        IGenerationService.LoggingConfiguration<Project> conf;
        IGenerationService.EnvironmentInitializer initializer;

        public AntJob(URI modelURI, String target, IGenerationService.EnvironmentInitializer initializer, IGenerationService.LoggingConfiguration<Project> conf) {
            super(Messages.ExecuteAnt_53);
            try {
                this.ant = new ExecuteAnt(modelURI);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.conf = conf;
            this.target = target;
            this.initializer = initializer;
        }

        Map<String, Object> getAntProperties() {
            return this.ant.getProjectProperties();
        }

        public boolean belongsTo(Object family) {
            return family == IGenerationService.ITaskSynchronizer.class;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            }
            catch (Exception e1) {
                AntTaskSynchronizer.this.logger.warn("unexpected", (Throwable)e1);
            }
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
            }
            catch (Exception e1) {
                AntTaskSynchronizer.this.logger.warn("unexpected", (Throwable)e1);
            }
            IStatus status = null;
            try {
                AntTaskSynchronizer.this.startJob(this);
                this.ant.registerListener((BuildListener)new ExecutionInterrupter(monitor));
                status = this.ant.run(this.target, this.initializer, this.conf);
            }
            finally {
                AntTaskSynchronizer.this.stopJob(this);
            }
            return status;
        }
    }
}

