/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.ui.build.Messages;
import java.io.IOException;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class TimingListener
implements BuildListener {
    MessageConsoleStream mcs = null;
    MessageConsole console;
    private long startBuildTime = -1L;
    private long startTargetTime = -1L;

    public TimingListener(MessageConsole console) {
        this.console = console;
    }

    private void writeTiming(String timing) {
        if (this.mcs != null && !this.mcs.isClosed()) {
            try {
                this.mcs.write(timing);
                this.mcs.write("\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void buildFinished(BuildEvent event) {
        this.writeTiming(String.valueOf(Messages.ExecuteAnt_1) + this.getTimeSince(this.startBuildTime));
        this.startBuildTime = -1L;
        if (this.mcs != null && !this.mcs.isClosed()) {
            try {
                this.mcs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getTimeSince(long start) {
        return "" + (new Date().getTime() - start);
    }

    public void buildStarted(BuildEvent event) {
        this.startBuildTime = new Date().getTime();
        if (this.console != null) {
            this.mcs = this.console.newMessageStream();
            this.writeTiming("-------------");
        }
    }

    public void messageLogged(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
        this.writeTiming(String.valueOf(Messages.ExecuteAnt_4) + event.getTarget() + "=" + this.getTimeSince(this.startTargetTime));
        this.startTargetTime = -1L;
    }

    public void targetStarted(BuildEvent event) {
        this.startTargetTime = new Date().getTime();
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }
}

