/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.ui.build.Activator;
import com.indy.ui.build.Messages;
import com.indy.ui.build.internal.BuildUtil;
import com.indy.ui.build.internal.MessageConsoleRunnable;
import com.indy.ui.build.internal.TimingListener;
import com.indy.xsl.IndyMessageEmitter;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.console.MessageConsole;

public class UILoggingConfiguration
implements IGenerationService.LoggingConfiguration<Project> {
    private OutputStream outputStream;
    private int antLogLevel;
    private TimingListener timingLogger;

    UILoggingConfiguration(String actionType) {
        MessageConsole messageConsole = BuildUtil.findConsole(Messages.ExecuteAnt_55);
        if (IndyMessageEmitter.writer != null) {
            try {
                IndyMessageEmitter.writer.close();
            }
            catch (IOException e) {
                Activator.getDefault().getLog().error(String.format("Failed to close console %s writer", Messages.ExecuteAnt_55), (Throwable)e);
            }
        }
        IndyMessageEmitter.writer = new OutputStreamWriter((OutputStream)messageConsole.newOutputStream());
        MessageConsole generationConsole = BuildUtil.findConsole(actionType);
        this.outputStream = generationConsole.newOutputStream();
        this.timingLogger = new TimingListener(BuildUtil.findConsole(Messages.ExecuteAnt_56));
        this.antLogLevel = InstanceScope.INSTANCE.getNode("com.indy.ui.build").getInt("outputLevel", 4);
        if ("workspace.liteTransfo".equals(actionType)) {
            generationConsole.activate();
        }
    }

    public void apply(Project ant) {
        PrintStream printStream = new PrintStream(this.outputStream);
        DefaultLogger log = new DefaultLogger(){

            public void buildFinished(BuildEvent event) {
                if (event.getException() != null) {
                    this.handleExecutionError((Exception)event.getException(), this.getBuildFailedMessage());
                } else {
                    super.buildFinished(event);
                }
            }

            public void handleExecutionError(Exception ex, String failureMessage) {
                StringBuilder message = new StringBuilder();
                message.append(System.getProperty("line.separator"));
                message.append(failureMessage);
                message.append(System.getProperty("line.separator"));
                this.printMessage(message.toString(), this.err, 0);
                ex.printStackTrace(this.err);
                UILoggingConfiguration.this.logInErrorConsole(ex);
            }
        };
        log.setErrorPrintStream(new PrintStream(printStream));
        log.setOutputPrintStream(new PrintStream(printStream));
        log.setMessageOutputLevel(this.antLogLevel);
        ant.addBuildListener((BuildListener)log);
        ant.addBuildListener((BuildListener)this.timingLogger);
    }

    private void logInErrorConsole(Exception e) {
        MessageConsoleRunnable.logInConsole(e);
    }
}

