/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.launchers.configurations;

import com.indy.addons.httprest.HttpHelper;
import com.indy.ui.build.launchers.Messages;
import com.semarchy.xdi.base.core.auth.BasicAuthentication;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

class AnalyticsHttpHelper {
    static final String boundary = "***";
    static final String prefix = "--";
    private URI uri;
    private String authroziationHeader = null;
    private String method;

    AnalyticsHttpHelper(String url, String method, String user, String password) throws Exception {
        this.uri = new URI(url);
        this.method = method;
        if (user != null && !user.trim().isEmpty()) {
            this.authroziationHeader = new BasicAuthentication(user, password).getAuthenticationHeaderValue(null);
        }
    }

    public void sendPackage(String fileName, byte[] rawData) throws Exception {
        Proxy proxy = null;
        if (this.uri != null) {
            IProxyData[] iProxyDataArray;
            IProxyService proxyService = (IProxyService)E4InjectorHelper.getService(IProxyService.class);
            if (proxyService != null && (iProxyDataArray = proxyService.select(this.uri)).length != 0) {
                IProxyData pData = iProxyDataArray[0];
                proxy = pData.getType().equalsIgnoreCase("HTTP") || pData.getType().equalsIgnoreCase("HTTPS") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(pData.getHost(), pData.getPort())) : new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(pData.getHost(), pData.getPort()));
            }
            if (proxy == null) {
                List<Proxy> proxys = ProxySelector.getDefault().select(this.uri);
                proxy = proxys.get(0);
            }
            String errorMessage = null;
            URLConnection conn = null;
            InputStream resStream = null;
            try {
                try {
                    Authenticator.setDefault(null);
                    conn = this.uri.toURL().openConnection(proxy);
                    HttpURLConnection http = (HttpURLConnection)conn;
                    if (http instanceof HttpsURLConnection) {
                        HttpHelper.configureHttps((HttpsURLConnection)((HttpsURLConnection)http));
                    }
                    http.setDoOutput(true);
                    http.setRequestMethod(this.method);
                    http.setUseCaches(false);
                    if (this.authroziationHeader != null) {
                        http.setRequestProperty("Authorization", this.authroziationHeader);
                    }
                    http.setRequestProperty("Connection", "Keep-Alive");
                    http.setRequestProperty("Content-type", "multipart/form-data; boundary=***");
                    http.connect();
                    try (DataOutputStream writer = null;){
                        writer = new DataOutputStream(http.getOutputStream());
                        writer.writeBytes("--***\n");
                        writer.writeBytes("Content-Disposition: form-data; name=\"fileUpload\"; filename=\"" + fileName + "\"\n");
                        writer.writeBytes("Content-Type: application/zip\n");
                        writer.writeBytes("Content-Transfer-Encoding: binary\n\n");
                        writer.write(rawData);
                        writer.writeBytes("\n--***--");
                        writer.flush();
                    }
                    int responseCode = http.getResponseCode();
                    resStream = responseCode == 200 || responseCode == 201 ? http.getInputStream() : http.getErrorStream();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    if (resStream != null) {
                        byte[] buf = new byte[1024];
                        int sz = -1;
                        while ((sz = resStream.read(buf)) != -1) {
                            bos.write(buf, 0, sz);
                        }
                    }
                    if (responseCode != 200 && responseCode != 201) {
                        errorMessage = String.valueOf(http.getResponseMessage()) + ":\n" + new String(bos.toByteArray());
                        throw new Exception(String.valueOf(Messages.AnalyticsHttpHelper_17) + responseCode + ": " + errorMessage);
                    }
                }
                catch (Exception ex) {
                    throw new Exception(String.valueOf(Messages.AnalyticsHttpHelper_19) + ex.getMessage(), ex);
                }
            }
            finally {
                if (resStream != null) {
                    try {
                        resStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                HttpHelper.restoreHttpAuthenticator();
            }
        }
    }
}

