/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.launchers.configurations;

import com.indy.ui.build.launchers.Messages;
import com.indy.ui.build.launchers.configurations.AnalyticsHttpHelper;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.AntLaunchHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ui.statushandlers.StatusManager;

public class PackageLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String BUILD_PACKAGE_MULTI = "package.multiProc";

    private void handleRefreshAndPublication(ILaunchConfiguration configuration) {
        try {
            String outMode;
            String analyticsURI = configuration.getAttribute("com.indy.launchers.attributes.analytics.http.url", null);
            String analyticsUser = configuration.getAttribute("com.indy.launchers.attributes.analytics.http.user", null);
            String analyticsPassword = configuration.getAttribute("com.indy.launchers.attributes.analytics.http.password", null);
            if (analyticsURI != null && !analyticsURI.isEmpty()) {
                File f = AntLaunchHelper.extractOutputFilePath((ILaunchConfiguration)configuration);
                if (!f.exists() || !f.isFile()) {
                    throw new Exception(String.valueOf(Messages.PackageLaunchConfigurationDelegate_0) + f.getAbsolutePath());
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));){
                        byte[] buf = new byte[1024];
                        int sz = -1;
                        while ((sz = fis.read(buf)) != -1) {
                            bos.write(buf, 0, sz);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new Exception(String.valueOf(Messages.PackageLaunchConfigurationDelegate_1) + f, ex);
                }
                AnalyticsHttpHelper h = new AnalyticsHttpHelper(analyticsURI, "PUT", analyticsUser, analyticsPassword);
                h.sendPackage(f.getName(), bos.toByteArray());
            }
            if ("workspace".equals(outMode = configuration.getAttribute("com.indy.launchers.attributes.outputMode", ""))) {
                String out = configuration.getAttribute("com.indy.launchers.attributes.outputFolder", "");
                final IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(out);
                Job refreshJob = new Job("Refresh resource"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            r.getProject().refreshLocal(2, monitor);
                            return Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            return new Status(2, ((Object)((Object)this)).getClass(), String.format("Failed to refresh %s ", r), (Throwable)e);
                        }
                    }
                };
                refreshJob.setUser(true);
                refreshJob.setRule((ISchedulingRule)r);
                refreshJob.schedule();
            }
        }
        catch (Throwable t) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.ui.build.launchers", Messages.PackageLaunchConfigurationDelegate_4, t), 5);
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            Map antOptions = AntLaunchHelper.createAntTaskOptions((ILaunchConfiguration)configuration);
            IGenerationService.EnvironmentInitializer initializer = IGenerationService.EnvironmentInitializer.of((Map)antOptions, null);
            IGenerationService.ITaskSynchronizer synchronizer = (IGenerationService.ITaskSynchronizer)E4InjectorHelper.getService(IGenerationService.ITaskSynchronizer.class);
            synchronizer.executeTask(BUILD_PACKAGE_MULTI, null, initializer, (res, o) -> this.handleRefreshAndPublication(configuration));
        }
        catch (Throwable t) {
            throw new CoreException((IStatus)new Status(4, "com.indy.ui.build.launchers", Messages.PackageLaunchConfigurationDelegate_4, t));
        }
    }
}

