/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.launchers.ui.tabs;

import com.indy.ui.build.launchers.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LaunchViewer {
    private static final String SEARCH_TEXT = "type filter text";
    public static Image treeImage;
    public static Image listImage;
    public static Image projectImage;
    public static Image folderImage;
    public static Image procImage;
    private static final Color bgColor;
    private static final Color frColor;
    public Set<IResource> processResources = new HashSet<IResource>();
    private static final Timer timer;
    private CheckboxTreeViewer viewer;
    private Button ShowSelected;
    private boolean listLayout = true;
    private boolean updatingItemState = false;
    private String search = null;
    private boolean onlyShowSelected = true;
    private boolean initializingContent = false;

    static {
        bgColor = new Color(null, 255, 255, 255);
        frColor = new Color(null, 128, 128, 128);
        try {
            treeImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.environment/icons/full/menu16x16/tree.gif")).createImage();
            listImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.environment/icons/full/menu16x16/list.gif")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            projectImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/prj_obj.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            folderImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/folder.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            procImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.editor/icons/full/obj16/ProcModelFile.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        timer = new Timer("SearchBar Timer");
    }

    public Control createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        Composite c = new Composite(main, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ((GridLayout)c.getLayout()).marginLeft = 0;
        ((GridLayout)c.getLayout()).marginRight = 0;
        Text textFilter = new Text(main, 2048);
        textFilter.setLayoutData((Object)new GridData(4, 1, true, false));
        textFilter.setText(SEARCH_TEXT);
        textFilter.setForeground(frColor);
        textFilter.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text l = (Text)e.widget;
                if (l.getText().trim().isEmpty()) {
                    l.setForeground(frColor);
                    l.setText(LaunchViewer.SEARCH_TEXT);
                }
            }

            public void focusGained(FocusEvent e) {
                Text l = (Text)e.widget;
                if (frColor.equals((Object)l.getForeground())) {
                    l.setForeground(null);
                    l.setText("");
                }
            }
        });
        textFilter.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Text l = (Text)e.widget;
                l.selectAll();
            }
        });
        textFilter.addModifyListener(new ModifyListener(){
            volatile TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    LaunchViewer.this.viewer.refresh();
                }
            };

            public void modifyText(final ModifyEvent e) {
                this.task.cancel();
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        LaunchViewer.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (this.needRefresh(e)) {
                                    LaunchViewer.this.viewer.refresh();
                                }
                            }
                        });
                    }
                };
                timer.schedule(this.task, 300L);
            }

            boolean needRefresh(ModifyEvent e) {
                String oldSearch = LaunchViewer.this.search;
                if (frColor.equals((Object)((Text)e.widget).getForeground())) {
                    LaunchViewer.this.search = null;
                    if (oldSearch != null && !oldSearch.trim().isEmpty()) {
                        return true;
                    }
                } else {
                    LaunchViewer.this.search = ((Text)e.widget).getText();
                    if (oldSearch != null ? !LaunchViewer.this.search.equals(oldSearch) : !LaunchViewer.this.search.trim().isEmpty()) {
                        return true;
                    }
                }
                return false;
            }
        });
        this.viewer = new CheckboxTreeViewer(main, 0x10010B00);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (LaunchViewer.this.listLayout) {
                    return ((IResource)element).getFullPath().toString();
                }
                return ((IResource)element).getName();
            }

            public Image getImage(Object element) {
                if (element instanceof IProject) {
                    return projectImage;
                }
                if (element instanceof IFolder) {
                    return folderImage;
                }
                return procImage;
            }
        });
        this.ShowSelected = new Button(main, 32);
        this.ShowSelected.setLayoutData((Object)new GridData(4, 3, true, false, 2, 1));
        this.ShowSelected.setText(Messages.LaunchViewer_11);
        this.ShowSelected.setSelection(this.onlyShowSelected);
        this.ShowSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchViewer.this.onlyShowSelected = ((Button)e.widget).getSelection();
                LaunchViewer.this.viewer.refresh();
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (LaunchViewer.this.initializingContent) {
                    return true;
                }
                if (element instanceof IFile) {
                    if (!LaunchViewer.this.processResources.contains(element)) {
                        return false;
                    }
                    if (LaunchViewer.this.onlyShowSelected && !LaunchViewer.this.viewer.getChecked(element)) {
                        return false;
                    }
                    if (!"proc".equals(((IFile)element).getFileExtension())) {
                        return false;
                    }
                    if (LaunchViewer.this.search == null || LaunchViewer.this.search.isEmpty()) {
                        return true;
                    }
                    IPath val = ((IResource)element).getFullPath();
                    String s = val.toString();
                    return s.toLowerCase().matches(".*" + LaunchViewer.this.search.toLowerCase().replace("*", ".*") + ".*");
                }
                if (element instanceof IProject && !((IProject)element).isOpen()) {
                    return false;
                }
                return !(element instanceof IContainer) || this.containsProc((IResource)((IContainer)element));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean containsProc(IResource element) {
                if (element.getType() == 2) {
                    if (element.getName().equals("indy.build")) return false;
                    if (element.getName().equals("indy.diagram")) {
                        return false;
                    }
                }
                try {
                    IResource[] iResourceArray = ((IContainer)element).members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource r = iResourceArray[n2];
                        if (r.getType() == 1) {
                            if ("proc".equals(r.getFileExtension())) {
                                if (LaunchViewer.this.search == null) return true;
                                if (LaunchViewer.this.search.isEmpty()) {
                                    return true;
                                }
                                IPath val = element.getFullPath();
                                String s = val.toString();
                                if (!s.toLowerCase().matches(".*" + LaunchViewer.this.search.toLowerCase().replace("*", ".*") + ".*")) return false;
                                return true;
                            }
                        } else if (this.containsProc((IResource)((IContainer)r))) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return false;
            }
        });
        ICacheService s = (ICacheService)PlatformUI.getWorkbench().getService(ICacheService.class);
        for (URI u : s.listNonTemplatesProcesses()) {
            if (!u.isPlatformResource()) continue;
            this.processResources.add((IResource)Util.convertEMFURIToFile((URI)u));
        }
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        return main;
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void setSelectedOnly(boolean selectedOnly) {
        this.initializingContent = true;
        this.initializingContent = false;
        this.onlyShowSelected = selectedOnly;
        if (this.ShowSelected != null && this.ShowSelected.getSelection() != this.onlyShowSelected) {
            this.ShowSelected.setSelection(this.onlyShowSelected);
            this.viewer.refresh();
        }
    }

    public boolean isSelectedOnly() {
        return this.onlyShowSelected;
    }

    private class ResourceContentProvider
    implements ITreeContentProvider {
        Visitor v = null;

        private ResourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (LaunchViewer.this.listLayout) {
                if (this.v == null) {
                    this.v = new Visitor();
                    try {
                        ((IResource)inputElement).accept((IResourceVisitor)this.v);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                return this.v.launcheable.toArray(new Object[this.v.launcheable.size()]);
            }
            try {
                return ((IContainer)inputElement).members();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return new Object[0];
            }
        }

        public Object[] getChildren(Object parentElement) {
            try {
                return ((IContainer)parentElement).members();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContainer) {
                try {
                    return ((IContainer)element).members().length > 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    private static class Visitor
    implements IResourceVisitor {
        public List<IResource> launcheable = new ArrayList<IResource>();

        private Visitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 4 && !((IProject)resource).isOpen()) {
                return false;
            }
            if (resource.getType() == 2 && ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName()))) {
                return false;
            }
            if (resource.getType() == 1 && "proc".equals(resource.getFileExtension())) {
                this.launcheable.add(resource);
            }
            return true;
        }
    }
}

