/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.launchers.ui.tabs;

import com.indy.ui.build.Activator;
import com.indy.ui.build.launchers.Messages;
import com.indy.ui.build.launchers.ui.tabs.LaunchViewer;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProcessTab
extends AbstractLaunchConfigurationTab {
    private static final String PREF_SHOW_MAP = "processTab.showMap";
    private static final String PREF_SHOW_PROC = "processTab.showProc";
    private static final String PREF_WIDTH = "processTab.width";
    private static final String PREF_HEIGHT = "processTab.height";
    static Image checkAll;
    static Image uncheckAll;
    static Image mapping;
    static Image process;
    private TableViewer viewer;
    private Set<IFile> checkedProcesses = new HashSet<IFile>();
    private Text description;
    private Visitor visitor = null;

    static {
        try {
            checkAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/checkAll.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            uncheckAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/uncheckall.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            mapping = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/map.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            process = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.diagram.non_rcp/icons/obj16/ProcDiagramFile.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public Image getImage() {
        return LaunchViewer.procImage;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        ToolBar tb = new ToolBar(comp, 0);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(tb, 8);
        add.setImage(AbstractUnboundedControl.addIcon);
        add.setToolTipText(Messages.ProcessTab_8);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionDialog des = new ResourceSelectionDialog(ProcessTab.this.viewer.getControl().getShell());
                if (ProcessTab.this.visitor == null) {
                    ProcessTab.this.visitor = new Visitor();
                    try {
                        new ProgressMonitorDialog(ProcessTab.this.viewer.getControl().getShell()).run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)ProcessTab.this.visitor);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (des.open() == 0) {
                    ProcessTab.this.checkedProcesses.addAll(des.selected);
                    ProcessTab.this.viewer.refresh();
                    ProcessTab.this.setDirty(true);
                    ProcessTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        ToolItem del = new ToolItem(tb, 8);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setToolTipText(Messages.ProcessTab_9);
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProcessTab.this.checkedProcesses.removeAll(((IStructuredSelection)ProcessTab.this.viewer.getSelection()).toList())) {
                    ProcessTab.this.viewer.refresh();
                    ProcessTab.this.setDirty(true);
                    ProcessTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.viewer = new TableViewer(comp, 68098);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                return super.decorateText(((IResource)element).getFullPath().toString(), element);
            }

            protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
                if (!((IFile)element).exists()) {
                    return Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/delete_obj.png");
                }
                return super.decorateImage(input, element);
            }
        });
        this.viewer.setSorter((ViewerSorter)new ResourceSorter());
        ((GridData)this.viewer.getControl().getLayoutData()).minimumHeight = 150;
        Label l = new Label(comp, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.ProcessTab_10);
        this.description = new Text(comp, 2626);
        this.description.setLayoutData((Object)new GridData(4, 4, true, true));
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessTab.this.setDirty(true);
                ProcessTab.this.updateLaunchConfigurationDialog();
            }
        });
        ((GridData)this.description.getLayoutData()).minimumHeight = 150;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        ArrayList<String> fileNames = new ArrayList<String>();
        boolean multipleFilesWithSameName = false;
        for (IFile o : this.checkedProcesses) {
            if (!(o instanceof IFile) || multipleFilesWithSameName) continue;
            if (fileNames.contains(o.getFullPath().removeFileExtension().lastSegment())) {
                multipleFilesWithSameName = true;
                continue;
            }
            fileNames.add(o.getFullPath().removeFileExtension().lastSegment());
        }
        if (multipleFilesWithSameName) {
            this.setErrorMessage(Messages.ProcessTab_11);
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.indy.launchers.attributes.selectedOnly", false);
        configuration.setAttribute("com.indy.launchers.attributes.hasDocumentation", true);
        IViewPart p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (p != null) {
            ArrayList<String> l = new ArrayList<String>();
            IStructuredSelection ss = (IStructuredSelection)p.getViewSite().getSelectionProvider().getSelection();
            for (Object o : ss.toList()) {
                if (!(o instanceof IFile) || !"proc".equals(((IFile)o).getFileExtension())) continue;
                if (l.isEmpty()) {
                    configuration.rename(((IFile)o).getProjectRelativePath().removeFileExtension().lastSegment());
                }
                l.add(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(Util.convertIFileToEMFURI((IFile)((IFile)o))));
            }
            if (!l.isEmpty()) {
                configuration.setAttribute("com.indy.launchers.attributes.processListId", l);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block13: {
            this.checkedProcesses.clear();
            try {
                boolean __confWithResourcePath = false;
                for (String s : configuration.getAttribute("com.indy.launchers.attributes.processListId", Collections.EMPTY_LIST)) {
                    IFile _o;
                    URI uri;
                    __confWithResourcePath = true;
                    if (s.endsWith("-proc")) {
                        s = s.replace("-proc", "");
                    }
                    if ((uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(s)) == null || (_o = Util.convertEMFURIToFile((URI)uri)) == null || !_o.exists()) continue;
                    this.checkedProcesses.add(_o);
                }
                if (__confWithResourcePath) break block13;
                for (String s : configuration.getAttribute("com.indy.launchers.attributes.processList", Collections.EMPTY_LIST)) {
                    int i;
                    Path p = new Path(s);
                    if ("indy.build".equals(p.segment(1))) {
                        Path _srcPath = new Path("");
                        i = 0;
                        while (i < p.segmentCount() - 1) {
                            if (i != 1) {
                                _srcPath = _srcPath.append(p.segment(i));
                            }
                            ++i;
                        }
                        p = _srcPath = _srcPath.append(String.valueOf(p.removeFileExtension().lastSegment()) + ".map");
                    }
                    Path _p = new Path("");
                    i = 0;
                    while (i < p.segmentCount()) {
                        try {
                            _p = _p.append(URLDecoder.decode(p.segment(i), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    IFile _o = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)_p);
                    if (_o == null) continue;
                    this.checkedProcesses.add(_o);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            String description = configuration.getAttribute("com.indy.launchers.attributes.description", "");
            this.description.setText(description);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.viewer.setInput(this.checkedProcesses);
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (configuration.isDirty() || this.isDirty()) {
            configuration.setAttribute("com.indy.launchers.attributes.description", this.description.getText());
            ArrayList<String> l = new ArrayList<String>();
            for (IFile f : this.checkedProcesses) {
                String modelid = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(Util.convertIFileToEMFURI((IFile)f));
                if (modelid == null) continue;
                if ("map".equals(f.getFileExtension())) {
                    modelid = String.valueOf(modelid) + "-proc";
                }
                l.add(modelid);
            }
            configuration.setMappedResources(this.checkedProcesses.toArray(new IResource[this.checkedProcesses.size()]));
            configuration.setAttribute("com.indy.launchers.attributes.processListId", l);
            configuration.setAttribute("com.indy.launchers.attributes.processList", null);
        }
    }

    public String getName() {
        return Messages.ProcessTab_22;
    }

    private class ResourceSelectionDialog
    extends Dialog {
        Preferences preferences;
        Filter filter;
        private Job refreshJob;
        CheckboxTableViewer v;
        List selected;

        protected ResourceSelectionDialog(Shell parentShell) {
            super(parentShell);
            this.preferences = InstanceScope.INSTANCE.getNode("com.indy.ui.build");
            this.filter = null;
            this.selected = null;
            this.filter = new Filter();
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.refreshJob = new UIJob(parentShell.getDisplay(), Messages.ProcessTab_6){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ResourceSelectionDialog.this.v.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.refreshJob.setSystem(true);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(Messages.ProcessTab_0);
            super.configureShell(newShell);
            newShell.setSize(this.preferences.getInt(ProcessTab.PREF_WIDTH, 500), this.preferences.getInt(ProcessTab.PREF_HEIGHT, 400));
            Point p = newShell.getDisplay().getCursorLocation();
            newShell.setLocation(p.x + 1, p.y + 1);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }

        public boolean close() {
            this.preferences.putInt(ProcessTab.PREF_WIDTH, this.getShell().getSize().x);
            this.preferences.putInt(ProcessTab.PREF_HEIGHT, this.getShell().getSize().y);
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            return super.close();
        }

        protected Control createDialogArea(Composite parent) {
            this.createToolbar(parent).setLayoutData((Object)new GridData(4, 1, true, false));
            this.v = CheckboxTableViewer.newCheckList((Composite)parent, (int)66306);
            this.v.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.v.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()){
                Map<IResource, String> labels;
                {
                    this.labels = new HashMap<IResource, String>();
                }

                public String getText(Object element) {
                    String s = this.labels.get(element);
                    if (s == null) {
                        s = ((IResource)element).getFullPath().toString();
                        this.labels.put((IResource)element, s);
                    }
                    return s;
                }
            });
            this.v.getControl().setLayoutData((Object)new GridData(1808));
            this.v.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ResourceSelectionDialog.this.getButton(0).setEnabled(ResourceSelectionDialog.this.v.getCheckedElements().length > 0);
                }
            });
            this.v.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ResourceSelectionDialog.this.v.getTable().getSelection().length > 1) {
                        TableItem[] tableItemArray = ResourceSelectionDialog.this.v.getTable().getSelection();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem item = tableItemArray[n2];
                            item.setChecked(true);
                            ++n2;
                        }
                    } else if (e.detail != 32) {
                        Object element = ((TableItem)e.item).getData();
                        boolean currentState = ResourceSelectionDialog.this.v.getChecked(element);
                        ResourceSelectionDialog.this.v.setChecked(element, !currentState);
                        ResourceSelectionDialog.this.getButton(0).setEnabled(ResourceSelectionDialog.this.v.getCheckedElements().length > 0);
                    }
                }
            });
            this.v.setSorter((ViewerSorter)new ResourceSorter());
            this.v.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!ProcessTab.this.checkedProcesses.contains(element)) {
                        if (!ResourceSelectionDialog.this.filter.showMap && "map".equals(((IResource)element).getFileExtension())) {
                            return false;
                        }
                        if (!ResourceSelectionDialog.this.filter.showProc && "proc".equals(((IResource)element).getFileExtension())) {
                            return false;
                        }
                        if (ResourceSelectionDialog.this.filter == null) {
                            return true;
                        }
                        String s = ((ILabelProvider)ResourceSelectionDialog.this.v.getLabelProvider()).getText(element);
                        return ResourceSelectionDialog.this.filter.match(s.toLowerCase());
                    }
                    return false;
                }
            });
            return this.v.getControl();
        }

        private Composite createToolbar(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setBackground(parent.getDisplay().getSystemColor(1));
            GridLayout gl = null;
            gl = new GridLayout(2, false);
            main.setLayout((Layout)gl);
            gl.horizontalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            Text t = new Text(main, 2048);
            t.setLayoutData((Object)new GridData(4, 1, true, false));
            t.setToolTipText(Messages.ProcessTab_3);
            t.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ResourceSelectionDialog.this.filter.setFilter(((Text)e.widget).getText());
                }
            });
            ToolBar tb = new ToolBar(main, 0x800100);
            tb.setBackground(parent.getDisplay().getSystemColor(1));
            tb.setLayoutData((Object)new GridData(3, 1, false, false));
            ToolItem it = new ToolItem(tb, 32);
            it.setToolTipText(Messages.ProcessTab_13);
            it.setImage(process);
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceSelectionDialog.this.filter.showOrHideProc();
                }
            });
            it.setSelection(this.preferences.getBoolean(ProcessTab.PREF_SHOW_PROC, true));
            it = new ToolItem(tb, 32);
            it.setToolTipText(Messages.ProcessTab_14);
            it.setImage(mapping);
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceSelectionDialog.this.filter.showOrHideMap();
                }
            });
            it.setSelection(this.preferences.getBoolean(ProcessTab.PREF_SHOW_MAP, false));
            new ToolItem(tb, 2);
            it = new ToolItem(tb, 8);
            it.setImage(checkAll);
            it.setToolTipText(Messages.ProcessTab_15);
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceSelectionDialog.this.v.setAllChecked(true);
                    ResourceSelectionDialog.this.getButton(0).setEnabled(ResourceSelectionDialog.this.v.getCheckedElements().length > 0);
                }
            });
            it = new ToolItem(tb, 8);
            it.setImage(uncheckAll);
            it.setToolTipText(Messages.ProcessTab_16);
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceSelectionDialog.this.v.setAllChecked(false);
                    ResourceSelectionDialog.this.getButton(0).setEnabled(ResourceSelectionDialog.this.v.getCheckedElements().length > 0);
                }
            });
            return main;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            this.v.setInput(((ProcessTab)ProcessTab.this).visitor.resources);
        }

        protected void okPressed() {
            this.selected = Arrays.asList(this.v.getCheckedElements());
            super.okPressed();
        }

        private class Filter {
            private String filter = null;
            private boolean showMap;
            private boolean showProc;

            private Filter() {
                this.showMap = ResourceSelectionDialog.this.preferences.getBoolean(ProcessTab.PREF_SHOW_MAP, false);
                this.showProc = ResourceSelectionDialog.this.preferences.getBoolean(ProcessTab.PREF_SHOW_PROC, true);
            }

            void setFilter(String f) {
                if (f.trim().isEmpty()) {
                    if (this.filter != null) {
                        this.filter = null;
                        this.refreshContent();
                    }
                } else if (!f.equalsIgnoreCase(this.filter)) {
                    this.filter = f.toLowerCase();
                    this.refreshContent();
                }
            }

            void showOrHideMap() {
                this.showMap = !this.showMap;
                ResourceSelectionDialog.this.preferences.putBoolean(ProcessTab.PREF_SHOW_MAP, this.showMap);
                this.refreshContent();
            }

            void showOrHideProc() {
                this.showProc = !this.showProc;
                ResourceSelectionDialog.this.preferences.putBoolean(ProcessTab.PREF_SHOW_PROC, this.showProc);
                this.refreshContent();
            }

            private void refreshContent() {
                ResourceSelectionDialog.this.refreshJob.cancel();
                ResourceSelectionDialog.this.refreshJob.schedule(200L);
            }

            public boolean match(String s) {
                if (this.filter == null || this.filter.isEmpty()) {
                    return true;
                }
                return s.contains(this.filter);
            }
        }
    }

    private class ResourceSorter
    extends ViewerSorter {
        private ResourceSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IPath p1 = ((IFile)e1).getFullPath();
            IPath p2 = ((IFile)e2).getFullPath();
            return p1.toString().toLowerCase().compareTo(p2.toString().toLowerCase());
        }
    }

    private class Visitor
    implements IResourceVisitor {
        Set<IFile> resources = new HashSet<IFile>();

        private Visitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 4) {
                if (!resource.getProject().isOpen()) {
                    return false;
                }
            } else if (resource.getType() == 2) {
                if (resource.getName().equals("indy.build") || resource.getName().equals("indy.diagram")) {
                    return false;
                }
            } else if (resource.getType() == 1) {
                String ext = resource.getFileExtension();
                if ("map".equals(ext) || "proc".equals(ext)) {
                    this.resources.add((IFile)resource);
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

