/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.core.IDecryptService;
import com.indy.engine.core.UtilsService;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.internal.JsonNodeToObject;
import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.stambia.mongodb.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.Converter;
import org.bson.json.JsonWriterSettings;
import org.bson.json.StrictJsonWriter;

public abstract class MongoDBOperation {
    private static final JsonWriterSettings jsonWriterSettings;
    private static final String tempCollectionName = "ee_temp_for_update_00";
    private static final String tempCollectionResultName = "ee_temp_for_update_00result";
    private List<String> updateKeys;
    private boolean interrupt = false;
    private String database;
    private String collection;
    private boolean already = false;
    private Operator op;
    private MongoClientURI uri;
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private JsonNodeToObject.JsonNodeToObjectHandler writeHandler;
    int batchSize;
    private JsonNodeToObject.JsonNodeToObjectHandler _insertHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private List<Document> allDocumentToInsert = new Vector<Document>();

        public void handleNode(Object o) throws Exception {
            Document dbObject = Document.parse((String)((String)o));
            this.allDocumentToInsert.add(dbObject);
            this.batch(false);
        }

        private void batch(boolean last) throws Exception {
            if (this.allDocumentToInsert.size() == MongoDBOperation.this.batchSize || last && this.allDocumentToInsert.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                collectionObject.insertMany(this.allDocumentToInsert);
                for (Document dbObject : this.allDocumentToInsert) {
                    Map map = null;
                    map = MongoDBOperation.this.documentToMap(dbObject);
                    MongoDBOperation.this.writeHandler.handleNode((Object)dbObject.toJson(jsonWriterSettings));
                }
                MongoDBOperation.this.getHandler().handle("MONGODB_INSERT", (long)this.allDocumentToInsert.size());
                this.allDocumentToInsert.clear();
            }
        }

        public void handleEnd() throws Exception {
            this.batch(true);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler __old_dropInsertHandler_old = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private List<Document> allDocumentToInsert = new Vector<Document>();

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            this.allDocumentToInsert.add(dbObject);
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
        }

        private void batch(boolean last) {
            if (this.allDocumentToInsert.size() == MongoDBOperation.this.batchSize || last && this.allDocumentToInsert.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                collectionObject.insertMany(this.allDocumentToInsert);
                MongoDBOperation.this.getHandler().handle("MONGODB_INSERT", (long)this.allDocumentToInsert.size());
            }
        }

        public void handleEnd() throws IOException {
            MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
            collectionObject.drop();
            collectionObject.insertMany(this.allDocumentToInsert);
            MongoDBOperation.this.getHandler().handle("MONGODB_INSERT", (long)this.allDocumentToInsert.size());
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler __old_deleteInsertHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private List<Document> allDocumentToInsert = new Vector<Document>();

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            this.allDocumentToInsert.add(dbObject);
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
        }

        public void handleEnd() throws IOException {
            MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
            DeleteResult delResult = collectionObject.deleteMany((Bson)Document.parse((String)"{}"));
            collectionObject.insertMany(this.allDocumentToInsert);
            MongoDBOperation.this.getHandler().handle("MONGODB_DELETE", delResult.getDeletedCount());
            MongoDBOperation.this.getHandler().handle("MONGODB_INSERT", (long)this.allDocumentToInsert.size());
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler __old_updateHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private long updateCount = 0L;
        private List<Document> tempDocumentToInsert = new Vector<Document>();

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            this.tempDocumentToInsert.add(dbObject);
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
        }

        public void handleEnd() throws IOException {
            MongoCollection tempCollectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.tempCollectionName);
            tempCollectionObject.drop();
            tempCollectionObject.insertMany(this.tempDocumentToInsert);
            final MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
            AggregateIterable result = collectionObject.aggregate(Arrays.asList(Document.parse((String)("{$lookup:{from:\"ee_temp_for_update_00\" localField:\"" + MongoDBOperation.this.updateKeys + "\" foreignField:\"" + MongoDBOperation.this.updateKeys + "\" as: \"" + MongoDBOperation.tempCollectionResultName + "\"}}"))));
            result.forEach(document -> {
                Block<Document> block = new Block<Document>(){

                    public void apply(Document currentResultDoc) {
                        Vector listOfResultDocument = new Vector();
                        List listOfResults = (List)currentResultDoc.get((Object)MongoDBOperation.tempCollectionResultName);
                        if (!listOfResults.isEmpty()) {
                            listOfResultDocument.addAll(listOfResults);
                            currentResultDoc.remove((Object)MongoDBOperation.tempCollectionResultName);
                            currentResultDoc.remove((Object)"_id");
                            currentResultDoc.remove((this).MongoDBOperation.this.updateKeys);
                            for (Document result : listOfResultDocument) {
                                result.remove((Object)"_id");
                                result.remove((this).MongoDBOperation.this.updateKeys);
                                Document _rsult = new Document("$set", (Object)result);
                                updateCount += collectionObject.updateOne((Bson)currentResultDoc, (Bson)_rsult).getModifiedCount();
                            }
                        }
                    }
                };
            });
            MongoDBOperation.this.getHandler().handle("MONGODB_UPDATE", this.updateCount);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler __old_pushHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private long updateCount = 0L;
        private List<Document> tempDocumentToInsert = new Vector<Document>();

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            this.tempDocumentToInsert.add(dbObject);
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
        }

        public void handleEnd() throws IOException {
            MongoCollection tempCollectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.tempCollectionName);
            tempCollectionObject.drop();
            tempCollectionObject.insertMany(this.tempDocumentToInsert);
            final MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
            AggregateIterable result = collectionObject.aggregate(Arrays.asList(Document.parse((String)("{$lookup:{from:\"ee_temp_for_update_00\" localField:\"" + MongoDBOperation.this.updateKeys + "\" foreignField:\"" + MongoDBOperation.this.updateKeys + "\" as: \"" + MongoDBOperation.tempCollectionResultName + "\"}}"))));
            result.forEach(currentResultDoc -> {
                Block<Document> block = new Block<Document>(){

                    public void apply(Document currentResultDoc) {
                        Vector listOfResultDocument = new Vector();
                        List listOfResults = (List)currentResultDoc.get((Object)MongoDBOperation.tempCollectionResultName);
                        if (!listOfResults.isEmpty()) {
                            listOfResultDocument.addAll(listOfResults);
                            currentResultDoc.remove((Object)MongoDBOperation.tempCollectionResultName);
                            currentResultDoc.remove((Object)"_id");
                            currentResultDoc.remove((this).MongoDBOperation.this.updateKeys);
                            Document array = null;
                            for (Document result : listOfResultDocument) {
                                result.remove((Object)"_id");
                                result.remove((this).MongoDBOperation.this.updateKeys);
                                for (Map.Entry pair : result.entrySet()) {
                                    Object key = pair.getKey();
                                    Object val = pair.getValue();
                                    if (!(val instanceof List)) continue;
                                    Document each = new Document("$each", val);
                                    array = new Document((String)key, (Object)each);
                                }
                                Document _rsult = new Document("$push", array);
                                updateCount += collectionObject.updateOne((Bson)currentResultDoc, (Bson)_rsult).getModifiedCount();
                            }
                        }
                    }
                };
            });
            MongoDBOperation.this.getHandler().handle("MONGODB_UPDATE", this.updateCount);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler __old_deleteHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private long deleteCount = 0L;
        private List<Document> tempDocumentToInsert = new Vector<Document>();

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            this.tempDocumentToInsert.add(dbObject);
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
        }

        public void handleEnd() throws IOException {
            MongoCollection tempCollectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.tempCollectionName);
            tempCollectionObject.drop();
            tempCollectionObject.insertMany(this.tempDocumentToInsert);
            final MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
            AggregateIterable result = collectionObject.aggregate(Arrays.asList(Document.parse((String)("{$lookup:{from:\"ee_temp_for_update_00\" localField:\"" + MongoDBOperation.this.updateKeys + "\" foreignField:\"" + MongoDBOperation.this.updateKeys + "\" as: \"" + MongoDBOperation.tempCollectionResultName + "\"}}"))));
            result.forEach(currentResultDoc -> {
                Block<Document> block = new Block<Document>(){

                    public void apply(Document currentResultDoc) {
                        Vector listOfResultDocument = new Vector();
                        List listOfResults = (List)currentResultDoc.get((Object)MongoDBOperation.tempCollectionResultName);
                        if (!listOfResults.isEmpty()) {
                            listOfResultDocument.addAll(listOfResults);
                            currentResultDoc.remove((Object)MongoDBOperation.tempCollectionResultName);
                            deleteCount += collectionObject.deleteOne((Bson)currentResultDoc).getDeletedCount();
                        }
                    }
                };
            });
            MongoDBOperation.this.getHandler().handle("MONGODB_DELETE", this.deleteCount);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler _upsertHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private Map<Document, Document> filtersAndSetDocument = new HashMap<Document, Document>();

        private void batch(boolean last) {
            if (this.filtersAndSetDocument.size() == MongoDBOperation.this.batchSize || last && this.filtersAndSetDocument.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                Vector<UpdateManyModel> listOfUpdate = new Vector<UpdateManyModel>();
                for (Map.Entry<Document, Document> pair : this.filtersAndSetDocument.entrySet()) {
                    UpdateManyModel wm = new UpdateManyModel((Bson)pair.getKey(), (Bson)pair.getValue(), new UpdateOptions().upsert(MongoDBOperation.this.op == Operator.upsert));
                    listOfUpdate.add(wm);
                }
                BulkWriteResult res = collectionObject.bulkWrite(listOfUpdate);
                int update = res.getModifiedCount();
                if (MongoDBOperation.this.op == Operator.upsert) {
                    int insert = listOfUpdate.size() - update;
                    MongoDBOperation.this.getHandler().handle("MONGODB_UPDATE", (long)update);
                    MongoDBOperation.this.getHandler().handle("MONGODB_INSERT", (long)insert);
                } else {
                    MongoDBOperation.this.getHandler().handle("MONGODB_UPDATE", (long)update);
                }
                this.filtersAndSetDocument.clear();
            }
        }

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            Vector<Document> list = new Vector<Document>();
            for (String updateKey : MongoDBOperation.this.updateKeys) {
                Object val = null;
                val = updateKey.contains(".") ? MongoDBOperation.this.getSubelementKeyVal(updateKey, dbObject) : dbObject.get((Object)updateKey);
                dbObject.remove((Object)updateKey);
                list.add(new Document(updateKey, (Object)new Document("$eq", val)));
            }
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
            dbObject.remove((Object)"_id");
            this.filtersAndSetDocument.put(new Document("$and", list), new Document("$set", (Object)dbObject));
            this.batch(false);
        }

        public void handleEnd() throws IOException {
            this.batch(true);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler _nothingHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){

        public void handleNode(Object o) throws Exception {
            MongoDBOperation.this.writeHandler.handleNode(o);
        }

        public void handleEnd() throws IOException {
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler __old2_deleteHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private List<Document> filters = new Vector<Document>();

        private void batch(boolean last) {
            if (this.filters.size() == MongoDBOperation.this.batchSize || last && this.filters.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                Vector<DeleteOneModel> listOfDelete = new Vector<DeleteOneModel>();
                for (Document filter : this.filters) {
                    DeleteOneModel wm = new DeleteOneModel((Bson)filter);
                    listOfDelete.add(wm);
                }
                BulkWriteResult res = collectionObject.bulkWrite(listOfDelete);
                MongoDBOperation.this.getHandler().handle("MONGODB_DELETE", (long)res.getDeletedCount());
                this.filters.clear();
            }
        }

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            ArrayList<Document> list = new ArrayList<Document>();
            for (String updateKey : MongoDBOperation.this.updateKeys) {
                Object val = null;
                val = updateKey.contains(".") ? MongoDBOperation.this.getSubelementKeyVal(updateKey, dbObject) : dbObject.get((Object)updateKey);
                dbObject.remove((Object)updateKey);
                list.add(new Document(updateKey, (Object)new Document("$eq", val)));
            }
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
            dbObject.remove((Object)"_id");
            this.filters.add(new Document("$and", list));
            this.batch(false);
        }

        public void handleEnd() throws IOException {
            this.batch(true);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler _getHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private List<Document> filters = new Vector<Document>();

        private void batch(boolean last) throws Exception {
            if (this.filters.size() == MongoDBOperation.this.batchSize || last && this.filters.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                if (MongoDBOperation.this.op == Operator.get) {
                    Vector listOfGet = new Vector();
                    Document doc = new Document();
                    doc.put("$or", this.filters);
                    FindIterable it = collectionObject.find((Bson)doc);
                    it.batchSize(MongoDBOperation.this.batchSize);
                    for (Object o : it) {
                        MongoDBOperation.this.writeHandler.handleNode((Object)((Document)o).toJson(jsonWriterSettings));
                    }
                } else {
                    Vector<DeleteOneModel> listOfDelete = new Vector<DeleteOneModel>();
                    for (Document filter : this.filters) {
                        DeleteOneModel wm = new DeleteOneModel((Bson)filter);
                        listOfDelete.add(wm);
                    }
                    BulkWriteResult res = collectionObject.bulkWrite(listOfDelete);
                    MongoDBOperation.this.getHandler().handle("MONGODB_DELETE", (long)res.getDeletedCount());
                }
                this.filters.clear();
            }
        }

        public void handleNode(Object o) throws Exception {
            Object map = null;
            Document dbObject = Document.parse((String)((String)o));
            ArrayList<Document> list = new ArrayList<Document>();
            if (MongoDBOperation.this.updateKeys.size() > 0) {
                for (String updateKey : MongoDBOperation.this.updateKeys) {
                    Object val = null;
                    val = updateKey.contains(".") ? MongoDBOperation.this.getSubelementKeyVal(updateKey, dbObject) : dbObject.get((Object)updateKey);
                    dbObject.remove((Object)updateKey);
                    list.add(new Document(updateKey, (Object)new Document("$eq", val)));
                }
                MongoDBOperation.this.writeHandler.handleNode(map);
                dbObject.remove((Object)"_id");
            } else {
                for (String updateKey : dbObject.keySet()) {
                    Object val = dbObject.get((Object)updateKey);
                    list.add(new Document(updateKey, (Object)new Document("$eq", val)));
                }
            }
            this.filters.add(new Document("$and", list));
            this.batch(false);
        }

        public void handleEnd() throws Exception {
            this.batch(true);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler _findHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private List<Document> filters = new Vector<Document>();

        private long batch(Integer skip, Integer limit) throws Exception {
            MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
            Document doc = this.filters.get(0);
            FindIterable it = collectionObject.find((Bson)doc);
            if (skip != null) {
                it = it.skip(skip.intValue());
            }
            if (limit != null) {
                it = it.limit(limit.intValue());
            }
            it.batchSize(MongoDBOperation.this.batchSize);
            long countLoop = 0L;
            for (Object o : it) {
                MongoDBOperation.this.writeHandler.handleNode((Object)((Document)o).toJson(jsonWriterSettings));
                if (!MongoDBOperation.this.useCount || !MongoDBOperation.this.applySkipLimit) continue;
                ++countLoop;
            }
            long count = 0L;
            if (MongoDBOperation.this.useCount) {
                count = MongoDBOperation.this.applySkipLimit ? countLoop : collectionObject.countDocuments();
            }
            this.filters.clear();
            return count;
        }

        public void handleNode(Object o) throws Exception {
            String _query;
            Integer skip = null;
            Integer limit = null;
            HashMap<String, String> inputParams = new HashMap<String, String>();
            if (o != null && !((String)o).isEmpty()) {
                Document doc = Document.parse((String)((String)o));
                boolean bl = MongoDBOperation.this.onlyCountParam = MongoDBOperation.this.useCount && doc.isEmpty();
                if (doc.containsKey((Object)"skip")) {
                    skip = (Integer)doc.get((Object)"skip");
                    doc.remove((Object)"skip");
                }
                if (doc.containsKey((Object)"limit")) {
                    limit = (Integer)doc.get((Object)"limit");
                    doc.remove((Object)"limit");
                }
                for (String key : doc.keySet()) {
                    Object val;
                    if (key.equals("result") || (val = doc.get((Object)key)) == null) continue;
                    if (val instanceof String) {
                        inputParams.put(key, "\"" + val + "\"");
                        continue;
                    }
                    inputParams.put(key, val.toString());
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                JsonUtils.convertJsonToXml((InputStream)new ByteArrayInputStream(MongoDBOperation.this.findQuery.getBytes("UTF-8")), (OutputStream)os, (String)"UTF-8", (String)"UTF-8", (boolean)false, inputParams);
                ByteArrayOutputStream os2 = new ByteArrayOutputStream();
                JsonUtils.convertXmlToJson((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)os2, (String)"UTF-8", (String)"UTF-8");
                _query = new String(os2.toByteArray());
            } else {
                _query = MongoDBOperation.this.findQuery;
            }
            Document dbObject = Document.parse((String)_query);
            this.filters.add(dbObject);
            MongoDBOperation.this.jew.add(JSonEvent.createStartObject());
            MongoDBOperation.this.jew.add(JSonEvent.createMember((String)"result"));
            MongoDBOperation.this.jew.add(JSonEvent.createStartArray());
            long count = this.batch(skip, limit);
            MongoDBOperation.this.jew.add(JSonEvent.createEndArray());
            if (MongoDBOperation.this.useCount) {
                MongoDBOperation.this.jew.add(JSonEvent.createMember((String)"count"));
                MongoDBOperation.this.jew.add(JSonEvent.createValue((String)String.valueOf(count)));
            }
            for (Map.Entry inputParam : inputParams.entrySet()) {
                String name = (String)inputParam.getKey();
                String value = (String)inputParam.getValue();
                MongoDBOperation.this.jew.add(JSonEvent.createMember((String)name));
                MongoDBOperation.this.jew.add(JSonEvent.createValue((String)value));
            }
            MongoDBOperation.this.jew.add(JSonEvent.createEndObject());
        }

        public void handleEnd() throws Exception {
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler _pushHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private Map<Document, Document> filtersAndSetDocument = new HashMap<Document, Document>();

        private void batch(boolean last) {
            if (this.filtersAndSetDocument.size() == MongoDBOperation.this.batchSize || last && this.filtersAndSetDocument.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                Vector<UpdateManyModel> listOfUpdate = new Vector<UpdateManyModel>();
                for (Map.Entry<Document, Document> pair : this.filtersAndSetDocument.entrySet()) {
                    UpdateManyModel wm = new UpdateManyModel((Bson)pair.getKey(), (Bson)pair.getValue(), new UpdateOptions().upsert(true));
                    listOfUpdate.add(wm);
                }
                BulkWriteResult res = collectionObject.bulkWrite(listOfUpdate);
                MongoDBOperation.this.getHandler().handle("MONGODB_PUSH", (long)res.getModifiedCount());
                this.filtersAndSetDocument.clear();
            }
        }

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            Vector<Document> list = new Vector<Document>();
            for (String updateKey : MongoDBOperation.this.updateKeys) {
                Object val = dbObject.get((Object)updateKey);
                dbObject.remove((Object)updateKey);
                list.add(new Document(updateKey, (Object)new Document("$eq", val)));
            }
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
            dbObject.remove((Object)"_id");
            Document push = null;
            for (Map.Entry pair : dbObject.entrySet()) {
                Object key = pair.getKey();
                Object _val = pair.getValue();
                if (!(_val instanceof List)) continue;
                Document each = new Document("$each", _val);
                Document array = new Document((String)key, (Object)each);
                push = new Document("$push", (Object)array);
            }
            this.filtersAndSetDocument.put(new Document("$and", list), push);
            this.batch(false);
        }

        public void handleEnd() throws IOException {
            this.batch(true);
        }
    };
    private JsonNodeToObject.JsonNodeToObjectHandler _addToSetHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
        private Map<Document, Document> filtersAndSetDocument = new HashMap<Document, Document>();

        private void batch(boolean last) {
            if (this.filtersAndSetDocument.size() == MongoDBOperation.this.batchSize || last && this.filtersAndSetDocument.size() > 0) {
                MongoCollection collectionObject = MongoDBOperation.this.mongoDatabase.getCollection(MongoDBOperation.this.collection);
                Vector<UpdateManyModel> listOfUpdate = new Vector<UpdateManyModel>();
                for (Map.Entry<Document, Document> pair : this.filtersAndSetDocument.entrySet()) {
                    UpdateManyModel wm = new UpdateManyModel((Bson)pair.getKey(), (Bson)pair.getValue(), new UpdateOptions().upsert(true));
                    listOfUpdate.add(wm);
                }
                BulkWriteResult res = collectionObject.bulkWrite(listOfUpdate);
                MongoDBOperation.this.getHandler().handle("MONGODB_PUSH", (long)res.getModifiedCount());
                this.filtersAndSetDocument.clear();
            }
        }

        public void handleNode(Object o) throws Exception {
            Map map = null;
            Document dbObject = Document.parse((String)((String)o));
            map = MongoDBOperation.this.documentToMap(dbObject);
            Vector<Document> list = new Vector<Document>();
            for (String updateKey : MongoDBOperation.this.updateKeys) {
                Object val = dbObject.get((Object)updateKey);
                dbObject.remove((Object)updateKey);
                list.add(new Document(updateKey, (Object)new Document("$eq", val)));
            }
            MongoDBOperation.this.writeHandler.handleNode((Object)map);
            dbObject.remove((Object)"_id");
            Document push = null;
            for (Map.Entry pair : dbObject.entrySet()) {
                Object key = pair.getKey();
                Object _val = pair.getValue();
                if (!(_val instanceof List)) continue;
                Document each = new Document("$each", _val);
                Document array = new Document((String)key, (Object)each);
                push = new Document("$addToSet", (Object)array);
            }
            this.filtersAndSetDocument.put(new Document("$and", list), push);
            this.batch(false);
        }

        public void handleEnd() throws IOException {
            this.batch(true);
        }
    };
    private String mongoDBUrl;
    private boolean dropCollection;
    private boolean deleteCollection;
    private String mongoHost;
    private String mongoPort;
    private String mongoUser;
    private String mongoPassword;
    private String mongoAuthDatabase;
    private String mongoConnectionMethod;
    private String findQuery;
    private boolean applySkipLimit;
    private boolean useCount;
    private boolean onlyCountParam;
    JsonEventWriter jew;
    private static IDecryptService DECRYPT_SERVICE;
    private static final String CONNECTION_CYPHER_KEY = "6C28CFE94E73B4AE8F332F8C36364C7BFA48E5ADD32D890535DBAA45B467A14B5F5DA89EECC73989D58533F29E7924E5FF0F50C9B04FB55BFFE3184493AB7E42";

    static {
        Converter<Long> dateTimeConverter = new Converter<Long>(){

            public void convert(Long arg0, StrictJsonWriter arg1) {
                if (arg0 != null) {
                    arg1.writeNumber(arg0.toString());
                }
            }
        };
        jsonWriterSettings = JsonWriterSettings.builder().dateTimeConverter((Converter)dateTimeConverter).build();
        DECRYPT_SERVICE = null;
    }

    private void getFieldNameAndType(Map map, Document resultingDoc) {
        for (Map.Entry pair : map.entrySet()) {
            this.getDatatype((String)pair.getKey(), pair.getValue(), resultingDoc);
        }
    }

    private void getDatatype(String key, Object val, Document resultingDoc) {
        if (val instanceof Map) {
            Document subDoc = new Document();
            this.getFieldNameAndType((Map)val, subDoc);
            resultingDoc.append(key, (Object)subDoc);
        } else if (val instanceof ArrayList) {
            Vector<Object> list = new Vector<Object>();
            for (Object el : (ArrayList)val) {
                if (el instanceof Map) {
                    Document subDoc = new Document();
                    this.getFieldNameAndType((Map)el, subDoc);
                    list.add(subDoc);
                    continue;
                }
                list.add(el);
            }
            resultingDoc.append(key, list);
        } else {
            resultingDoc.append(key, val);
        }
    }

    private Object getSubelementKeyVal(String key, Document dbObject) {
        Object val = dbObject;
        String[] stringArray = key.split("[.]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String currentPiece = stringArray[n2];
            if ((val = val.get((Object)currentPiece)) instanceof BsonDocument) {
                for (Map.Entry pair : ((BsonDocument)val).entrySet()) {
                    if (!pair.getKey().equals(currentPiece)) continue;
                    val = pair.getValue();
                    break;
                }
            } else if (val instanceof ArrayList) {
                Vector list = new Vector();
                for (Object el : (ArrayList)val) {
                    if (el instanceof Document) {
                        val = el;
                        break;
                    }
                    list.add(el);
                    val = list;
                }
            }
            ++n2;
        }
        return val;
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public MongoDBOperation(String mongoDBUrl, String mongoHost, String mongoPort, String mongoUser, String mongoPassword, String mongoAuthDatabase, String mongoConnectionMethod, String database, String collection, String updateKeys, Operator op, String query, int batchSize, boolean dropCollection, boolean deleteCollection, boolean applySkipLimit, boolean useCount) {
        this.mongoDBUrl = mongoDBUrl;
        this.mongoHost = mongoHost;
        this.mongoPort = mongoPort;
        this.mongoUser = mongoUser;
        this.mongoPassword = mongoPassword;
        this.mongoAuthDatabase = mongoAuthDatabase;
        this.mongoConnectionMethod = mongoConnectionMethod;
        this.database = database;
        this.collection = collection;
        this.op = op;
        this.batchSize = batchSize;
        this.dropCollection = dropCollection;
        this.deleteCollection = deleteCollection;
        this.findQuery = query;
        this.applySkipLimit = applySkipLimit;
        this.useCount = useCount;
        this.onlyCountParam = useCount;
        this.updateKeys = updateKeys != null && !updateKeys.isEmpty() ? this.untokenizeUpdateKeysString(updateKeys, ",") : new ArrayList<String>();
        if (this.updateKeys.size() == 0 && op != Operator.get && op != Operator.delete) {
            this.updateKeys.add("_id");
        }
    }

    private List<String> untokenizeUpdateKeysString(String updateKeys, String separetor) {
        return Arrays.asList(updateKeys.split(separetor));
    }

    public void execute(InputStream is, String encoding, OutputStream os, String outEncoding) throws Exception {
        if (this.op != Operator.nothing) {
            this.connectToMongoDb();
        }
        if (this.dropCollection) {
            MongoCollection collectionObject = this.mongoDatabase.getCollection(this.collection);
            collectionObject.drop();
        } else if (this.deleteCollection) {
            MongoCollection collectionObject = this.mongoDatabase.getCollection(this.collection);
            DeleteResult deleteResult = collectionObject.deleteMany((Bson)Document.parse((String)"{}"));
        }
        if (this.op == Operator.insert) {
            this.bulk(is, encoding, this._insertHandler, os, outEncoding);
        } else if (this.op == Operator.upsert || this.op == Operator.update) {
            this.bulk(is, encoding, this._upsertHandler, os, outEncoding);
        } else if (this.op == Operator.push) {
            this.bulk(is, encoding, this._pushHandler, os, outEncoding);
        } else if (this.op == Operator.addToSet) {
            this.bulk(is, encoding, this._addToSetHandler, os, outEncoding);
        } else if (this.op == Operator.nothing) {
            this.bulk(is, encoding, this._nothingHandler, os, outEncoding);
        } else if (this.op == Operator.get || this.op == Operator.delete) {
            this.bulk(is, encoding, this._getHandler, os, outEncoding);
        } else if (this.op == Operator.find) {
            this.bulk(is, encoding, this._findHandler, os, outEncoding);
        }
    }

    private void bulk(InputStream is, String encoding, JsonNodeToObject.JsonNodeToObjectHandler handler, OutputStream os, String outEncoding) throws Exception {
        if (this.already) {
            throw new RuntimeException(Messages.getString("MongoDBOperation.0"));
        }
        this.already = true;
        try {
            this.jew = new JsonEventWriter(os, outEncoding);
            this.jew.add(JSonEvent.createStartArray());
            this.writeHandler = new JsonNodeToObject.JsonNodeToObjectHandler(){
                boolean first = true;

                public void handleNode(Object node) {
                    try {
                        if (node instanceof String) {
                            if (!this.first) {
                                MongoDBOperation.this.jew.getWriter().write(",");
                            } else {
                                this.first = false;
                            }
                            MongoDBOperation.this.jew.getWriter().write((String)node);
                        } else {
                            JsonNode.serialize((Object)node, (JsonEventWriter)MongoDBOperation.this.jew);
                        }
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void handleEnd() {
                }
            };
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("DECIMAL_AS_DOUBLE", true);
            properties.put("INTEGER_AS_LONG", false);
            properties.put("PARSE_BSON_DATATYPE", true);
            properties.put("RESULT_AS_JSON_STRING", true);
            JsonUtils.jsonNodeToObject((InputStream)is, (String)encoding, (String)"*/*", (JsonNodeToObject.JsonNodeToObjectHandler)handler, properties);
            if (this.useCount && this.onlyCountParam) {
                MongoCollection collectionObject = this.mongoDatabase.getCollection(this.collection);
                long count = collectionObject.countDocuments();
                this.jew.add(JSonEvent.createStartObject());
                this.jew.add(JSonEvent.createMember((String)"count"));
                this.jew.add(JSonEvent.createValue((String)String.valueOf(count)));
                this.jew.add(JSonEvent.createEndObject());
            }
        }
        finally {
            try {
                this.jew.add(JSonEvent.createEndArray());
                this.jew.close();
            }
            catch (Exception exception) {}
            if (this.mongoClient != null) {
                this.mongoClient.close();
            }
        }
    }

    private void connectToMongoDb() throws Exception {
        if (this.mongoConnectionMethod.contentEquals("URL")) {
            this.uri = new MongoClientURI(this.mongoDBUrl);
            this.mongoClient = new MongoClient(this.uri);
        } else if (this.mongoConnectionMethod.contentEquals("UserPassword")) {
            if (this.mongoPassword != null && !this.mongoPassword.isEmpty()) {
                if (DECRYPT_SERVICE == null) {
                    DECRYPT_SERVICE = UtilsService.getDecryptService((String)"default");
                }
                char[] decrypt = DECRYPT_SERVICE.decrypt(CONNECTION_CYPHER_KEY, this.mongoPassword);
                this.mongoPassword = new String(decrypt);
            }
            MongoCredential credential = this.mongoAuthDatabase != null && !this.mongoAuthDatabase.isEmpty() ? MongoCredential.createCredential((String)this.mongoUser, (String)this.mongoAuthDatabase, (char[])this.mongoPassword.toCharArray()) : MongoCredential.createCredential((String)this.mongoUser, (String)"admin", (char[])this.mongoPassword.toCharArray());
            this.mongoClient = new MongoClient(new ServerAddress(this.mongoHost, Integer.parseInt(this.mongoPort)), credential, MongoClientOptions.builder().build());
        }
        this.mongoDatabase = this.mongoClient.getDatabase(this.database);
    }

    public abstract OutputStreamTransformer.OutputStreamTransformerStatisticHandler getHandler();

    private void javaObjectToBson(Object o, BsonWriter writer) {
        if (o == null) {
            writer.writeNull();
        } else if (o instanceof Map) {
            Map map = (Map)o;
            boolean done = false;
            if (map.size() == 1) {
                String key = (String)map.keySet().toArray()[0];
                if (key.equals("$date")) {
                    done = true;
                    Object value = map.get(key);
                    if (value != null) {
                        if (value instanceof String) {
                            l = Long.valueOf((String)value);
                            writer.writeDateTime(l);
                        } else if (value instanceof Long) {
                            l = (Long)value;
                            writer.writeDateTime(l);
                        }
                    }
                } else if (key.equals("$<>")) {
                    System.out.println();
                }
            }
            if (!done) {
                writer.writeStartDocument();
                for (String key : ((Map)o).keySet()) {
                    writer.writeName(key);
                    this.javaObjectToBson(((Map)o).get(key), writer);
                }
                writer.writeEndDocument();
            }
        } else if (o instanceof List) {
            writer.writeStartArray();
            for (Object _o : (List)o) {
                this.javaObjectToBson(_o, writer);
            }
            writer.writeEndArray();
        } else if (o instanceof String) {
            writer.writeString((String)o);
        } else if (o instanceof Boolean) {
            writer.writeBoolean(((Boolean)o).booleanValue());
        } else if (o instanceof Long) {
            writer.writeInt64(((Long)o).longValue());
        } else if (o instanceof Double) {
            writer.writeDouble(((Double)o).doubleValue());
        } else if (o instanceof Integer) {
            writer.writeDouble((double)((Integer)o).intValue());
        } else {
            System.out.println();
        }
    }

    private Map documentToMap(Document doc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : doc.keySet()) {
            map.put(key, doc.get((Object)key));
        }
        return map;
    }

    static enum Operator {
        insert,
        update,
        upsert,
        push,
        delete,
        nothing,
        get,
        addToSet,
        find;

    }
}

