/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb.test;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Vector;
import org.bson.Document;
import org.bson.conversions.Bson;

public class InsertOperation {
    private static String database = "test";
    private static String mongoDBUrl = "mongodb://127.0.0.1:27017";
    private static String collection = "insertTest";
    private static MongoClientURI uri;
    private static MongoClient mongoClient;
    private static MongoDatabase mongoDatabase;
    private static List<Document> allDocumentsToInsert;

    static {
        allDocumentsToInsert = new Vector<Document>();
    }

    public static void main(String[] args) throws Exception {
        uri = new MongoClientURI(mongoDBUrl);
        mongoClient = new MongoClient(uri);
        mongoDatabase = mongoClient.getDatabase(database);
        InsertOperation.loadJsonInList();
        InsertOperation.delete();
        InsertOperation.count();
        InsertOperation.insertOne();
        InsertOperation.count();
        InsertOperation.delete();
        InsertOperation.count();
        InsertOperation.insertMany();
        InsertOperation.count();
        InsertOperation.delete();
        InsertOperation.count();
        InsertOperation.loadListToGenerateError();
        try {
            InsertOperation.insertMany();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        InsertOperation.count();
        mongoClient.close();
    }

    private static void loadListToGenerateError() {
        System.out.println("Start loading into list");
        allDocumentsToInsert.clear();
        int i = 1;
        while (i < 100000) {
            int var = i;
            if (i == 5000) {
                var = 1;
            }
            allDocumentsToInsert.add(Document.parse((String)("{ \"_id\":" + var + ", \"web-app\": {" + "\"servlet\": [" + "{" + "\"servlet-name\": \"cofaxCDS\"," + "\"servlet-class\": \"org.cofax.cds.CDSServlet\"," + "\"init-param\": {" + "\"configGlossary_installationAt\": \"Philadelphia, PA\"," + "\"configGlossary_adminEmail\": \"ksm@pobox.com\"," + "\"configGlossary_poweredBy\": \"Cofax\"," + "\"configGlossary_poweredByIcon\": \"/images/cofax.gif\"," + "\"configGlossary_staticPath\": \"/content/static\"," + "\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\"," + "\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\"," + "\"templatePath\": \"templates\"," + "\"templateOverridePath\": \"\"," + "\"defaultListTemplate\": \"listTemplate.htm\"," + "\"defaultFileTemplate\": \"articleTemplate.htm\"," + "\"useJSP\": false," + "\"jspListTemplate\": \"listTemplate.jsp\"," + "\"jspFileTemplate\": \"articleTemplate.jsp\"," + "\"cachePackageTagsTrack\": " + i + "," + "\"cachePackageTagsStore\": 200," + "\"cachePackageTagsRefresh\": 60," + "\"cacheTemplatesTrack\": 100," + "\"cacheTemplatesStore\": 50," + "\"cacheTemplatesRefresh\": 15," + "\"cachePagesTrack\": 200," + "\"cachePagesStore\": 100," + "\"cachePagesRefresh\": 10," + "\"cachePagesDirtyRead\": 10," + "\"searchEngineListTemplate\": \"forSearchEnginesList.htm\"," + "\"searchEngineFileTemplate\": \"forSearchEngines.htm\"," + "\"searchEngineRobotsDb\": \"WEB-INF/robots.db\"," + "\"useDataStore\": true," + "\"dataStoreClass\": \"org.cofax.SqlDataStore\"," + "\"redirectionClass\": \"org.cofax.SqlRedirection\"," + "\"dataStoreName\": \"cofax\"," + "\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\"," + "\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\"," + "\"dataStoreUser\": \"sa\"," + "\"dataStorePassword\": \"dataStoreTestQuery\"," + "\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\"," + "\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\"," + "\"dataStoreInitConns\": 10," + "\"dataStoreMaxConns\": 100," + "\"dataStoreConnUsageLimit\": 100," + "\"dataStoreLogLevel\": \"debug\"," + "\"maxUrlLength\": 500}}," + "{" + "\"servlet-name\": \"cofaxEmail\"," + "\"servlet-class\": \"org.cofax.cds.EmailServlet\"," + "\"init-param\": {" + "\"mailHost\": \"mail1\"," + "\"mailHostOverride\": \"mail2\"}}," + "{" + "\"servlet-name\": \"cofaxAdmin\"," + "\"servlet-class\": \"org.cofax.cds.AdminServlet\"}," + "{" + "\"servlet-name\": \"fileServlet\"," + "\"servlet-class\": \"org.cofax.cds.FileServlet\"}," + "{" + "\"servlet-name\": \"cofaxTools\"," + "\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\"," + "\"init-param\": {" + "\"templatePath\": \"toolstemplates/\"," + "\"log\": 1," + "\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\"," + "\"logMaxSize\": \"\"," + "\"dataLog\": 1," + "\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\"," + "\"dataLogMaxSize\": \"\"," + "\"removePageCache\": \"/content/admin/remove?cache=pages&id=\"," + "\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\"," + "\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\"," + "\"lookInContext\": 1," + "\"adminGroupID\": 4," + "\"betaServer\": true}}]," + "\"servlet-mapping\": {" + "\"cofaxCDS\": \"/\"," + "\"cofaxEmail\": \"/cofaxutil/aemail/*\"," + "\"cofaxAdmin\": \"/admin/*\"," + "\"fileServlet\": \"/static/*\"," + "\"cofaxTools\": \"/tools/*\"}," + "\"taglib\": {" + "\"taglib-uri\": \"cofax.tld\"," + "\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}")));
            ++i;
        }
        System.out.println("Finished loading into list");
    }

    private static void loadJsonInList() {
        System.out.println("Start loading into list");
        allDocumentsToInsert.clear();
        int i = 1;
        while (i < 100000) {
            allDocumentsToInsert.add(Document.parse((String)("{ \"_id\":" + i + ", \"web-app\": {" + "\"servlet\": [" + "{" + "\"servlet-name\": \"cofaxCDS\"," + "\"servlet-class\": \"org.cofax.cds.CDSServlet\"," + "\"init-param\": {" + "\"configGlossary_installationAt\": \"Philadelphia, PA\"," + "\"configGlossary_adminEmail\": \"ksm@pobox.com\"," + "\"configGlossary_poweredBy\": \"Cofax\"," + "\"configGlossary_poweredByIcon\": \"/images/cofax.gif\"," + "\"configGlossary_staticPath\": \"/content/static\"," + "\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\"," + "\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\"," + "\"templatePath\": \"templates\"," + "\"templateOverridePath\": \"\"," + "\"defaultListTemplate\": \"listTemplate.htm\"," + "\"defaultFileTemplate\": \"articleTemplate.htm\"," + "\"useJSP\": false," + "\"jspListTemplate\": \"listTemplate.jsp\"," + "\"jspFileTemplate\": \"articleTemplate.jsp\"," + "\"cachePackageTagsTrack\": " + i + "," + "\"cachePackageTagsStore\": 200," + "\"cachePackageTagsRefresh\": 60," + "\"cacheTemplatesTrack\": 100," + "\"cacheTemplatesStore\": 50," + "\"cacheTemplatesRefresh\": 15," + "\"cachePagesTrack\": 200," + "\"cachePagesStore\": 100," + "\"cachePagesRefresh\": 10," + "\"cachePagesDirtyRead\": 10," + "\"searchEngineListTemplate\": \"forSearchEnginesList.htm\"," + "\"searchEngineFileTemplate\": \"forSearchEngines.htm\"," + "\"searchEngineRobotsDb\": \"WEB-INF/robots.db\"," + "\"useDataStore\": true," + "\"dataStoreClass\": \"org.cofax.SqlDataStore\"," + "\"redirectionClass\": \"org.cofax.SqlRedirection\"," + "\"dataStoreName\": \"cofax\"," + "\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\"," + "\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\"," + "\"dataStoreUser\": \"sa\"," + "\"dataStorePassword\": \"dataStoreTestQuery\"," + "\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\"," + "\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\"," + "\"dataStoreInitConns\": 10," + "\"dataStoreMaxConns\": 100," + "\"dataStoreConnUsageLimit\": 100," + "\"dataStoreLogLevel\": \"debug\"," + "\"maxUrlLength\": 500}}," + "{" + "\"servlet-name\": \"cofaxEmail\"," + "\"servlet-class\": \"org.cofax.cds.EmailServlet\"," + "\"init-param\": {" + "\"mailHost\": \"mail1\"," + "\"mailHostOverride\": \"mail2\"}}," + "{" + "\"servlet-name\": \"cofaxAdmin\"," + "\"servlet-class\": \"org.cofax.cds.AdminServlet\"}," + "{" + "\"servlet-name\": \"fileServlet\"," + "\"servlet-class\": \"org.cofax.cds.FileServlet\"}," + "{" + "\"servlet-name\": \"cofaxTools\"," + "\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\"," + "\"init-param\": {" + "\"templatePath\": \"toolstemplates/\"," + "\"log\": 1," + "\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\"," + "\"logMaxSize\": \"\"," + "\"dataLog\": 1," + "\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\"," + "\"dataLogMaxSize\": \"\"," + "\"removePageCache\": \"/content/admin/remove?cache=pages&id=\"," + "\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\"," + "\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\"," + "\"lookInContext\": 1," + "\"adminGroupID\": 4," + "\"betaServer\": true}}]," + "\"servlet-mapping\": {" + "\"cofaxCDS\": \"/\"," + "\"cofaxEmail\": \"/cofaxutil/aemail/*\"," + "\"cofaxAdmin\": \"/admin/*\"," + "\"fileServlet\": \"/static/*\"," + "\"cofaxTools\": \"/tools/*\"}," + "\"taglib\": {" + "\"taglib-uri\": \"cofax.tld\"," + "\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}")));
            ++i;
        }
        System.out.println("Finished loading into list");
    }

    private static void insertOne() {
        System.out.println("Start insert one approach");
        long l = System.currentTimeMillis();
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        for (Document singleDoc : allDocumentsToInsert) {
            collectionObject.insertOne((Object)singleDoc);
        }
        long duration = (System.currentTimeMillis() - l) / 1000L;
        System.out.println(String.valueOf(duration) + " sec");
    }

    private static void insertMany() {
        System.out.println("Start insert many approach");
        long l = System.currentTimeMillis();
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.insertMany(allDocumentsToInsert);
        long duration = (System.currentTimeMillis() - l) / 1000L;
        System.out.println(String.valueOf(duration) + " sec");
    }

    private static void delete() {
        System.out.println("Start delete");
        Document filter = Document.parse((String)"{}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.deleteMany((Bson)filter);
        for (Document doc : collectionObject.find()) {
            System.out.println("dopo remove: " + doc.toJson());
        }
        System.out.println("Stop delete");
    }

    private static void count() {
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        System.out.println("number of objects: " + collectionObject.countDocuments());
    }
}

